/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.SelectionMethod;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;

public abstract class BreedingPipeline
extends BreedingSource
implements SteadyStateBSourceForm {
    public static final String V_SAME = "same";
    public static final String P_LIKELIHOOD = "likelihood";
    public static final int DYNAMIC_SOURCES = 0;
    public static final String P_NUMSOURCES = "num-sources";
    public static final String P_SOURCE = "source";
    public Parameter mybase;
    public float likelihood;
    public BreedingSource[] sources;
    static /* synthetic */ Class class$ec$BreedingSource;

    public abstract int numSources();

    public int minChildProduction() {
        if (this.sources.length == 0) {
            return 0;
        }
        int min = this.sources[0].typicalIndsProduced();
        for (int x = 1; x < this.sources.length; ++x) {
            int cur = this.sources[x].typicalIndsProduced();
            if (min <= cur) continue;
            min = cur;
        }
        return min;
    }

    public int maxChildProduction() {
        if (this.sources.length == 0) {
            return 0;
        }
        int max = this.sources[0].typicalIndsProduced();
        for (int x = 1; x < this.sources.length; ++x) {
            int cur = this.sources[x].typicalIndsProduced();
            if (max >= cur) continue;
            max = cur;
        }
        return max;
    }

    public int typicalIndsProduced() {
        return this.minChildProduction();
    }

    public void setup(EvolutionState state, Parameter base) {
        int numsources;
        super.setup(state, base);
        this.mybase = base;
        Parameter def = this.defaultBase();
        this.likelihood = state.parameters.getFloatWithDefault(base.push(P_LIKELIHOOD), def.push(P_LIKELIHOOD), 1.0);
        if (this.likelihood < 0.0f || this.likelihood > 1.0f) {
            state.output.fatal("Breeding Pipeline likelihood must be a value between 0.0 and 1.0 inclusive", base.push(P_LIKELIHOOD), def.push(P_LIKELIHOOD));
        }
        if ((numsources = this.numSources()) <= 0 && (numsources = state.parameters.getInt(base.push(P_NUMSOURCES), def.push(P_NUMSOURCES), 1)) == 0) {
            state.output.fatal("Breeding pipeline num-sources value must be > 0", base.push(P_NUMSOURCES), def.push(P_NUMSOURCES));
        }
        this.sources = new BreedingSource[numsources];
        for (int x = 0; x < this.sources.length; ++x) {
            Parameter d;
            Parameter p = base.push(P_SOURCE).push("" + x);
            String s = state.parameters.getString(p, d = def.push(P_SOURCE).push("" + x));
            if (s != null && s.equals(V_SAME)) {
                if (x == 0) {
                    state.output.fatal("Source #0 cannot be declared with the value \"same\".", p, d);
                }
                this.sources[x] = this.sources[x - 1];
                continue;
            }
            this.sources[x] = (BreedingSource)state.parameters.getInstanceForParameter(p, d, class$ec$BreedingSource == null ? BreedingPipeline.class$("ec.BreedingSource") : class$ec$BreedingSource);
            this.sources[x].setup(state, p);
        }
        state.output.exitIfErrors();
    }

    public Object clone() {
        BreedingPipeline c = (BreedingPipeline)super.clone();
        c.sources = new BreedingSource[this.sources.length];
        for (int x = 0; x < this.sources.length; ++x) {
            c.sources[x] = x == 0 || this.sources[x] != this.sources[x - 1] ? (BreedingSource)this.sources[x].clone() : c.sources[x - 1];
        }
        return c;
    }

    public int reproduce(int n, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread, boolean produceChildrenFromSource) {
        if (produceChildrenFromSource) {
            this.sources[0].produce(n, n, start, subpopulation, inds, state, thread);
        }
        if (this.sources[0] instanceof SelectionMethod) {
            for (int q = start; q < n + start; ++q) {
                inds[q] = (Individual)inds[q].clone();
            }
        }
        return n;
    }

    public boolean produces(EvolutionState state, Population newpop, int subpopulation, int thread) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (x != 0 && this.sources[x] == this.sources[x - 1] || this.sources[x].produces(state, newpop, subpopulation, thread)) continue;
            return false;
        }
        return true;
    }

    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (x != 0 && this.sources[x] == this.sources[x - 1]) continue;
            this.sources[x].prepareToProduce(state, subpopulation, thread);
        }
    }

    public void finishProducing(EvolutionState state, int subpopulation, int thread) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (x != 0 && this.sources[x] == this.sources[x - 1]) continue;
            this.sources[x].finishProducing(state, subpopulation, thread);
        }
    }

    public void preparePipeline(Object hook) {
        for (int x = 0; x < this.sources.length; ++x) {
            this.sources[x].preparePipeline(hook);
        }
    }

    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
        for (int x = 0; x < this.sources.length; ++x) {
            ((SteadyStateBSourceForm)((Object)this.sources[x])).individualReplaced(state, subpopulation, thread, individual);
        }
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState state) {
        for (int x = 0; x < this.sources.length; ++x) {
            if (!(this.sources[x] instanceof SteadyStateBSourceForm)) {
                state.output.error("The following breeding source is not of SteadyStateBSourceForm.", this.mybase.push(P_SOURCE).push("" + x), this.defaultBase().push(P_SOURCE).push("" + x));
                continue;
            }
            ((SteadyStateBSourceForm)((Object)this.sources[x])).sourcesAreProperForm(state);
        }
    }
}

