/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.ECDefaults;
import ec.EvolutionState;
import ec.Group;
import ec.Individual;
import ec.Species;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Subpopulation
implements Group {
    public File loadInds;
    public Species species;
    public Individual[] individuals;
    public int numDuplicateRetries;
    public static final String P_SUBPOPULATION = "subpop";
    public static final String P_FILE = "file";
    public static final String P_SUBPOPSIZE = "size";
    public static final String P_SPECIES = "species";
    public static final String P_RETRIES = "duplicate-retries";
    public static final String NUM_INDIVIDUALS_PREAMBLE = "Number of Individuals: ";
    public static final String INDIVIDUAL_INDEX_PREAMBLE = "Individual Number: ";

    public Parameter defaultBase() {
        return ECDefaults.base().push(P_SUBPOPULATION);
    }

    public Group emptyClone() {
        try {
            Subpopulation p = (Subpopulation)this.clone();
            p.species = this.species;
            p.individuals = new Individual[this.individuals.length];
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.loadInds = state.parameters.getFile(base.push(P_FILE), null);
        this.species = (Species)state.parameters.getInstanceForParameter(base.push(P_SPECIES), def.push(P_SPECIES), Species.class);
        this.species.setup(state, base.push(P_SPECIES));
        int size = state.parameters.getInt(base.push(P_SUBPOPSIZE), def.push(P_SUBPOPSIZE), 1);
        if (size <= 0) {
            state.output.fatal("Subpopulation size must be an integer >= 1.\n", base.push(P_SUBPOPSIZE), def.push(P_SUBPOPSIZE));
        }
        this.numDuplicateRetries = state.parameters.getInt(base.push(P_RETRIES), def.push(P_RETRIES), 0);
        if (this.numDuplicateRetries < 0) {
            state.output.fatal("The number of retries for duplicates must be an integer >= 0.\n", base.push(P_RETRIES), def.push(P_RETRIES));
        }
        this.individuals = new Individual[size];
    }

    public void populate(EvolutionState state, int thread) {
        if (this.loadInds != null) {
            try {
                this.readSubpopulation(state, new LineNumberReader(new FileReader(this.loadInds)));
            }
            catch (IOException e) {
                state.output.fatal("An IOException occurred when trying to read from the file " + this.loadInds + ".  The IOException was: \n" + e);
            }
        } else {
            Hashtable<Individual, Individual> h = null;
            if (this.numDuplicateRetries >= 1) {
                h = new Hashtable<Individual, Individual>(this.individuals.length / 2);
            }
            block2: for (int x = 0; x < this.individuals.length; ++x) {
                for (int tries = 0; tries <= this.numDuplicateRetries; ++tries) {
                    Object o;
                    this.individuals[x] = this.species.newIndividual(state, thread);
                    if (this.numDuplicateRetries < 1 || (o = h.get(this.individuals[x])) != null) continue;
                    h.put(this.individuals[x], this.individuals[x]);
                    continue block2;
                }
            }
        }
    }

    public final void printSubpopulationForHumans(EvolutionState state, int log, int verbosity) {
        this.printSubpopulationForHumans(state, log);
    }

    public final void printSubpopulation(EvolutionState state, int log, int verbosity) {
        this.printSubpopulation(state, log);
    }

    public void printSubpopulationForHumans(EvolutionState state, int log) {
        state.output.println(NUM_INDIVIDUALS_PREAMBLE + this.individuals.length, log);
        for (int i = 0; i < this.individuals.length; ++i) {
            state.output.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i), log);
            this.individuals[i].printIndividualForHumans(state, log);
        }
    }

    public void printSubpopulation(EvolutionState state, int log) {
        state.output.println(NUM_INDIVIDUALS_PREAMBLE + Code.encode(this.individuals.length), log);
        for (int i = 0; i < this.individuals.length; ++i) {
            state.output.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i), log);
            this.individuals[i].printIndividual(state, log);
        }
    }

    public void printSubpopulation(EvolutionState state, PrintWriter writer) {
        writer.println(NUM_INDIVIDUALS_PREAMBLE + Code.encode(this.individuals.length));
        for (int i = 0; i < this.individuals.length; ++i) {
            writer.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(i));
            this.individuals[i].printIndividual(state, writer);
        }
    }

    public void readSubpopulation(EvolutionState state, LineNumberReader reader) throws IOException {
        int numIndividuals = Code.readIntegerWithPreamble(NUM_INDIVIDUALS_PREAMBLE, state, reader);
        if (numIndividuals != this.individuals.length) {
            state.output.warnOnce("On reading subpopulation from text stream, the subpopulation size didn't match.\nHad to resize and use newIndividual() instead of readIndividual().");
            this.individuals = new Individual[numIndividuals];
            for (int i = 0; i < this.individuals.length; ++i) {
                int j = Code.readIntegerWithPreamble(INDIVIDUAL_INDEX_PREAMBLE, state, reader);
                if (j != i) {
                    state.output.warnOnce("On reading subpopulation from text stream, some individual indexes in the subpopulation did not match.");
                }
                this.individuals[i] = this.species.newIndividual(state, reader);
            }
        } else {
            for (int i = 0; i < this.individuals.length; ++i) {
                int j = Code.readIntegerWithPreamble(INDIVIDUAL_INDEX_PREAMBLE, state, reader);
                if (j != i) {
                    state.output.warnOnce("On reading subpopulation from text stream, some individual indexes in the subpopulation did not match.");
                }
                if (this.individuals[i] != null) {
                    this.individuals[i].readIndividual(state, reader);
                    continue;
                }
                state.output.warnOnce("On reading subpopulation from text stream, some of the preexisting subpopulation's slots were null.\nHad to use newIndividual() instead of readIndividual().  If you're starting an evolutionary run by reading an\nexisting population from a file, this is expected -- ignore this message.");
                this.individuals[i] = this.species.newIndividual(state, reader);
            }
        }
    }

    public void writeSubpopulation(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.individuals.length);
        for (int i = 0; i < this.individuals.length; ++i) {
            this.individuals[i].writeIndividual(state, dataOutput);
        }
    }

    public void readSubpopulation(EvolutionState state, DataInput dataInput) throws IOException {
        int numIndividuals = dataInput.readInt();
        if (numIndividuals != this.individuals.length) {
            state.output.warnOnce("On reading subpopulation from binary stream, the subpopulation size was incorrect.\nHad to resize and use newIndividual() instead of readIndividual().");
            this.individuals = new Individual[numIndividuals];
            for (int i = 0; i < this.individuals.length; ++i) {
                this.individuals[i] = this.species.newIndividual(state, dataInput);
            }
        } else {
            for (int i = 0; i < this.individuals.length; ++i) {
                this.individuals[i].readIndividual(state, dataInput);
            }
        }
    }
}

