/*
 * Decompiled with CFR 0.152.
 */
package ec.app.bbob;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.vector.DoubleVectorIndividual;

public class BBOBenchmarks
extends Problem
implements SimpleProblemForm {
    public static final String P_GENOME_SIZE = "genome-size";
    public static final String P_WHICH_PROBLEM = "type";
    public static final String P_NOISE = "noise";
    public final String[] problemTypes = new String[]{"sphere", "ellipsoidal", "rastrigin", "buche-rastrigin", "linear-slope", "attractive-sector", "step-ellipsoidal", "rosenbrock", "rosenbrock-rotated", "ellipsoidal-2", "discus", "bent-cigar", "sharp-ridge", "different-powers", "rastrigin-2", "weierstrass", "schaffers-f7", "schaffers-f7-2", "griewank-rosenbrock", "schwefel", "gallagher-gaussian-101me", "gallagher-gaussian-21hi", "katsuura", "lunacek"};
    public static final int SPHERE = 0;
    public static final int ELLIPSOIDAL = 1;
    public static final int RASTRIGIN = 2;
    public static final int BUCHE_RASTRIGIN = 3;
    public static final int LINEAR_SLOPE = 4;
    public static final int ATTRACTIVE_SECTOR = 5;
    public static final int STEP_ELLIPSOIDAL = 6;
    public static final int ROSENBROCK = 7;
    public static final int ROSENBROCK_ROTATED = 8;
    public static final int ELLIPSOIDAL_2 = 9;
    public static final int DISCUS = 10;
    public static final int BENT_CIGAR = 11;
    public static final int SHARP_RIDGE = 12;
    public static final int DIFFERENT_POWERS = 13;
    public static final int RASTRIGIN_2 = 14;
    public static final int WEIERSTRASS = 15;
    public static final int SCHAFFERS_F7 = 16;
    public static final int SCHAFFERS_F7_2 = 17;
    public static final int GRIEWANK_ROSENBROCK = 18;
    public static final int SCHWEFEL = 19;
    public static final int GALLAGHER_GAUSSIAN_101ME = 20;
    public static final int GALLAGHER_GAUSSIAN_21HI = 21;
    public static final int KATSUURA = 22;
    public static final int LUNACEK = 23;
    public final String[] noiseTypes = new String[]{"none", "gauss", "uniform", "cauchy", "gauss-moderate", "uniform-moderate", "cauchy-moderate"};
    public static final int NONE = 0;
    public static final int GAUSSIAN = 1;
    public static final int UNIFORM = 2;
    public static final int CAUCHY = 3;
    public static final int GAUSSIAN_MODERATE = 4;
    public static final int UNIFORM_MODERATE = 5;
    public static final int CAUCHY_MODERATE = 6;
    public int problemType = 0;
    public int noise = 0;
    public final int NHIGHPEAKS21 = 101;
    public final int NHIGHPEAKS22 = 21;
    double fOpt;
    double[] xOpt;
    double fAdd_Init;
    double f0;
    double[][] rotation;
    double[][] rot2;
    double[][] linearTF;
    double[] peaks21;
    double[] peaks22;
    int[] rperm;
    int[] rperm21;
    int[] rperm22;
    double[][] xLocal;
    double[][] xLocal21;
    double[][] xLocal22;
    double[][] arrScales;
    double[][] arrScales21;
    double[][] arrScales22;
    double[] aK;
    double[] bK;
    double[] peakvalues;
    double scales;
    public static final double TOL = 1.0E-8;

    public void setup(EvolutionState state, Parameter base) {
        int i;
        super.setup(state, base);
        String wp = state.parameters.getStringWithDefault(base.push(P_WHICH_PROBLEM), null, "");
        Parameter p = new Parameter("pop");
        int genomeSize = state.parameters.getInt(p.push("subpop").push("0").push("species").push(P_GENOME_SIZE), null, 1);
        String noiseStr = state.parameters.getString(new Parameter(P_NOISE), null);
        for (i = 0; i < this.noiseTypes.length; ++i) {
            if (!noiseStr.equals(this.noiseTypes[i])) continue;
            this.noise = i;
        }
        double condition = 10.0;
        double alpha = 100.0;
        double[] fitValues = new double[]{1.1, 9.1};
        for (i = 0; i < this.problemTypes.length; ++i) {
            if (!wp.equals(this.problemTypes[i])) continue;
            this.problemType = i;
        }
        this.fOpt = this.computeFopt(state.random[0]);
        this.xOpt = new double[genomeSize];
        switch (this.problemType) {
            case 0: {
                this.computeXopt(this.xOpt, state.random[0]);
                break;
            }
            case 1: {
                this.computeXopt(this.xOpt, state.random[0]);
                this.rotation = new double[genomeSize][genomeSize];
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                if (this.noise == 0) break;
                this.rot2 = new double[genomeSize][genomeSize];
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                break;
            }
            case 2: {
                this.computeXopt(this.xOpt, state.random[0]);
                break;
            }
            case 3: {
                this.computeXopt(this.xOpt, state.random[0]);
                for (i = 0; i < genomeSize; i += 2) {
                    this.xOpt[i] = Math.abs(this.xOpt[i]);
                }
                break;
            }
            case 4: {
                this.computeXopt(this.xOpt, state.random[0]);
                for (i = 0; i < genomeSize; ++i) {
                    double tmp = Math.pow(Math.sqrt(alpha), (double)i / (double)(genomeSize - 1));
                    if (this.xOpt[i] > 0.0) {
                        this.xOpt[i] = 5.0;
                    } else if (this.xOpt[i] < 0.0) {
                        this.xOpt[i] = -5.0;
                    }
                    this.fAdd_Init += 5.0 * tmp;
                }
                break;
            }
            case 5: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                this.linearTF = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                for (i = 0; i < genomeSize; ++i) {
                    for (int j = 0; j < genomeSize; ++j) {
                        this.linearTF[i][j] = 0.0;
                        for (int k = 0; k < genomeSize; ++k) {
                            double[] dArray = this.linearTF[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.rotation[i][k] * Math.pow(Math.sqrt(condition), (double)k / (double)(genomeSize - 1)) * this.rot2[k][j];
                        }
                    }
                }
                break;
            }
            case 6: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                break;
            }
            case 7: {
                this.computeXopt(this.xOpt, state.random[0]);
                this.scales = Math.max(1.0, Math.sqrt(genomeSize) / 8.0);
                if (this.noise != 0) break;
                i = 0;
                while (i < genomeSize) {
                    int n = i++;
                    this.xOpt[n] = this.xOpt[n] * 0.75;
                }
                break;
            }
            case 8: {
                this.linearTF = new double[genomeSize][genomeSize];
                this.rotation = new double[genomeSize][genomeSize];
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.scales = Math.max(1.0, Math.sqrt(genomeSize) / 8.0);
                for (i = 0; i < genomeSize; ++i) {
                    for (int j = 0; j < genomeSize; ++j) {
                        this.linearTF[i][j] = this.scales * this.rotation[i][j];
                    }
                }
                break;
            }
            case 9: {
                this.rotation = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                break;
            }
            case 10: {
                this.rotation = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                break;
            }
            case 11: {
                this.rotation = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                break;
            }
            case 12: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                this.linearTF = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                for (i = 0; i < genomeSize; ++i) {
                    for (int j = 0; j < genomeSize; ++j) {
                        this.linearTF[i][j] = 0.0;
                        for (int k = 0; k < genomeSize; ++k) {
                            double[] dArray = this.linearTF[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.rotation[i][k] * Math.pow(Math.sqrt(condition), (double)k / (double)(genomeSize - 1)) * this.rot2[k][j];
                        }
                    }
                }
                break;
            }
            case 13: {
                this.rotation = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                break;
            }
            case 14: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                this.linearTF = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                for (i = 0; i < genomeSize; ++i) {
                    for (int j = 0; j < genomeSize; ++j) {
                        this.linearTF[i][j] = 0.0;
                        for (int k = 0; k < genomeSize; ++k) {
                            double[] dArray = this.linearTF[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.rotation[i][k] * Math.pow(Math.sqrt(condition), (double)k / (double)(genomeSize - 1)) * this.rot2[k][j];
                        }
                    }
                }
                break;
            }
            case 15: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                this.linearTF = new double[genomeSize][genomeSize];
                this.aK = new double[12];
                this.bK = new double[12];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                for (i = 0; i < genomeSize; ++i) {
                    for (int j = 0; j < genomeSize; ++j) {
                        this.linearTF[i][j] = 0.0;
                        for (int k = 0; k < genomeSize; ++k) {
                            double[] dArray = this.linearTF[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.rotation[i][k] * Math.pow(1.0 / Math.sqrt(condition), (double)k / (double)(genomeSize - 1)) * this.rot2[k][j];
                        }
                    }
                }
                this.f0 = 0.0;
                for (i = 0; i < 12; ++i) {
                    this.aK[i] = Math.pow(0.5, i);
                    this.bK[i] = Math.pow(3.0, i);
                    this.f0 += this.aK[i] * Math.cos(Math.PI * 2 * this.bK[i] * 0.5);
                }
                break;
            }
            case 16: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                break;
            }
            case 17: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                this.linearTF = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                break;
            }
            case 18: {
                int j;
                this.rotation = new double[genomeSize][genomeSize];
                this.scales = Math.max(1.0, Math.sqrt(genomeSize) / 8.0);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                if (this.noise != 0) break;
                this.rot2 = new double[genomeSize][genomeSize];
                this.linearTF = new double[genomeSize][genomeSize];
                for (i = 0; i < genomeSize; ++i) {
                    for (j = 0; j < genomeSize; ++j) {
                        this.linearTF[i][j] = this.scales * this.rotation[i][j];
                    }
                }
                for (i = 0; i < genomeSize; ++i) {
                    this.xOpt[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        this.xOpt[n] = this.xOpt[n] + this.linearTF[j][i] * 0.5 / this.scales / this.scales;
                    }
                }
                break;
            }
            case 19: {
                double[] tmpvect = new double[genomeSize];
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = this.nextDoubleClosedInterval(state.random[0]);
                }
                for (i = 0; i < genomeSize; ++i) {
                    this.xOpt[i] = 2.10484373165;
                    if (!(tmpvect[i] - 0.5 < 0.0)) continue;
                    int n = i;
                    this.xOpt[n] = this.xOpt[n] * -1.0;
                }
                break;
            }
            case 20: {
                int j;
                this.rotation = new double[genomeSize][genomeSize];
                double maxCondition = 1000.0;
                double[] arrCondition = new double[101];
                this.peaks21 = new double[genomeSize * 101];
                this.rperm21 = new int[Math.max(genomeSize, 101)];
                double[] peaks = this.peaks21;
                this.peakvalues = new double[101];
                this.arrScales21 = new double[101][genomeSize];
                this.xLocal21 = new double[genomeSize][101];
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                for (i = 0; i < 100; ++i) {
                    peaks[i] = this.nextDoubleClosedInterval(state.random[0]);
                }
                this.rperm = this.rperm21;
                for (i = 0; i < 100; ++i) {
                    this.rperm[i] = i;
                }
                QuickSort.qsort(this.rperm);
                arrCondition[0] = Math.sqrt(maxCondition);
                this.peakvalues[0] = 10.0;
                for (i = 1; i < 101; ++i) {
                    arrCondition[i] = Math.pow(maxCondition, (double)this.rperm[i - 1] / 99.0);
                    this.peakvalues[i] = (double)(i - 1) / 99.0 * (fitValues[1] - fitValues[0]) + fitValues[0];
                }
                this.arrScales = this.arrScales21;
                for (i = 0; i < 101; ++i) {
                    for (j = 0; j < genomeSize; ++j) {
                        peaks[j] = this.nextDoubleClosedInterval(state.random[0]);
                    }
                    for (j = 0; j < genomeSize; ++j) {
                        this.rperm[j] = j;
                    }
                    QuickSort.qsort(this.rperm);
                    for (j = 0; j < genomeSize; ++j) {
                        this.arrScales[i][j] = Math.pow(arrCondition[i], (double)this.rperm[j] / (double)(genomeSize - 1) - 0.5);
                    }
                }
                for (i = 0; i < genomeSize * 101; ++i) {
                    peaks[i] = this.nextDoubleClosedInterval(state.random[0]);
                }
                this.xLocal = this.xLocal21;
                for (i = 0; i < genomeSize; ++i) {
                    this.xOpt[i] = 0.8 * (10.0 * peaks[i] - 5.0);
                    for (j = 0; j < 101; ++j) {
                        this.xLocal[i][j] = 0.0;
                        for (int k = 0; k < genomeSize; ++k) {
                            double[] dArray = this.xLocal[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.rotation[i][k] * (10.0 * peaks[j * genomeSize + k] - 5.0);
                        }
                        if (j != 0) continue;
                        double[] dArray = this.xLocal[i];
                        int n = j;
                        dArray[n] = dArray[n] * 0.8;
                    }
                }
                break;
            }
            case 21: {
                int j;
                this.rotation = new double[genomeSize][genomeSize];
                double maxCondition = 1000.0;
                double[] arrCondition = new double[21];
                this.peaks22 = new double[genomeSize * 21];
                this.rperm22 = new int[Math.max(genomeSize, 21)];
                this.arrScales22 = new double[21][genomeSize];
                this.xLocal22 = new double[genomeSize][21];
                double[] peaks = this.peaks22;
                this.peakvalues = new double[21];
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                peaks = this.peaks22;
                for (i = 0; i < 20; ++i) {
                    peaks[i] = this.nextDoubleClosedInterval(state.random[0]);
                }
                this.rperm = this.rperm22;
                for (i = 0; i < 20; ++i) {
                    this.rperm[i] = i;
                }
                QuickSort.qsort(this.rperm);
                arrCondition[0] = maxCondition;
                this.peakvalues[0] = 10.0;
                for (i = 1; i < 21; ++i) {
                    arrCondition[i] = Math.pow(maxCondition, (double)this.rperm[i - 1] / 19.0);
                    this.peakvalues[i] = (double)(i - 1) / 19.0 * (fitValues[1] - fitValues[0]) + fitValues[0];
                }
                this.arrScales = this.arrScales22;
                for (i = 0; i < 21; ++i) {
                    for (j = 0; j < genomeSize; ++j) {
                        peaks[j] = this.nextDoubleClosedInterval(state.random[0]);
                    }
                    for (j = 0; j < genomeSize; ++j) {
                        this.rperm[j] = j;
                    }
                    QuickSort.qsort(this.rperm);
                    for (j = 0; j < genomeSize; ++j) {
                        this.arrScales[i][j] = Math.pow(arrCondition[i], (double)this.rperm[j] / (double)(genomeSize - 1) - 0.5);
                    }
                }
                for (i = 0; i < genomeSize * 21; ++i) {
                    peaks[i] = this.nextDoubleClosedInterval(state.random[0]);
                }
                this.xLocal = this.xLocal22;
                for (i = 0; i < genomeSize; ++i) {
                    this.xOpt[i] = 0.8 * (9.8 * peaks[i] - 4.9);
                    for (j = 0; j < 21; ++j) {
                        this.xLocal[i][j] = 0.0;
                        for (int k = 0; k < genomeSize; ++k) {
                            double[] dArray = this.xLocal[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.rotation[i][k] * (9.8 * peaks[j * genomeSize + k] - 4.9);
                        }
                        if (j != 0) continue;
                        double[] dArray = this.xLocal[i];
                        int n = j;
                        dArray[n] = dArray[n] * 0.8;
                    }
                }
                break;
            }
            case 22: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                this.linearTF = new double[genomeSize][genomeSize];
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                for (i = 0; i < genomeSize; ++i) {
                    for (int j = 0; j < genomeSize; ++j) {
                        this.linearTF[i][j] = 0.0;
                        for (int k = 0; k < genomeSize; ++k) {
                            double[] dArray = this.linearTF[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.rotation[i][k] * Math.pow(Math.sqrt(condition), (double)k / (double)(genomeSize - 1)) * this.rot2[k][j];
                        }
                    }
                }
                break;
            }
            case 23: {
                this.rotation = new double[genomeSize][genomeSize];
                this.rot2 = new double[genomeSize][genomeSize];
                double[] tmpvect = new double[genomeSize];
                this.linearTF = new double[genomeSize][genomeSize];
                double mu1 = 2.5;
                this.computeXopt(this.xOpt, state.random[0]);
                this.computeRotation(this.rotation, state.random[0], genomeSize);
                this.computeRotation(this.rot2, state.random[0], genomeSize);
                this.gauss(tmpvect, state.random[0]);
                for (i = 0; i < genomeSize; ++i) {
                    this.xOpt[i] = 0.5 * mu1;
                    if (!(tmpvect[i] < 0.0)) continue;
                    int n = i;
                    this.xOpt[n] = this.xOpt[n] * -1.0;
                }
                for (i = 0; i < genomeSize; ++i) {
                    for (int j = 0; j < genomeSize; ++j) {
                        this.linearTF[i][j] = 0.0;
                        for (int k = 0; k < genomeSize; ++k) {
                            double[] dArray = this.linearTF[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.rotation[i][k] * Math.pow(Math.sqrt(condition), (double)k / (double)(genomeSize - 1)) * this.rot2[k][j];
                        }
                    }
                }
                break;
            }
            default: {
                String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                for (i = 0; i < this.problemTypes.length; ++i) {
                    outputStr = outputStr + this.problemTypes[i] + "\n";
                }
                state.output.fatal(outputStr, base.push(P_WHICH_PROBLEM));
            }
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!(ind instanceof DoubleVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be DoubleVectorIndividuals.");
        }
        DoubleVectorIndividual temp = (DoubleVectorIndividual)ind;
        double[] genome = temp.genome;
        int genomeSize = genome.length;
        double value = 0.0;
        double tmp = 0.0;
        double fPen = 0.0;
        double f = 0.0;
        double[] tmx = new double[genomeSize];
        double[] tmpvect = new double[genomeSize];
        switch (this.problemType) {
            case 0: {
                int i;
                double fAdd = this.fOpt;
                if (this.noise != 0) {
                    for (i = 0; i < genomeSize; ++i) {
                        tmp = Math.abs(genome[i]) - 5.0;
                        if (!(tmp > 0.0)) continue;
                        fPen += tmp * tmp;
                    }
                    fAdd += 100.0 * fPen;
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmp = genome[i] - this.xOpt[i];
                    value += tmp * tmp;
                }
                switch (this.noise) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = this.fGauss(value, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 2: {
                        value = this.fUniform(value, 0.49 + 1.0 / (double)genomeSize, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 3: {
                        value = this.fCauchy(value, 1.0, 0.2, state.random[threadnum]);
                        break;
                    }
                    case 4: {
                        value = this.fGauss(value, 0.01, state.random[threadnum]);
                        break;
                    }
                    case 5: {
                        value = this.fUniform(value, 0.01 * (0.49 + 1.0 / (double)genomeSize), 0.01, state.random[threadnum]);
                        break;
                    }
                    case 6: {
                        value = this.fCauchy(value, 0.01, 0.05, state.random[threadnum]);
                        break;
                    }
                    default: {
                        String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                        for (i = 0; i < this.noiseTypes.length; ++i) {
                            outputStr = outputStr + this.noiseTypes[i] + "\n";
                        }
                        state.output.fatal(outputStr, new Parameter(P_NOISE));
                    }
                }
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 1: {
                int i;
                double condition;
                double fAdd = this.fOpt;
                if (this.noise == 0) {
                    condition = 1000000.0;
                    for (i = 0; i < genomeSize; ++i) {
                        tmx[i] = genome[i] - this.xOpt[i];
                    }
                } else {
                    condition = 10000.0;
                    fAdd = this.fOpt;
                    for (i = 0; i < genomeSize; ++i) {
                        tmp = Math.abs(genome[i]) - 5.0;
                        if (!(tmp > 0.0)) continue;
                        fPen += tmp * tmp;
                    }
                    fAdd += 100.0 * fPen;
                    for (i = 0; i < genomeSize; ++i) {
                        tmx[i] = 0.0;
                        for (int j = 0; j < genomeSize; ++j) {
                            int n = i;
                            tmx[n] = tmx[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                        }
                    }
                }
                this.monotoneTFosc(tmx);
                for (i = 0; i < genomeSize; ++i) {
                    value += Math.pow(condition, (double)i / (double)(genomeSize - 1)) * tmx[i] * tmx[i];
                }
                switch (this.noise) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = this.fGauss(value, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 2: {
                        value = this.fUniform(value, 0.49 + 1.0 / (double)genomeSize, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 3: {
                        value = this.fCauchy(value, 1.0, 0.2, state.random[threadnum]);
                        break;
                    }
                    default: {
                        String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                        for (i = 0; i < 4; ++i) {
                            outputStr = outputStr + this.noiseTypes[i] + "\n";
                        }
                        state.output.fatal(outputStr, new Parameter(P_NOISE));
                    }
                }
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 2: {
                float fit;
                int i;
                double condition = 10.0;
                double beta = 0.2;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = genome[i] - this.xOpt[i];
                }
                this.monotoneTFosc(tmx);
                for (i = 0; i < genomeSize; ++i) {
                    tmp = (double)i / (double)(genomeSize - 1);
                    if (tmx[i] > 0.0) {
                        tmx[i] = Math.pow(tmx[i], 1.0 + beta * tmp * Math.sqrt(tmx[i]));
                    }
                    tmx[i] = Math.pow(Math.sqrt(condition), tmp) * tmx[i];
                }
                tmp = 0.0;
                double tmp2 = 0.0;
                for (i = 0; i < genomeSize; ++i) {
                    tmp += Math.cos(Math.PI * 2 * tmx[i]);
                    tmp2 += tmx[i] * tmx[i];
                }
                value = 10.0 * ((double)genomeSize - tmp) + tmp2;
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 3: {
                float fit;
                int i;
                double condition = 10.0;
                double alpha = 100.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd += (fPen *= 100.0);
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = genome[i] - this.xOpt[i];
                }
                this.monotoneTFosc(tmx);
                for (i = 0; i < genomeSize; ++i) {
                    if (i % 2 == 0 && tmx[i] > 0.0) {
                        tmx[i] = Math.sqrt(alpha) * tmx[i];
                    }
                    tmx[i] = Math.pow(Math.sqrt(condition), (double)i / (double)(genomeSize - 1)) * tmx[i];
                }
                tmp = 0.0;
                double tmp2 = 0.0;
                for (i = 0; i < genomeSize; ++i) {
                    tmp += Math.cos(Math.PI * 2 * tmx[i]);
                    tmp2 += tmx[i] * tmx[i];
                }
                value = 10.0 * ((double)genomeSize - tmp) + tmp2;
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 4: {
                float fit;
                int i;
                double alpha = 100.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = this.xOpt[i] == 5.0 && genome[i] > 5.0 ? 5.0 : (this.xOpt[i] == -5.0 && genome[i] < -5.0 ? -5.0 : genome[i]);
                }
                for (i = 0; i < genomeSize; ++i) {
                    if (this.xOpt[i] > 0.0) {
                        value -= Math.pow(Math.sqrt(alpha), (double)i / (double)(genomeSize - 1)) * tmx[i];
                        continue;
                    }
                    value += Math.pow(Math.sqrt(alpha), (double)i / (double)(genomeSize - 1)) * tmx[i];
                }
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 5: {
                int i;
                double alpha = 100.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (int j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.linearTF[i][j] * (genome[j] - this.xOpt[j]);
                    }
                }
                for (i = 0; i < genomeSize; ++i) {
                    if (tmx[i] * this.xOpt[i] > 0.0) {
                        int n = i;
                        tmx[n] = tmx[n] * alpha;
                    }
                    value += tmx[i] * tmx[i];
                }
                if (value > 0.0) {
                    value = Math.pow(Math.exp(Math.log(value) / 0.1 + 0.49 * (Math.sin(Math.log(value) / 0.1) + Math.sin(0.79 * Math.log(value) / 0.1))), 0.1);
                } else if (value < 0.0) {
                    value = -Math.pow(Math.exp(Math.log(-value) / 0.1 + 0.49 * (Math.sin(0.55 * Math.log(-value) / 0.1) + Math.sin(0.31 * Math.log(-value) / 0.1))), 0.1);
                }
                value = Math.pow(value, 0.9);
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 6: {
                int j;
                int i;
                double condition = 100.0;
                double alpha = 10.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd = this.noise == 0 ? (fAdd += fPen) : (fAdd += 100.0 * fPen);
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = 0.0;
                    tmp = Math.sqrt(Math.pow(condition / 10.0, (double)i / (double)(genomeSize - 1)));
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmpvect[n] = tmpvect[n] + tmp * this.rot2[i][j] * (genome[j] - this.xOpt[j]);
                    }
                }
                double x1 = tmpvect[0];
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = Math.abs(tmpvect[i]) > 0.5 ? (double)Math.round(tmpvect[i]) : (double)Math.round(alpha * tmpvect[i]) / alpha;
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.rotation[i][j] * tmpvect[j];
                    }
                }
                for (i = 0; i < genomeSize; ++i) {
                    value += Math.pow(condition, (double)i / (double)(genomeSize - 1)) * tmx[i] * tmx[i];
                }
                value = 0.1 * Math.max(1.0E-4 * Math.abs(x1), value);
                switch (this.noise) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = this.fGauss(value, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 2: {
                        value = this.fUniform(value, 0.49 + 1.0 / (double)genomeSize, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 3: {
                        value = this.fCauchy(value, 1.0, 0.2, state.random[threadnum]);
                        break;
                    }
                    default: {
                        String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                        for (i = 0; i < 4; ++i) {
                            outputStr = outputStr + this.noiseTypes[i] + "\n";
                        }
                        state.output.fatal(outputStr, new Parameter(P_NOISE));
                    }
                }
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 7: {
                int i;
                double fAdd = this.fOpt;
                if (this.noise == 0) {
                    for (i = 0; i < genomeSize; ++i) {
                        tmx[i] = this.scales * (genome[i] - this.xOpt[i]) + 1.0;
                    }
                } else {
                    for (i = 0; i < genomeSize; ++i) {
                        tmp = Math.abs(genome[i]) - 5.0;
                        if (!(tmp > 0.0)) continue;
                        fPen += tmp * tmp;
                    }
                    fAdd += 100.0 * fPen;
                    for (i = 0; i < genomeSize; ++i) {
                        tmx[i] = this.scales * (genome[i] - 0.75 * this.xOpt[i]) + 1.0;
                    }
                }
                for (i = 0; i < genomeSize - 1; ++i) {
                    tmp = tmx[i] * tmx[i] - tmx[i + 1];
                    value += tmp * tmp;
                }
                value *= 100.0;
                for (i = 0; i < genomeSize - 1; ++i) {
                    tmp = tmx[i] - 1.0;
                    value += tmp * tmp;
                }
                switch (this.noise) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = this.fGauss(value, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 2: {
                        value = this.fUniform(value, 0.49 + 1.0 / (double)genomeSize, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 3: {
                        value = this.fCauchy(value, 1.0, 0.2, state.random[threadnum]);
                        break;
                    }
                    case 4: {
                        value = this.fGauss(value, 0.01, state.random[threadnum]);
                        break;
                    }
                    case 5: {
                        value = this.fUniform(value, 0.01 * (0.49 + 1.0 / (double)genomeSize), 0.01, state.random[threadnum]);
                        break;
                    }
                    case 6: {
                        value = this.fCauchy(value, 0.01, 0.05, state.random[threadnum]);
                        break;
                    }
                    default: {
                        String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                        for (i = 0; i < this.noiseTypes.length; ++i) {
                            outputStr = outputStr + this.noiseTypes[i] + "\n";
                        }
                        state.output.fatal(outputStr, new Parameter(P_NOISE));
                    }
                }
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 8: {
                float fit;
                int i;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.5;
                    for (int j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.linearTF[i][j] * genome[j];
                    }
                }
                for (i = 0; i < genomeSize - 1; ++i) {
                    tmp = tmx[i] * tmx[i] - tmx[i + 1];
                    value += tmp * tmp;
                }
                value *= 100.0;
                for (i = 0; i < genomeSize - 1; ++i) {
                    tmp = tmx[i] - 1.0;
                    value += tmp * tmp;
                }
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 9: {
                float fit;
                int i;
                double condition = 1000000.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (int j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                    }
                }
                this.monotoneTFosc(tmx);
                for (i = 0; i < genomeSize; ++i) {
                    fAdd += Math.pow(condition, (double)i / (double)(genomeSize - 1)) * tmx[i] * tmx[i];
                }
                value = fAdd;
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-value)) == 0.0f);
                break;
            }
            case 10: {
                float fit;
                int i;
                double condition = 1000000.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (int j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                    }
                }
                this.monotoneTFosc(tmx);
                value = condition * tmx[0] * tmx[0];
                for (i = 1; i < genomeSize; ++i) {
                    value += tmx[i] * tmx[i];
                }
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 11: {
                float fit;
                int j;
                int i;
                double condition = 1000000.0;
                double beta = 0.5;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmpvect[n] = tmpvect[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                    }
                    if (!(tmpvect[i] > 0.0)) continue;
                    tmpvect[i] = Math.pow(tmpvect[i], 1.0 + beta * (double)i / (double)(genomeSize - 1) * Math.sqrt(tmpvect[i]));
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.rotation[i][j] * tmpvect[j];
                    }
                }
                value = tmx[0] * tmx[0];
                for (i = 1; i < genomeSize; ++i) {
                    value += condition * tmx[i] * tmx[i];
                }
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 12: {
                float fit;
                int i;
                double condition = 10.0;
                double alpha = 100.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (int j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.linearTF[i][j] * (genome[j] - this.xOpt[j]);
                    }
                }
                for (i = 1; i < genomeSize; ++i) {
                    value += tmx[i] * tmx[i];
                }
                value = alpha * Math.sqrt(value);
                value += tmx[0] * tmx[0];
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 13: {
                int i;
                double alpha = 4.0;
                double fAdd = this.fOpt;
                if (this.noise != 0) {
                    for (i = 0; i < genomeSize; ++i) {
                        tmp = Math.abs(genome[i]) - 5.0;
                        if (!(tmp > 0.0)) continue;
                        fPen += tmp * tmp;
                    }
                    fAdd += 100.0 * fPen;
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (int j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                    }
                }
                for (i = 0; i < genomeSize; ++i) {
                    value += Math.pow(Math.abs(tmx[i]), 2.0 + alpha * (double)i / (double)(genomeSize - 1));
                }
                value = Math.sqrt(value);
                switch (this.noise) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = this.fGauss(value, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 2: {
                        value = this.fUniform(value, 0.49 + 1.0 / (double)genomeSize, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 3: {
                        value = this.fCauchy(value, 1.0, 0.2, state.random[threadnum]);
                        break;
                    }
                    default: {
                        String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                        for (i = 0; i < 4; ++i) {
                            outputStr = outputStr + this.noiseTypes[i] + "\n";
                        }
                        state.output.fatal(outputStr, new Parameter(P_NOISE));
                    }
                }
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 14: {
                float fit;
                int j;
                int i;
                double condition = 10.0;
                double beta = 0.2;
                double tmp2 = 0.0;
                tmp = 0.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmpvect[n] = tmpvect[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                    }
                }
                this.monotoneTFosc(tmpvect);
                for (i = 0; i < genomeSize; ++i) {
                    if (!(tmpvect[i] > 0.0)) continue;
                    tmpvect[i] = Math.pow(tmpvect[i], 1.0 + beta * (double)i / (double)(genomeSize - 1) * Math.sqrt(tmpvect[i]));
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.linearTF[i][j] * tmpvect[j];
                    }
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmp += Math.cos(Math.PI * 2 * tmx[i]);
                    tmp2 += tmx[i] * tmx[i];
                }
                value = 10.0 * ((double)genomeSize - tmp) + tmp2;
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 15: {
                float fit;
                int j;
                int i;
                double condition = 100.0;
                fPen = 0.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd += 10.0 / (double)genomeSize * fPen;
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmpvect[n] = tmpvect[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                    }
                }
                this.monotoneTFosc(tmpvect);
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.linearTF[i][j] * tmpvect[j];
                    }
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmp = 0.0;
                    for (j = 0; j < 12; ++j) {
                        tmp += Math.cos(Math.PI * 2 * (tmx[i] + 0.5) * this.bK[j]) * this.aK[j];
                    }
                    value += tmp;
                }
                value = 10.0 * Math.pow(value / (double)genomeSize - this.f0, 3.0);
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 16: {
                int j;
                int i;
                double condition = 10.0;
                double beta = 0.5;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd += 10.0 * fPen;
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmpvect[n] = tmpvect[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                    }
                    if (!(tmpvect[i] > 0.0)) continue;
                    tmpvect[i] = Math.pow(tmpvect[i], 1.0 + beta * (double)i / (double)(genomeSize - 1) * Math.sqrt(tmpvect[i]));
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    tmp = Math.pow(Math.sqrt(condition), (double)i / (double)(genomeSize - 1));
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + tmp * this.rot2[i][j] * tmpvect[j];
                    }
                }
                for (i = 0; i < genomeSize - 1; ++i) {
                    tmp = tmx[i] * tmx[i] + tmx[i + 1] * tmx[i + 1];
                    value += Math.pow(tmp, 0.25) * (Math.pow(Math.sin(50.0 * Math.pow(tmp, 0.1)), 2.0) + 1.0);
                }
                value = Math.pow(value / (double)(genomeSize - 1), 2.0);
                switch (this.noise) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = this.fGauss(value, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 2: {
                        value = this.fUniform(value, 0.49 + 1.0 / (double)genomeSize, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 3: {
                        value = this.fCauchy(value, 1.0, 0.2, state.random[threadnum]);
                        break;
                    }
                    default: {
                        String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                        for (i = 0; i < 4; ++i) {
                            outputStr = outputStr + this.noiseTypes[i] + "\n";
                        }
                        state.output.fatal(outputStr, new Parameter(P_NOISE));
                    }
                }
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 17: {
                float fit;
                int j;
                int i;
                double condition = 1000.0;
                double beta = 0.5;
                fPen = 0.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd += 10.0 * fPen;
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmpvect[n] = tmpvect[n] + this.rotation[i][j] * (genome[j] - this.xOpt[j]);
                    }
                    if (!(tmpvect[i] > 0.0)) continue;
                    tmpvect[i] = Math.pow(tmpvect[i], 1.0 + beta * (double)i / (double)(genomeSize - 1) * Math.sqrt(tmpvect[i]));
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    tmp = Math.pow(Math.sqrt(condition), (double)i / (double)(genomeSize - 1));
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + tmp * this.rot2[i][j] * tmpvect[j];
                    }
                }
                for (i = 0; i < genomeSize - 1; ++i) {
                    tmp = tmx[i] * tmx[i] + tmx[i + 1] * tmx[i + 1];
                    value += Math.pow(tmp, 0.25) * (Math.pow(Math.sin(50.0 * Math.pow(tmp, 0.1)), 2.0) + 1.0);
                }
                value = Math.pow(value / (double)(genomeSize - 1), 2.0);
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 18: {
                double f2;
                int j;
                int i;
                double fAdd = this.fOpt;
                if (this.noise == 0) {
                    for (i = 0; i < genomeSize; ++i) {
                        tmx[i] = 0.5;
                        for (j = 0; j < genomeSize; ++j) {
                            int n = i;
                            tmx[n] = tmx[n] + this.linearTF[i][j] * genome[j];
                        }
                    }
                    for (i = 0; i < genomeSize - 1; ++i) {
                        double tmp2 = tmx[i] * tmx[i] - tmx[i + 1];
                        f2 = 100.0 * tmp2 * tmp2;
                        tmp2 = 1.0 - tmx[i];
                        tmp += (f2 += tmp2 * tmp2) / 4000.0 - Math.cos(f2);
                    }
                    value = 10.0 + 10.0 * tmp / (double)(genomeSize - 1);
                } else {
                    for (i = 0; i < genomeSize; ++i) {
                        tmp = Math.abs(genome[i]) - 5.0;
                        if (!(tmp > 0.0)) continue;
                        fPen += tmp * tmp;
                    }
                    fAdd += 100.0 * fPen;
                    for (i = 0; i < genomeSize; ++i) {
                        tmx[i] = 0.5;
                        for (j = 0; j < genomeSize; ++j) {
                            int n = i;
                            tmx[n] = tmx[n] + this.scales * this.rotation[i][j] * genome[j];
                        }
                    }
                    tmp = 0.0;
                    for (i = 0; i < genomeSize - 1; ++i) {
                        f2 = 100.0 * (tmx[i] * tmx[i] - tmx[i + 1]) * (tmx[i] * tmx[i] - tmx[i + 1]) + (1.0 - tmx[i]) * (1.0 - tmx[i]);
                        tmp += f2 / 4000.0 - Math.cos(f2);
                    }
                    value = 1.0 + 1.0 * tmp / (double)(genomeSize - 1);
                }
                switch (this.noise) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = this.fGauss(value, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 2: {
                        value = this.fUniform(value, 0.49 + 1.0 / (double)genomeSize, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 3: {
                        value = this.fCauchy(value, 1.0, 0.2, state.random[threadnum]);
                        break;
                    }
                    default: {
                        String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                        for (i = 0; i < 4; ++i) {
                            outputStr = outputStr + this.noiseTypes[i] + "\n";
                        }
                        state.output.fatal(outputStr, new Parameter(P_NOISE));
                    }
                }
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 19: {
                float fit;
                int i;
                double condition = 10.0;
                fPen = 0.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmpvect[i] = 2.0 * genome[i];
                    if (!(this.xOpt[i] < 0.0)) continue;
                    int n = i;
                    tmpvect[n] = tmpvect[n] * -1.0;
                }
                tmx[0] = tmpvect[0];
                for (i = 1; i < genomeSize; ++i) {
                    tmx[i] = tmpvect[i] + 0.25 * (tmpvect[i - 1] - 2.0 * Math.abs(this.xOpt[i - 1]));
                }
                for (i = 0; i < genomeSize; ++i) {
                    int n = i;
                    tmx[n] = tmx[n] - 2.0 * Math.abs(this.xOpt[i]);
                    int n2 = i;
                    tmx[n2] = tmx[n2] * Math.pow(Math.sqrt(condition), (double)i / (double)(genomeSize - 1));
                    tmx[i] = 100.0 * (tmx[i] + 2.0 * Math.abs(this.xOpt[i]));
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(tmx[i]) - 500.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd += 0.01 * fPen;
                for (i = 0; i < genomeSize; ++i) {
                    value += tmx[i] * Math.sin(Math.sqrt(Math.abs(tmx[i])));
                }
                value = 0.01 * (418.9828872724339 - value / (double)genomeSize);
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 20: {
                double tmp2;
                int j;
                int i;
                double a = 0.1;
                double fac = -0.5 / (double)genomeSize;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd = this.noise == 0 ? (fAdd += fPen) : (fAdd += 100.0 * fPen);
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.rotation[i][j] * genome[j];
                    }
                }
                if (this.noise == 0) {
                    for (i = 0; i < 101; ++i) {
                        tmp2 = 0.0;
                        for (j = 0; j < genomeSize; ++j) {
                            tmp = tmx[j] - this.xLocal[j][i];
                            tmp2 += this.arrScales[i][j] * tmp * tmp;
                        }
                        tmp2 = this.peakvalues[i] * Math.exp(fac * tmp2);
                        f = Math.max(f, tmp2);
                    }
                } else {
                    for (i = 0; i < 101; ++i) {
                        tmp2 = 0.0;
                        for (j = 0; j < genomeSize; ++j) {
                            tmp2 += this.arrScales[i][j] * (tmx[j] - this.xLocal[j][i]) * (tmx[j] - this.xLocal[j][i]);
                        }
                        tmp2 = this.peakvalues[i] * Math.exp(fac * tmp2);
                        f = Math.max(f, tmp2);
                    }
                }
                if ((f = 10.0 - f) > 0.0) {
                    value = Math.log(f) / a;
                    value = Math.pow(Math.exp(value + 0.49 * (Math.sin(value) + Math.sin(0.79 * value))), a);
                } else if (f < 0.0) {
                    value = Math.log(-f) / a;
                    value = -Math.pow(Math.exp(value + 0.49 * (Math.sin(0.55 * value) + Math.sin(0.31 * value))), a);
                } else {
                    value = f;
                }
                value *= value;
                switch (this.noise) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = this.fGauss(value, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 2: {
                        value = this.fUniform(value, 0.49 + 1.0 / (double)genomeSize, 1.0, state.random[threadnum]);
                        break;
                    }
                    case 3: {
                        value = this.fCauchy(value, 1.0, 0.2, state.random[threadnum]);
                        break;
                    }
                    default: {
                        String outputStr = "Invalid value for parameter, or parameter not found.\nAcceptable values are:\n";
                        for (i = 0; i < 4; ++i) {
                            outputStr = outputStr + this.noiseTypes[i] + "\n";
                        }
                        state.output.fatal(outputStr, new Parameter(P_NOISE));
                    }
                }
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 21: {
                int j;
                int i;
                double a = 0.1;
                f = 0.0;
                double fac = -0.5 / (double)genomeSize;
                fPen = 0.0;
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd += fPen;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = i;
                        tmx[n] = tmx[n] + this.rotation[i][j] * genome[j];
                    }
                }
                for (i = 0; i < 21; ++i) {
                    double tmp2 = 0.0;
                    for (j = 0; j < genomeSize; ++j) {
                        tmp = tmx[j] - this.xLocal[j][i];
                        tmp2 += this.arrScales[i][j] * tmp * tmp;
                    }
                    tmp2 = this.peakvalues[i] * Math.exp(fac * tmp2);
                    f = Math.max(f, tmp2);
                }
                if ((f = 10.0 - f) > 0.0) {
                    value = Math.log(f) / a;
                    value = Math.pow(Math.exp(value + 0.49 * (Math.sin(value) + Math.sin(0.79 * value))), a);
                } else if (f < 0.0) {
                    value = Math.log(-f) / a;
                    value = -Math.pow(Math.exp(value + 0.49 * (Math.sin(0.55 * value) + Math.sin(0.31 * value))), a);
                } else {
                    value = f;
                }
                value *= value;
                float fit = (float)(-(value += fAdd));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, fit == 0.0f);
                break;
            }
            case 22: {
                float fit;
                int j;
                int i;
                double condition = 100.0;
                double fAdd = 0.0;
                fPen = 0.0;
                double prod = 1.0;
                fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd += fPen;
                for (j = 0; j < genomeSize; ++j) {
                    tmpvect[j] = genome[j] - this.xOpt[j];
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 0.0;
                    double[] ptmx = tmx;
                    double[] plinTF = this.linearTF[i];
                    double[] ptmp = tmpvect;
                    for (j = 0; j < genomeSize; ++j) {
                        int n = j;
                        ptmx[n] = ptmx[n] + plinTF[j] * ptmp[j];
                    }
                }
                for (i = 0; i < genomeSize; ++i) {
                    tmp = 0.0;
                    for (j = 1; j < 33; ++j) {
                        double tmp2 = Math.pow(2.0, j);
                        double arr = tmx[i] * tmp2;
                        tmp += Math.abs(arr - (double)Math.round(arr)) / tmp2;
                    }
                    tmp = 1.0 + tmp * (double)(i + 1);
                    prod *= tmp;
                }
                value = 10.0 / (double)genomeSize / (double)genomeSize * (-1.0 + Math.pow(prod, 10.0 / Math.pow(genomeSize, 1.2)));
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
            case 23: {
                float fit;
                int i;
                double condition = 100.0;
                double mu1 = 2.5;
                double tmp4 = 0.0;
                double tmp3 = 0.0;
                double tmp2 = 0.0;
                fPen = 0.0;
                double s = 1.0 - 0.5 / (Math.sqrt(genomeSize + 20) - 4.1);
                double d = 1.0;
                double mu2 = -Math.sqrt((mu1 * mu1 - d) / s);
                double fAdd = this.fOpt;
                for (i = 0; i < genomeSize; ++i) {
                    tmp = Math.abs(genome[i]) - 5.0;
                    if (!(tmp > 0.0)) continue;
                    fPen += tmp * tmp;
                }
                fAdd += 10000.0 * fPen;
                for (i = 0; i < genomeSize; ++i) {
                    tmx[i] = 2.0 * genome[i];
                    if (!(this.xOpt[i] < 0.0)) continue;
                    int n = i;
                    tmx[n] = tmx[n] * -1.0;
                }
                tmp = 0.0;
                for (i = 0; i < genomeSize; ++i) {
                    tmp2 += (tmx[i] - mu1) * (tmx[i] - mu1);
                    tmp3 += (tmx[i] - mu2) * (tmx[i] - mu2);
                    tmp4 = 0.0;
                    for (int j = 0; j < genomeSize; ++j) {
                        tmp4 += this.linearTF[i][j] * (tmx[j] - mu1);
                    }
                    tmp += Math.cos(Math.PI * 2 * tmp4);
                }
                value = Math.min(tmp2, d * (double)genomeSize + s * tmp3) + 10.0 * ((double)genomeSize - tmp);
                ((SimpleFitness)ind.fitness).setFitness(state, fit, (fit = (float)(-(value += fAdd))) == 0.0f);
                break;
            }
        }
    }

    void gauss(double[] g, MersenneTwisterFast random) {
        int i;
        double[] uniftmp = new double[2 * g.length];
        for (i = 0; i < uniftmp.length; ++i) {
            uniftmp[i] = this.nextDoubleClosedInterval(random);
        }
        for (i = 0; i < g.length; ++i) {
            g[i] = Math.sqrt(-2.0 * Math.log(uniftmp[i])) * Math.cos(Math.PI * 2 * uniftmp[g.length + i]);
            if (g[i] != 0.0) continue;
            g[i] = 1.0E-99;
        }
    }

    void gauss(double[] g, MersenneTwisterFast random, int n) {
        int i;
        double[] uniftmp = new double[2 * g.length];
        for (i = 0; i < uniftmp.length; ++i) {
            uniftmp[i] = this.nextDoubleClosedInterval(random);
        }
        for (i = 0; i < n; ++i) {
            g[i] = Math.sqrt(-2.0 * Math.log(uniftmp[i])) * Math.cos(Math.PI * 2 * uniftmp[n + i]);
            if (g[i] != 0.0) continue;
            g[i] = 1.0E-99;
        }
    }

    void computeXopt(double[] xOpt, MersenneTwisterFast random) {
        int n = xOpt.length;
        for (int i = 0; i < n; ++i) {
            xOpt[i] = (double)(8 * (int)Math.floor(10000.0 * this.nextDoubleClosedInterval(random))) / 10000.0 - 4.0;
            if (xOpt[i] != 0.0) continue;
            xOpt[i] = -1.0E-5;
        }
    }

    void monotoneTFosc(double[] f) {
        double a = 0.1;
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            if (f[i] > 0.0) {
                f[i] = Math.log(f[i]) / a;
                f[i] = Math.pow(Math.exp(f[i] + 0.49 * (Math.sin(f[i]) + Math.sin(0.79 * f[i]))), a);
                continue;
            }
            if (!(f[i] < 0.0)) continue;
            f[i] = Math.log(-f[i]) / a;
            f[i] = -Math.pow(Math.exp(f[i] + 0.49 * (Math.sin(0.55 * f[i]) + Math.sin(0.31 * f[i]))), a);
        }
    }

    double[][] reshape(double[][] b, double[] vector, int m, int n) {
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                b[i][j] = vector[j * m + i];
            }
        }
        return b;
    }

    void computeRotation(double[][] b, MersenneTwisterFast random, int genomeSize) {
        double[] gvect = new double[genomeSize * genomeSize];
        this.gauss(gvect, random);
        this.reshape(b, gvect, genomeSize, genomeSize);
        for (int i = 0; i < genomeSize; ++i) {
            int k;
            double prod;
            for (int j = 0; j < i; ++j) {
                prod = 0.0;
                for (k = 0; k < genomeSize; ++k) {
                    prod += b[k][i] * b[k][j];
                }
                for (k = 0; k < genomeSize; ++k) {
                    double[] dArray = b[k];
                    int n = i;
                    dArray[n] = dArray[n] - prod * b[k][j];
                }
            }
            prod = 0.0;
            for (k = 0; k < genomeSize; ++k) {
                prod += b[k][i] * b[k][i];
            }
            for (k = 0; k < genomeSize; ++k) {
                double[] dArray = b[k];
                int n = i;
                dArray[n] = dArray[n] / Math.sqrt(prod);
            }
        }
    }

    double fGauss(double fTrue, double beta, MersenneTwisterFast random) {
        double fVal = fTrue * Math.exp(beta * this.nextDoubleClosedInterval(random));
        fVal += 1.0100000000000001E-8;
        if (fTrue < 1.0E-8) {
            fVal = fTrue;
        }
        return fVal;
    }

    double fUniform(double fTrue, double alpha, double beta, MersenneTwisterFast random) {
        double fVal = Math.pow(this.nextDoubleClosedInterval(random), beta) * fTrue * Math.max(1.0, Math.pow(1.0E9 / (fTrue + 1.0E-99), alpha * this.nextDoubleClosedInterval(random)));
        fVal += 1.0100000000000001E-8;
        if (fTrue < 1.0E-8) {
            fVal = fTrue;
        }
        return fVal;
    }

    double fCauchy(double fTrue, double alpha, double p, MersenneTwisterFast random) {
        double tmp = this.nextDoubleClosedInterval(random) / Math.abs(this.nextDoubleClosedInterval(random) + 1.0E-199);
        double fVal = this.nextDoubleClosedInterval(random) < p ? fTrue + alpha * Math.max(0.0, 1000.0 + tmp) : fTrue + alpha * 1000.0;
        fVal += 1.0100000000000001E-8;
        if (fTrue < 1.0E-8) {
            fVal = fTrue;
        }
        return fVal;
    }

    double computeFopt(MersenneTwisterFast random) {
        double[] gval = new double[1];
        double[] gval2 = new double[1];
        this.gauss(gval, random, 1);
        this.gauss(gval2, random, 1);
        return Math.min(1000.0, Math.max(-1000.0, (double)Math.round(10000.0 * gval[0] / gval2[0]) / 100.0));
    }

    double nextDoubleClosedInterval(MersenneTwisterFast random) {
        double tmp = random.nextDouble() * 2.0;
        while (tmp > 1.0) {
            tmp = random.nextDouble() * 2.0;
        }
        return tmp;
    }
}

