/*
 * Decompiled with CFR 0.152.
 */
package ec.app.coevolve1;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Problem;
import ec.coevolve.GroupedProblemForm;
import ec.simple.SimpleFitness;
import ec.vector.BitVectorIndividual;

public class CompetitiveMaxOne
extends Problem
implements GroupedProblemForm {
    public void preprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        for (int i = 0; i < pop.subpops.length; ++i) {
            for (int j = 0; j < pop.subpops[i].individuals.length; ++j) {
                SimpleFitness sf = (SimpleFitness)pop.subpops[i].individuals[j].fitness;
                sf.trials = 0;
                sf.setFitness(state, 0.0f, false);
            }
        }
    }

    public void postprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        for (int i = 0; i < pop.subpops.length; ++i) {
            for (int j = 0; j < pop.subpops[i].individuals.length; ++j) {
                if (!countVictoriesOnly) {
                    SimpleFitness sf = (SimpleFitness)pop.subpops[i].individuals[j].fitness;
                    sf.setFitness(state, sf.fitness() / (float)sf.trials, false);
                }
                pop.subpops[i].individuals[j].evaluated = true;
            }
        }
    }

    public void evaluate(EvolutionState state, Individual[] ind, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        SimpleFitness fit;
        int i;
        if (ind.length != 2 || updateFitness.length != 2) {
            state.output.fatal("The InternalSumProblem evaluates only two individuals at a time.");
        }
        if (!(ind[0] instanceof BitVectorIndividual)) {
            state.output.fatal("The individuals in the InternalSumProblem should be FloatVectorIndividuals.");
        }
        if (!(ind[1] instanceof BitVectorIndividual)) {
            state.output.fatal("The individuals in the InternalSumProblem should be FloatVectorIndividuals.");
        }
        int value1 = 0;
        int value2 = 0;
        BitVectorIndividual temp = (BitVectorIndividual)ind[0];
        for (i = 0; i < temp.genome.length; ++i) {
            if (!temp.genome[i]) continue;
            ++value1;
        }
        temp = (BitVectorIndividual)ind[1];
        for (i = 0; i < temp.genome.length; ++i) {
            if (!temp.genome[i]) continue;
            ++value2;
        }
        boolean firstWinsIfDraw = false;
        if (value1 == value2) {
            firstWinsIfDraw = state.random[threadnum].nextBoolean(0.5);
        }
        if (updateFitness[0]) {
            fit = (SimpleFitness)ind[0].fitness;
            ++fit.trials;
            if (countVictoriesOnly) {
                if (value1 > value2 || value1 == value2 && firstWinsIfDraw) {
                    fit.setFitness(state, fit.fitness() + 1.0f, false);
                }
            } else {
                fit.setFitness(state, fit.fitness() + (float)value1 - (float)value2, false);
            }
        }
        if (updateFitness[1]) {
            fit = (SimpleFitness)ind[1].fitness;
            ++fit.trials;
            if (countVictoriesOnly) {
                if (value2 > value1 || value2 == value1 && !firstWinsIfDraw) {
                    fit.setFitness(state, fit.fitness() + 1.0f, false);
                }
            } else {
                fit.setFitness(state, fit.fitness() + (float)value2 - (float)value1, false);
            }
        }
    }
}

