/*
 * Decompiled with CFR 0.152.
 */
package ec.app.coevolve2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.app.coevolve2.CoevolutionaryDoubleVectorIndividual;
import ec.app.ecsuite.ECSuite;
import ec.coevolve.GroupedProblemForm;
import ec.simple.SimpleFitness;

public class CoevolutionaryECSuite
extends ECSuite
implements GroupedProblemForm {
    public void preprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        for (int i = 0; i < pop.subpops.length; ++i) {
            for (int j = 0; j < pop.subpops[i].individuals.length; ++j) {
                ((SimpleFitness)pop.subpops[i].individuals[j].fitness).setFitness(state, -2.1474836E9f, false);
            }
        }
    }

    public void postprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        for (int i = 0; i < pop.subpops.length; ++i) {
            for (int j = 0; j < pop.subpops[i].individuals.length; ++j) {
                pop.subpops[i].individuals[j].evaluated = true;
            }
        }
    }

    public void evaluate(EvolutionState state, Individual[] ind, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        if (ind.length == 0) {
            state.output.fatal("Number of individuals provided to CoevolutionaryECSuite is 0!");
        }
        if (ind.length == 1) {
            state.output.warnOnce("Coevolution used, but number of individuals provided to CoevolutionaryECSuite is 1.");
        }
        int size = 0;
        for (int i = 0; i < ind.length; ++i) {
            if (!(ind[i] instanceof CoevolutionaryDoubleVectorIndividual)) {
                state.output.error("Individual " + i + "in coevolution is not a CoevolutionaryDoubleVectorIndividual.");
                continue;
            }
            CoevolutionaryDoubleVectorIndividual coind = (CoevolutionaryDoubleVectorIndividual)ind[i];
            size += coind.genome.length;
        }
        state.output.exitIfErrors();
        double[] vals = new double[size];
        int pos = 0;
        for (int i = 0; i < ind.length; ++i) {
            System.err.println("-->" + i);
            CoevolutionaryDoubleVectorIndividual coind = (CoevolutionaryDoubleVectorIndividual)ind[i];
            System.err.println(coind.genome.length);
            System.arraycopy(coind.genome, 0, vals, pos, coind.genome.length);
            pos += coind.genome.length;
        }
        double fit = this.function(state, this.problemType, vals, threadnum);
        boolean isOptimal = this.isOptimal(this.problemType, fit);
        for (int i = 0; i < ind.length; ++i) {
            CoevolutionaryDoubleVectorIndividual coind = (CoevolutionaryDoubleVectorIndividual)ind[i];
            if (!updateFitness[i] || !(fit > (double)coind.fitness.fitness())) continue;
            ((SimpleFitness)coind.fitness).setFitness(state, (float)fit, isOptimal);
            coind.context = new CoevolutionaryDoubleVectorIndividual[ind.length];
            for (int j = 0; j < ind.length; ++j) {
                if (i == j) continue;
                coind.context[j] = (CoevolutionaryDoubleVectorIndividual)ind[j];
            }
        }
    }
}

