/*
 * Decompiled with CFR 0.152.
 */
package ec.app.coevolve2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Problem;
import ec.app.coevolve2.CoevolutionaryDoubleVectorIndividual;
import ec.coevolve.GroupedProblemForm;
import ec.simple.SimpleFitness;

public class CoevolutionaryRosenbrock
extends Problem
implements GroupedProblemForm {
    double rosenbrock(double i, double j) {
        return -(100.0 * (i - j * j) * (i - j * j) + (1.0 - j) * (1.0 - j));
    }

    public void preprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        for (int i = 0; i < pop.subpops.length; ++i) {
            for (int j = 0; j < pop.subpops[i].individuals.length; ++j) {
                ((SimpleFitness)pop.subpops[i].individuals[j].fitness).setFitness(state, -2.1474836E9f, false);
            }
        }
    }

    public void postprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        for (int i = 0; i < pop.subpops.length; ++i) {
            for (int j = 0; j < pop.subpops[i].individuals.length; ++j) {
                pop.subpops[i].individuals[j].evaluated = true;
            }
        }
    }

    public void evaluate(EvolutionState state, Individual[] ind, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        if (ind.length != 2 || !(ind[0] instanceof CoevolutionaryDoubleVectorIndividual) || !(ind[1] instanceof CoevolutionaryDoubleVectorIndividual)) {
            state.output.error("There should be two subpopulations, both with CoevolutionaryDoubleVectorIndividual.");
        }
        CoevolutionaryDoubleVectorIndividual ind1 = (CoevolutionaryDoubleVectorIndividual)ind[0];
        CoevolutionaryDoubleVectorIndividual ind2 = (CoevolutionaryDoubleVectorIndividual)ind[1];
        double i = ind1.genome[0];
        double j = ind2.genome[0];
        double functionValue = this.rosenbrock(i, j);
        if (updateFitness[0] && functionValue > (double)ind1.fitness.fitness()) {
            ((SimpleFitness)ind1.fitness).setFitness(state, (float)functionValue, false);
            ind1.context = new CoevolutionaryDoubleVectorIndividual[2];
            ind1.context[1] = ind2;
        }
        if (updateFitness[1] && functionValue > (double)ind2.fitness.fitness()) {
            ((SimpleFitness)ind2.fitness).setFitness(state, (float)functionValue, false);
            ind2.context = new CoevolutionaryDoubleVectorIndividual[2];
            ind2.context[0] = ind1;
        }
    }
}

