/*
 * Decompiled with CFR 0.152.
 */
package ec.app.ecsuite;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.vector.DoubleVectorIndividual;

public class ECSuite
extends Problem
implements SimpleProblemForm {
    public static final String P_WHICH_PROBLEM = "type";
    public static final String V_ROSENBROCK = "rosenbrock";
    public static final String V_RASTRIGIN = "rastrigin";
    public static final String V_SPHERE = "sphere";
    public static final String V_STEP = "step";
    public static final String V_NOISY_QUARTIC = "noisy-quartic";
    public static final String V_F1 = "kdj-f1";
    public static final String V_F2 = "kdj-f2";
    public static final String V_F3 = "kdj-f3";
    public static final String V_F4 = "kdj-f4";
    public static final String V_BOOTH = "booth";
    public static final String V_GRIEWANGK = "griewangk";
    public static final String V_MEDIAN = "median";
    public static final int PROB_ROSENBROCK = 0;
    public static final int PROB_RASTRIGIN = 1;
    public static final int PROB_SPHERE = 2;
    public static final int PROB_STEP = 3;
    public static final int PROB_NOISY_QUARTIC = 4;
    public static final int PROB_BOOTH = 5;
    public static final int PROB_GRIEWANGK = 6;
    public static final int PROB_MEDIAN = 7;
    public int problemType = 0;
    public static final float A = 10.0f;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        String wp = state.parameters.getStringWithDefault(base.push(P_WHICH_PROBLEM), null, "");
        if (wp.compareTo(V_ROSENBROCK) == 0 || wp.compareTo(V_F2) == 0) {
            this.problemType = 0;
        } else if (wp.compareTo(V_RASTRIGIN) == 0) {
            this.problemType = 1;
        } else if (wp.compareTo(V_SPHERE) == 0 || wp.compareTo(V_F1) == 0) {
            this.problemType = 2;
        } else if (wp.compareTo(V_STEP) == 0 || wp.compareTo(V_F3) == 0) {
            this.problemType = 3;
        } else if (wp.compareTo(V_NOISY_QUARTIC) == 0 || wp.compareTo(V_F4) == 0) {
            this.problemType = 4;
        } else if (wp.compareTo(V_BOOTH) == 0) {
            this.problemType = 5;
        } else if (wp.compareTo(V_GRIEWANGK) == 0) {
            this.problemType = 6;
        } else if (wp.compareTo(V_MEDIAN) == 0) {
            this.problemType = 7;
        } else {
            state.output.fatal("Invalid value for parameter, or parameter not found.\nAcceptable values are:\n  rosenbrock(or kdj-f2)\n  rastrigin\n  sphere(or kdj-f1)\n  step(or kdj-f3)\n  noisy-quartic(or kdj-f4)\n  booth\n  griewangk\n  median\n", base.push(P_WHICH_PROBLEM));
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!(ind instanceof DoubleVectorIndividual)) {
            state.output.fatal("The individuals for this problem should be DoubleVectorIndividuals.");
        }
        DoubleVectorIndividual temp = (DoubleVectorIndividual)ind;
        double[] genome = temp.genome;
        int len = genome.length;
        double fit = this.function(state, this.problemType, temp.genome, threadnum);
        boolean isOptimal = this.isOptimal(this.problemType, fit);
        ((SimpleFitness)ind.fitness).setFitness(state, (float)fit, isOptimal);
        ind.evaluated = true;
    }

    public boolean isOptimal(int function, double fitness) {
        switch (this.problemType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return fitness == 0.0;
            }
        }
        return false;
    }

    public double function(EvolutionState state, int function, double[] genome, int threadnum) {
        double value = 0.0;
        int len = genome.length;
        switch (function) {
            case 0: {
                for (int i = 1; i < len; ++i) {
                    value += 100.0 * (genome[i - 1] * genome[i - 1] - genome[i]) * (genome[i - 1] * genome[i - 1] - genome[i]) + (1.0 - genome[i - 1]) * (1.0 - genome[i - 1]);
                }
                return -value;
            }
            case 1: {
                value = (float)len * 10.0f;
                for (int i = 0; i < len; ++i) {
                    value += genome[i] * genome[i] - 10.0 * Math.cos(Math.PI * 2 * genome[i]);
                }
                return -value;
            }
            case 2: {
                for (int i = 0; i < len; ++i) {
                    value += genome[i] * genome[i];
                }
                return -value;
            }
            case 3: {
                for (int i = 0; i < len; ++i) {
                    value += 6.0 + Math.floor(genome[i]);
                }
                return -value;
            }
            case 4: {
                for (int i = 0; i < len; ++i) {
                    value += (double)(i + 1) * (genome[i] * genome[i] * genome[i] * genome[i]) + state.random[threadnum].nextDouble();
                }
                return -value;
            }
            case 5: {
                if (len != 2) {
                    state.output.fatal("The Booth problem is defined for only two terms, and as a consequence the genome of the DoubleVectorIndividual should have size 2.");
                }
                value = (genome[0] + 2.0 * genome[1] - 7.0) * (genome[0] + 2.0 * genome[1] - 7.0) + (2.0 * genome[0] + genome[1] - 5.0) * (2.0 * genome[0] + genome[1] - 5.0);
                return -value;
            }
            case 6: {
                value = 1.0;
                double prod = 1.0;
                for (int i = 0; i < len; ++i) {
                    value += genome[i] * genome[i] / 4000.0;
                    prod *= Math.cos(genome[i] / Math.sqrt(i + 1));
                }
                return -(value -= prod);
            }
            case 7: {
                double[] sorted = new double[genome.length];
                System.arraycopy(genome, 0, sorted, 0, sorted.length);
                QuickSort.qsort(sorted);
                return sorted[sorted.length / 2];
            }
        }
        state.output.fatal("ec.app.ecsuite.ECSuite has an invalid problem -- how on earth did that happen?");
        return 0.0;
    }
}

