/*
 * Decompiled with CFR 0.152.
 */
package ec.app.edge;

import ec.EvolutionState;
import ec.Individual;
import ec.app.edge.EdgeData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class Edge
extends GPProblem
implements SimpleProblemForm {
    public static final String P_GENERALIZE = "generalize";
    public static final String P_ALLPOS = "allpos";
    public static final String P_ALLNEG = "allneg";
    public static final String P_TESTPOS = "testpos";
    public static final String P_TESTNEG = "testneg";
    public static final String P_MAXTEST = "maxtest";
    public static final int MIN_ARRAY_SIZE = 64;
    public static final int BAD = 0;
    public static final int READING0 = 1;
    public static final int READING1 = 2;
    public static final int EPSILON = 3;
    public EdgeData input;
    public boolean[] start;
    public boolean[] accept;
    public int numNodes;
    public int[] from;
    public int[] to;
    public int[] reading;
    public int numEdges;
    public int[][] reading1;
    public int[] reading1_l;
    public int[][] reading0;
    public int[] reading0_l;
    public int[][] epsilon;
    public int[] epsilon_l;
    public boolean[][] posT;
    public boolean[][] negT;
    public boolean[][] posA;
    public boolean[][] negA;
    public boolean[] state1;
    public boolean[] state2;
    public boolean generalize;
    public static final int J_LEFT = 0;
    public static final int J_RIGHT = 1;
    public static final int J_CENTER = 2;
    int totpos;
    int totneg;

    public Object clone() {
        Edge myobj = (Edge)super.clone();
        myobj.input = (EdgeData)this.input.clone();
        return myobj;
    }

    public static String fill(int num, char c) {
        char[] buf = new char[num];
        for (int x = 0; x < num; ++x) {
            buf[x] = c;
        }
        return new String(buf);
    }

    public static String justify(String s, int len, int justification) {
        int size = len - s.length();
        if (size < 0) {
            size = 0;
        }
        switch (justification) {
            case 0: {
                return s + Edge.fill(size, ' ');
            }
            case 1: {
                return Edge.fill(size, ' ') + s;
            }
        }
        return Edge.fill(size / 2, ' ') + s + Edge.fill(size - size / 2, ' ');
    }

    public String printCurrentNFA() {
        int strsize = String.valueOf(this.numNodes).length();
        String str = "";
        for (int x = 0; x < this.numNodes; ++x) {
            int y;
            str = str + Edge.justify(String.valueOf(x), strsize, 1) + " " + (this.start[x] ? "S" : " ") + (this.accept[x] ? "A" : " ") + " -> ";
            if (this.reading0_l[x] > 0) {
                str = str + "(0:";
                for (y = 0; y < this.reading0_l[x]; ++y) {
                    str = str + (y > 0 ? "," : "") + String.valueOf(this.reading0[x][y]);
                }
                str = str + ") ";
            }
            if (this.reading1_l[x] > 0) {
                str = str + "(1:";
                for (y = 0; y < this.reading1_l[x]; ++y) {
                    str = str + (y > 0 ? "," : "") + String.valueOf(this.reading1[x][y]);
                }
                str = str + ") ";
            }
            if (this.epsilon_l[x] > 0) {
                str = str + "(e:";
                for (y = 0; y < this.epsilon_l[x]; ++y) {
                    str = str + (y > 0 ? "," : "") + String.valueOf(this.epsilon[x][y]);
                }
                str = str + ")";
            }
            str = str + "\n";
        }
        return str;
    }

    public boolean[][] restrictToSize(int size, boolean[][] cases, EvolutionState state, int thread) {
        int csize = cases.length;
        if (csize < size) {
            return cases;
        }
        Hashtable<boolean[], boolean[]> hash = new Hashtable<boolean[], boolean[]>();
        for (int x = 0; x < size; ++x) {
            boolean[] b;
            while (hash.contains(b = cases[state.random[thread].nextInt(csize)])) {
            }
            hash.put(b, b);
        }
        boolean[][] newcases = new boolean[size][];
        Enumeration e = hash.keys();
        for (int x = 0; x < size; ++x) {
            newcases[x] = (boolean[])e.nextElement();
        }
        Arrays.sort(newcases, new Comparator(){

            public int compare(Object a, Object b) {
                boolean[] aa = (boolean[])a;
                boolean[] bb = (boolean[])b;
                for (int x = 0; x < Math.min(aa.length, bb.length); ++x) {
                    if (!aa[x] && bb[x]) {
                        return -1;
                    }
                    if (!aa[x] || bb[x]) continue;
                    return 1;
                }
                if (aa.length < bb.length) {
                    return -1;
                }
                if (aa.length > bb.length) {
                    return 1;
                }
                return 0;
            }
        });
        return newcases;
    }

    public boolean[][] slurp(File f) throws IOException {
        String bits;
        LineNumberReader r = new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(f))));
        Vector<boolean[]> v = new Vector<boolean[]>();
        while ((bits = r.readLine()) != null) {
            int len = (bits = bits.trim()).length();
            if (len == 0 || bits.charAt(0) == '#') continue;
            if (bits.equalsIgnoreCase("e")) {
                v.addElement(new boolean[0]);
                continue;
            }
            boolean[] b = new boolean[len];
            for (int x = 0; x < len; ++x) {
                b[x] = bits.charAt(x) == '1';
            }
            v.addElement(b);
        }
        r.close();
        boolean[][] result = new boolean[v.size()][];
        v.copyInto((Object[])result);
        return result;
    }

    public void printBits(EvolutionState state, boolean[][] bits) {
        for (int x = 0; x < bits.length; ++x) {
            StringBuffer s = new StringBuffer();
            for (int y = 0; y < bits[x].length; ++y) {
                if (bits[x][y]) {
                    s.append('1');
                    continue;
                }
                s.append('0');
            }
            if (s.length() == 0) {
                state.output.message("(empty)");
                continue;
            }
            state.output.message(s.toString());
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.generalize = state.parameters.getBoolean(base.push(P_GENERALIZE), null, false);
        File ap = null;
        File an = null;
        File tp = null;
        File tn = null;
        if (this.generalize) {
            ap = state.parameters.getFile(base.push(P_ALLPOS), null);
            an = state.parameters.getFile(base.push(P_ALLNEG), null);
        }
        tp = state.parameters.getFile(base.push(P_TESTPOS), null);
        tn = state.parameters.getFile(base.push(P_TESTNEG), null);
        if (this.generalize) {
            if (ap == null) {
                state.output.error("File doesn't exist", base.push(P_ALLPOS));
            }
            if (an == null) {
                state.output.error("File doesn't exist", base.push(P_ALLNEG));
            }
        }
        if (tp == null) {
            state.output.error("File doesn't exist", base.push(P_TESTPOS));
        }
        if (tn == null) {
            state.output.error("File doesn't exist", base.push(P_TESTNEG));
        }
        state.output.exitIfErrors();
        if (this.generalize) {
            if (!ap.canRead()) {
                state.output.error("File cannot be read", base.push(P_ALLPOS));
            }
            if (!an.canRead()) {
                state.output.error("File cannot be read", base.push(P_ALLNEG));
            }
        }
        if (!tp.canRead()) {
            state.output.error("File cannot be read", base.push(P_TESTPOS));
        }
        if (!tn.canRead()) {
            state.output.error("File cannot be read", base.push(P_TESTNEG));
        }
        state.output.exitIfErrors();
        if (this.generalize) {
            state.output.message("Reading Positive Examples");
            try {
                this.posA = this.slurp(ap);
            }
            catch (IOException e) {
                state.output.error("IOException reading file (here it is)\n" + e, base.push(P_ALLPOS));
            }
            state.output.message("Reading Negative Examples");
            try {
                this.negA = this.slurp(an);
            }
            catch (IOException e) {
                state.output.error("IOException reading file (here it is)\n" + e, base.push(P_ALLNEG));
            }
        }
        state.output.message("Reading Positive Training Examples");
        try {
            this.posT = this.slurp(tp);
        }
        catch (IOException e) {
            state.output.error("IOException reading file (here it is)\n" + e, base.push(P_TESTPOS));
        }
        int restriction = state.parameters.getInt(base.push(P_MAXTEST), null, 1);
        if (restriction > 0) {
            state.output.message("Restricting to <= " + restriction + " Unique Examples");
            this.posT = this.restrictToSize(restriction, this.posT, state, 0);
        }
        state.output.message("");
        this.printBits(state, this.posT);
        state.output.message("");
        state.output.message("Reading Negative Training Examples");
        try {
            this.negT = this.slurp(tn);
        }
        catch (IOException e) {
            state.output.error("IOException reading file (here it is)\n" + e, base.push(P_TESTNEG));
        }
        restriction = state.parameters.getInt(base.push(P_MAXTEST), null, 1);
        if (restriction > 0) {
            state.output.message("Restricting to <= " + restriction + " Unique Examples");
            this.negT = this.restrictToSize(restriction, this.negT, state, 0);
        }
        state.output.message("");
        this.printBits(state, this.negT);
        state.output.message("");
        state.output.exitIfErrors();
        this.input = (EdgeData)state.parameters.getInstanceForParameterEq(base.push("data"), null, EdgeData.class);
        this.input.setup(state, base.push("data"));
    }

    public boolean test(boolean[] sample) {
        int x;
        boolean STATE_1 = false;
        boolean st = false;
        for (x = 0; x < this.numNodes; ++x) {
            this.state1[x] = this.start[x];
        }
        for (x = 0; x < sample.length; ++x) {
            int z;
            int y;
            boolean moreEpsilons;
            int z2;
            int y2;
            if (!st) {
                for (y2 = 0; y2 < this.numNodes; ++y2) {
                    this.state2[y2] = false;
                }
                for (y2 = 0; y2 < this.numNodes; ++y2) {
                    if (!this.state1[y2]) continue;
                    if (sample[x]) {
                        for (z2 = 0; z2 < this.reading1_l[y2]; ++z2) {
                            this.state2[this.reading1[y2][z2]] = true;
                        }
                        continue;
                    }
                    for (z2 = 0; z2 < this.reading0_l[y2]; ++z2) {
                        this.state2[this.reading0[y2][z2]] = true;
                    }
                }
                moreEpsilons = true;
                while (moreEpsilons) {
                    moreEpsilons = false;
                    for (y = 0; y < this.numNodes; ++y) {
                        if (!this.state2[y]) continue;
                        for (z = 0; z < this.epsilon_l[y]; ++z) {
                            if (!this.state2[this.epsilon[y][z]]) {
                                moreEpsilons = true;
                            }
                            this.state2[this.epsilon[y][z]] = true;
                        }
                    }
                }
            } else {
                for (y2 = 0; y2 < this.numNodes; ++y2) {
                    this.state1[y2] = false;
                }
                for (y2 = 0; y2 < this.numNodes; ++y2) {
                    if (!this.state2[y2]) continue;
                    if (sample[x]) {
                        for (z2 = 0; z2 < this.reading1_l[y2]; ++z2) {
                            this.state1[this.reading1[y2][z2]] = true;
                        }
                        continue;
                    }
                    for (z2 = 0; z2 < this.reading0_l[y2]; ++z2) {
                        this.state1[this.reading0[y2][z2]] = true;
                    }
                }
                moreEpsilons = true;
                while (moreEpsilons) {
                    moreEpsilons = false;
                    for (y = 0; y < this.numNodes; ++y) {
                        if (!this.state1[y]) continue;
                        for (z = 0; z < this.epsilon_l[y]; ++z) {
                            if (!this.state1[this.epsilon[y][z]]) {
                                moreEpsilons = true;
                            }
                            this.state1[this.epsilon[y][z]] = true;
                        }
                    }
                }
            }
            st = !st;
        }
        if (!st) {
            for (x = 0; x < this.numNodes; ++x) {
                if (!this.accept[x] || !this.state1[x]) continue;
                return true;
            }
        } else {
            for (x = 0; x < this.numNodes; ++x) {
                if (!this.accept[x] || !this.state2[x]) continue;
                return true;
            }
        }
        return false;
    }

    public void fullTest(EvolutionState state, Individual ind, int threadnum, boolean[][] pos, boolean[][] neg) {
        int y;
        this.numNodes = 2;
        this.numEdges = 1;
        this.from[0] = 0;
        this.to[0] = 1;
        this.accept[1] = false;
        this.accept[0] = false;
        this.start[1] = false;
        this.start[0] = false;
        this.input.edge = 0;
        ((GPIndividual)ind).trees[0].child.eval(state, threadnum, this.input, this.stack, (GPIndividual)ind, this);
        if (this.reading1.length < this.numNodes || this.reading1[0].length < this.numEdges) {
            this.reading1 = new int[this.numNodes * 2][this.numEdges * 2];
            this.reading0 = new int[this.numNodes * 2][this.numEdges * 2];
            this.epsilon = new int[this.numNodes * 2][this.numEdges * 2];
            this.reading1_l = new int[this.numNodes * 2];
            this.reading0_l = new int[this.numNodes * 2];
            this.epsilon_l = new int[this.numNodes * 2];
        }
        for (y = 0; y < this.numNodes; ++y) {
            this.reading1_l[y] = 0;
            this.reading0_l[y] = 0;
            this.epsilon_l[y] = 0;
        }
        block6: for (y = 0; y < this.numEdges; ++y) {
            switch (this.reading[y]) {
                case 1: {
                    int n = this.from[y];
                    int n2 = this.reading0_l[n];
                    this.reading0_l[n] = n2 + 1;
                    this.reading0[this.from[y]][n2] = this.to[y];
                    continue block6;
                }
                case 2: {
                    int n = this.from[y];
                    int n3 = this.reading1_l[n];
                    this.reading1_l[n] = n3 + 1;
                    this.reading1[this.from[y]][n3] = this.to[y];
                    continue block6;
                }
                case 3: {
                    int n = this.from[y];
                    int n4 = this.epsilon_l[n];
                    this.epsilon_l[n] = n4 + 1;
                    this.epsilon[this.from[y]][n4] = this.to[y];
                }
            }
        }
        if (this.state1.length < this.numNodes) {
            this.state1 = new boolean[this.numNodes * 2];
            this.state2 = new boolean[this.numNodes * 2];
        }
        this.totpos = 0;
        this.totneg = 0;
        for (y = 0; y < pos.length; ++y) {
            if (!this.test(pos[y])) continue;
            ++this.totpos;
        }
        for (y = 0; y < neg.length; ++y) {
            if (this.test(neg[y])) continue;
            ++this.totneg;
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (this.start == null) {
            this.start = new boolean[64];
            this.accept = new boolean[64];
            this.reading = new int[64];
            this.from = new int[64];
            this.to = new int[64];
            this.state1 = new boolean[64];
            this.state2 = new boolean[64];
            this.reading1 = new int[64][64];
            this.reading0 = new int[64][64];
            this.epsilon = new int[64][64];
            this.reading1_l = new int[64];
            this.reading0_l = new int[64];
            this.epsilon_l = new int[64];
        }
        if (!ind.evaluated) {
            this.fullTest(state, ind, threadnum, this.posT, this.negT);
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, (float)(1.0 - (double)(this.totpos + this.totneg) / (double)(this.posT.length + this.negT.length)));
            f.hits = this.totpos + this.totneg;
            ind.evaluated = true;
        }
    }

    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        if (this.start == null) {
            this.start = new boolean[64];
            this.accept = new boolean[64];
            this.reading = new int[64];
            this.from = new int[64];
            this.to = new int[64];
            this.state1 = new boolean[64];
            this.state2 = new boolean[64];
            this.reading1 = new int[64][64];
            this.reading0 = new int[64][64];
            this.epsilon = new int[64][64];
            this.reading1_l = new int[64];
            this.reading0_l = new int[64];
            this.epsilon_l = new int[64];
        }
        if (this.generalize) {
            this.fullTest(state, ind, threadnum, this.posA, this.negA);
        } else {
            this.fullTest(state, ind, threadnum, this.posT, this.negT);
        }
        if (this.generalize) {
            state.output.println("\n\nBest Individual's Generalization Score...\nPos: " + this.totpos + "/" + this.posA.length + " Neg: " + this.totneg + "/" + this.negA.length + "\n(pos+neg)/(allpos+allneg):     " + (float)((double)(this.totpos + this.totneg) / (double)(this.posA.length + this.negA.length)) + "\n((pos/allpos)+(neg/allneg))/2: " + (float)(((double)this.totpos / (double)this.posA.length + (double)this.totneg / (double)this.negA.length) / 2.0) + "\nMin(pos/allpos,neg/allneg):    " + (float)Math.min((double)this.totpos / (double)this.posA.length, (double)this.totneg / (double)this.negA.length), log);
        }
        state.output.println("\nBest Individual's NFA\n=====================\n", log);
        state.output.println(this.printCurrentNFA(), log);
    }

    public String describeShortGeneralized(Individual ind, EvolutionState state, int subpopulation, int threadnum) {
        if (this.start == null) {
            this.start = new boolean[64];
            this.accept = new boolean[64];
            this.reading = new int[64];
            this.from = new int[64];
            this.to = new int[64];
            this.state1 = new boolean[64];
            this.state2 = new boolean[64];
            this.reading1 = new int[64][64];
            this.reading0 = new int[64][64];
            this.epsilon = new int[64][64];
            this.reading1_l = new int[64];
            this.reading0_l = new int[64];
            this.epsilon_l = new int[64];
        }
        this.fullTest(state, ind, threadnum, this.posA, this.negA);
        return ": " + (double)this.totpos / (double)this.posA.length + " " + (double)this.totneg / (double)this.negA.length + " " + (double)(this.totpos + this.totneg) / (double)(this.posA.length + this.negA.length) + " " + ((double)this.totpos / (double)this.posA.length + (double)this.totneg / (double)this.negA.length) / 2.0 + " " + Math.min((double)this.totpos / (double)this.posA.length, (double)this.totneg / (double)this.negA.length) + " : ";
    }
}

