/*
 * Decompiled with CFR 0.152.
 */
package ec.app.lawnmower;

import ec.EvolutionState;
import ec.Individual;
import ec.app.lawnmower.LawnmowerData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class Lawnmower
extends GPProblem
implements SimpleProblemForm {
    public static final String P_X = "x";
    public static final String P_Y = "y";
    public static final int UNMOWED = 0;
    public static final int O_UP = 0;
    public static final int O_LEFT = 1;
    public static final int O_DOWN = 2;
    public static final int O_RIGHT = 3;
    public LawnmowerData input;
    public int[][] map;
    public int maxx;
    public int maxy;
    public int posx;
    public int posy;
    public int sum;
    public int orientation;
    public int moves;
    public int pmod;

    public Object clone() {
        Lawnmower myobj = (Lawnmower)super.clone();
        myobj.input = (LawnmowerData)this.input.clone();
        myobj.map = new int[this.map.length][];
        for (int x = 0; x < this.map.length; ++x) {
            myobj.map[x] = (int[])this.map[x].clone();
        }
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.input = (LawnmowerData)state.parameters.getInstanceForParameterEq(base.push("data"), null, LawnmowerData.class);
        this.input.setup(state, base.push("data"));
        this.maxx = state.parameters.getInt(base.push(P_X), null, 1);
        if (this.maxx == 0) {
            state.output.error("The width (x dimension) of the lawn must be >0", base.push(P_X));
        }
        this.maxy = state.parameters.getInt(base.push(P_Y), null, 1);
        if (this.maxy == 0) {
            state.output.error("The length (y dimension) of the lawn must be >0", base.push(P_Y));
        }
        state.output.exitIfErrors();
        this.map = new int[this.maxx][this.maxy];
        for (int x = 0; x < this.maxx; ++x) {
            for (int y = 0; y < this.maxy; ++y) {
                this.map[x][y] = 0;
            }
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            this.sum = 0;
            this.moves = 0;
            this.posx = this.maxx / 2 + 1;
            this.posy = this.maxy / 2 + 1;
            this.orientation = 0;
            ((GPIndividual)ind).trees[0].child.eval(state, threadnum, this.input, this.stack, (GPIndividual)ind, this);
            for (int x = 0; x < this.maxx; ++x) {
                for (int y = 0; y < this.maxy; ++y) {
                    this.map[x][y] = 0;
                }
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, this.maxx * this.maxy - this.sum);
            f.hits = this.sum;
            ind.evaluated = true;
        }
    }

    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        int y;
        int x;
        state.output.println("\n\nBest Individual's Map\n=====================", log);
        this.sum = 0;
        this.moves = 0;
        this.posx = this.maxx / 2 + 1;
        this.posy = this.maxy / 2 + 1;
        this.orientation = 0;
        ((GPIndividual)ind).trees[0].child.eval(state, threadnum, this.input, this.stack, (GPIndividual)ind, this);
        state.output.println(" Y ->", log);
        for (x = 0; x < this.map.length; ++x) {
            if (x == 1) {
                state.output.print("v", log);
            } else if (x == 0) {
                state.output.print("X", log);
            } else {
                state.output.print(" ", log);
            }
            state.output.print("+", log);
            for (y = 0; y < this.map[x].length; ++y) {
                state.output.print("----+", log);
            }
            state.output.println("", log);
            if (x == 0) {
                state.output.print("|", log);
            } else {
                state.output.print(" ", log);
            }
            state.output.print("|", log);
            for (y = 0; y < this.map[x].length; ++y) {
                if (this.map[x][y] == 0) {
                    state.output.print("    ", log);
                    continue;
                }
                String s = "" + this.map[x][y];
                while (s.length() < 4) {
                    s = " " + s;
                }
                state.output.print(s + "|", log);
            }
            state.output.println("", log);
        }
        if (this.map.length == 1) {
            state.output.print("v", log);
        } else {
            state.output.print(" ", log);
        }
        state.output.print("+", log);
        for (int y2 = 0; y2 < this.map[this.map.length - 1].length; ++y2) {
            state.output.print("----+", log);
        }
        state.output.println("", log);
        for (x = 0; x < this.maxx; ++x) {
            for (y = 0; y < this.maxy; ++y) {
                this.map[x][y] = 0;
            }
        }
    }
}

