/*
 * Decompiled with CFR 0.152.
 */
package ec.app.lawnmower.func;

import ec.EvolutionState;
import ec.Problem;
import ec.app.lawnmower.Lawnmower;
import ec.app.lawnmower.LawnmowerData;
import ec.gp.ADFStack;
import ec.gp.GPData;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.util.Parameter;

public class Frog
extends GPNode {
    public String toString() {
        return "frog";
    }

    public void checkConstraints(EvolutionState state, int tree, GPIndividual typicalIndividual, Parameter individualBase) {
        super.checkConstraints(state, tree, typicalIndividual, individualBase);
        if (this.children.length != 1) {
            state.output.error("Incorrect number of children for node " + this.toStringForError() + " at " + individualBase);
        }
    }

    public void eval(EvolutionState state, int thread, GPData input, ADFStack stack, GPIndividual individual, Problem problem) {
        Lawnmower p = (Lawnmower)problem;
        LawnmowerData d = (LawnmowerData)input;
        this.children[0].eval(state, thread, input, stack, individual, problem);
        switch (p.orientation) {
            case 0: {
                p.posx -= d.y;
                p.posy += d.x;
                break;
            }
            case 1: {
                p.posx -= d.x;
                p.posy -= d.y;
                break;
            }
            case 2: {
                p.posx += d.y;
                p.posy -= d.x;
                break;
            }
            case 3: {
                p.posx += d.x;
                p.posy += d.y;
                break;
            }
            default: {
                state.output.fatal("Whoa, somehow I got a bad orientation! (" + p.orientation + ")");
            }
        }
        p.posx = (p.posx % p.maxx + p.maxx) % p.maxx;
        p.posy = (p.posy % p.maxy + p.maxy) % p.maxy;
        ++p.moves;
        if (p.map[p.posx][p.posy] == 0) {
            ++p.sum;
            p.map[p.posx][p.posy] = p.moves;
        }
    }
}

