/*
 * Decompiled with CFR 0.152.
 */
package ec.app.parity;

import ec.EvolutionState;
import ec.Individual;
import ec.app.parity.ParityData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class Parity
extends GPProblem
implements SimpleProblemForm {
    public static final String P_NUMBITS = "bits";
    public static final String P_EVEN = "even";
    public boolean doEven;
    public int numBits;
    public int totalSize;
    public int bits;
    public ParityData input;

    public Object clone() {
        Parity myobj = (Parity)super.clone();
        myobj.input = (ParityData)this.input.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.numBits = state.parameters.getIntWithMax(base.push(P_NUMBITS), null, 2, 31);
        if (this.numBits < 2) {
            state.output.fatal("The number of bits for Parity must be between 2 and 31 inclusive", base.push(P_NUMBITS));
        }
        this.totalSize = 1;
        for (int x = 0; x < this.numBits; ++x) {
            this.totalSize *= 2;
        }
        this.doEven = state.parameters.getBoolean(base.push(P_EVEN), null, true);
        this.input = (ParityData)state.parameters.getInstanceForParameterEq(base.push("data"), null, ParityData.class);
        this.input.setup(state, base.push("data"));
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            int sum = 0;
            this.bits = 0;
            while (this.bits < this.totalSize) {
                int tb = 0;
                for (int b = 0; b < this.numBits; ++b) {
                    tb += this.bits >>> b & 1;
                }
                ((GPIndividual)ind).trees[0].child.eval(state, threadnum, this.input, this.stack, (GPIndividual)ind, this);
                if (this.doEven && (this.input.x & 1) != (tb &= 1) || !this.doEven && (this.input.x & 1) == tb) {
                    ++sum;
                }
                ++this.bits;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, this.totalSize - sum);
            f.hits = sum;
            ind.evaluated = true;
        }
    }
}

