/*
 * Decompiled with CFR 0.152.
 */
package ec.app.regression;

import ec.EvolutionState;
import ec.Individual;
import ec.app.regression.RegressionData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class Regression
extends GPProblem
implements SimpleProblemForm {
    public static final String P_SIZE = "size";
    public double currentValue;
    public int trainingSetSize;
    public double[] inputs;
    public double[] outputs;
    public RegressionData input;

    public double func(double x) {
        return x * x * x * x + x * x * x + x * x + x;
    }

    public Object clone() {
        Regression myobj = (Regression)super.clone();
        myobj.input = (RegressionData)this.input.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.trainingSetSize = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (this.trainingSetSize < 1) {
            state.output.fatal("Training Set Size must be an integer greater than 0", base.push(P_SIZE));
        }
        this.inputs = new double[this.trainingSetSize];
        this.outputs = new double[this.trainingSetSize];
        for (int x = 0; x < this.trainingSetSize; ++x) {
            this.inputs[x] = state.random[0].nextDouble() * 2.0 - 1.0;
            this.outputs[x] = this.func(this.inputs[x]);
            state.output.message("{" + this.inputs[x] + "," + this.outputs[x] + "},");
        }
        this.input = (RegressionData)state.parameters.getInstanceForParameterEq(base.push("data"), null, RegressionData.class);
        this.input.setup(state, base.push("data"));
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            int hits = 0;
            double sum = 0.0;
            for (int y = 0; y < this.trainingSetSize; ++y) {
                this.currentValue = this.inputs[y];
                ((GPIndividual)ind).trees[0].child.eval(state, threadnum, this.input, this.stack, (GPIndividual)ind, this);
                double HIT_LEVEL = 0.01;
                double PROBABLY_ZERO = 1.11E-15;
                double BIG_NUMBER = 1.0E15;
                double result = Math.abs(this.outputs[y] - this.input.x);
                if (!(result < 1.0E15)) {
                    result = 1.0E15;
                } else if (result < 1.11E-15) {
                    result = 0.0;
                }
                if (result <= 0.01) {
                    ++hits;
                }
                sum += result;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, (float)sum);
            f.hits = hits;
            ind.evaluated = true;
        }
    }
}

