/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class BufferedBreedingPipeline
extends BreedingPipeline {
    public static final String P_BUFSIZE = "num-inds";
    public static final String P_BUFFERED = "buffered";
    public static final int INDS_PRODUCED = 1;
    public static final int NUM_SOURCES = 1;
    public Individual[] buffer;
    public int currentSize;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_BUFFERED);
    }

    public int numSources() {
        return 1;
    }

    public int typicalIndsProduced() {
        return 1;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        int bufsize = state.parameters.getInt(base.push(P_BUFSIZE), def.push(P_BUFSIZE), 1);
        if (bufsize == 0) {
            state.output.fatal("BufferedBreedingPipeline's number of individuals must be >= 1.", base.push(P_BUFSIZE), def.push(P_BUFSIZE));
        }
        this.buffer = new Individual[bufsize];
        this.currentSize = 0;
        if (this.likelihood < 1.0f) {
            state.output.warning("BufferedBreedingPipeline does not respond to the 'likelihood' parameter.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        super.prepareToProduce(state, subpopulation, thread);
        this.currentSize = 0;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        for (int q = start; q < min + start; ++q) {
            if (this.currentSize == 0) {
                this.sources[0].produce(this.buffer.length, this.buffer.length, 0, subpopulation, this.buffer, state, thread);
                this.currentSize = this.buffer.length;
                if (this.sources[0] instanceof SelectionMethod) {
                    for (int z = 0; z < this.buffer.length; ++z) {
                        this.buffer[z] = (Individual)this.buffer[z].clone();
                    }
                }
            }
            inds[q] = this.buffer[this.currentSize - 1];
            --this.currentSize;
        }
        return min;
    }
}

