/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class MultiBreedingPipeline
extends BreedingPipeline {
    public static final String P_GEN_MAX = "generate-max";
    public static final String P_MULTIBREED = "multibreed";
    public int maxGeneratable;
    public boolean generateMax;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_MULTIBREED);
    }

    public int numSources() {
        return 0;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        float total = 0.0f;
        for (int x = 0; x < this.sources.length; ++x) {
            if (!(this.sources[x] instanceof BreedingPipeline)) {
                state.output.error("Source #" + x + "is not a BreedingPipeline", base);
                continue;
            }
            if ((double)this.sources[x].probability < 0.0) {
                state.output.error("Pipe #" + x + " must have a probability >= 0.0", base);
                continue;
            }
            total += this.sources[x].probability;
        }
        state.output.exitIfErrors();
        if ((double)total == 0.0) {
            state.output.warning("MultiBreedingPipeline's children have all zero probabilities -- this will be treated as a uniform distribution.  This could be an error.", base);
        }
        BreedingSource.setupProbabilities(this.sources);
        this.generateMax = state.parameters.getBoolean(base.push(P_GEN_MAX), def.push(P_GEN_MAX), true);
        this.maxGeneratable = 0;
        if (this.likelihood < 1.0f) {
            state.output.warning("MultiBreedingPipeline does not respond to the 'likelihood' parameter.", base.push("likelihood"), def.push("likelihood"));
        }
    }

    public int typicalIndsProduced() {
        if (this.maxGeneratable == 0) {
            this.maxGeneratable = this.maxChildProduction();
        }
        return this.maxGeneratable;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int total;
        BreedingSource s = this.sources[BreedingSource.pickRandom(this.sources, state.random[thread].nextFloat())];
        if (this.generateMax) {
            int n;
            if (this.maxGeneratable == 0) {
                this.maxGeneratable = this.maxChildProduction();
            }
            if ((n = this.maxGeneratable) < min) {
                n = min;
            }
            if (n > max) {
                n = max;
            }
            total = s.produce(n, n, start, subpopulation, inds, state, thread);
        } else {
            total = s.produce(min, max, start, subpopulation, inds, state, thread);
        }
        if (s instanceof SelectionMethod) {
            for (int q = start; q < total + start; ++q) {
                inds[q] = (Individual)inds[q].clone();
            }
        }
        return total;
    }
}

