/*
 * Decompiled with CFR 0.152.
 */
package ec.es;

import ec.Breeder;
import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.es.ESDefaults;
import ec.es.MuLambdaBreederThread;
import ec.util.Parameter;
import java.util.Arrays;
import java.util.Comparator;

public class MuCommaLambdaBreeder
extends Breeder {
    public static final String P_MU = "mu";
    public static final String P_LAMBDA = "lambda";
    public int[] mu;
    public int[] lambda;
    public Population parentPopulation;
    public byte[] comparison;
    public static final byte C_OVER_ONE_FIFTH_BETTER = 1;
    public static final byte C_UNDER_ONE_FIFTH_BETTER = -1;
    public static final byte C_EXACTLY_ONE_FIFTH_BETTER = 0;
    public int[] count;
    int[] children;
    int[] parents;

    public void setup(EvolutionState state, Parameter base) {
        Parameter p = new Parameter("pop").push("subpops");
        int size = state.parameters.getInt(p, null, 1);
        this.mu = new int[size];
        this.lambda = new int[size];
        this.comparison = new byte[size];
        for (int x = 0; x < size; ++x) {
            this.lambda[x] = state.parameters.getInt(ESDefaults.base().push(P_LAMBDA).push("" + x), null, 1);
            if (this.lambda[x] == 0) {
                state.output.error("lambda must be an integer >= 1", ESDefaults.base().push(P_LAMBDA).push("" + x));
            }
            this.mu[x] = state.parameters.getInt(ESDefaults.base().push(P_MU).push("" + x), null, 1);
            if (this.mu[x] == 0) {
                state.output.error("mu must be an integer >= 1", ESDefaults.base().push(P_MU).push("" + x));
                continue;
            }
            if (this.lambda[x] / this.mu[x] * this.mu[x] == this.lambda[x]) continue;
            state.output.error("mu must be a multiple of lambda", ESDefaults.base().push(P_MU).push("" + x));
        }
        state.output.exitIfErrors();
    }

    public Population setToLambda(Population pop, EvolutionState state) {
        for (int x = 0; x < pop.subpops.length; ++x) {
            int s = this.lambda[x];
            if (pop.subpops[x].individuals.length == s) continue;
            Individual[] newinds = new Individual[s];
            System.arraycopy(pop.subpops[x].individuals, 0, newinds, 0, s < pop.subpops[x].individuals.length ? s : pop.subpops[x].individuals.length);
            pop.subpops[x].individuals = newinds;
        }
        return pop;
    }

    public Population breedPopulation(EvolutionState state) {
        int x;
        if (this.parentPopulation != null) {
            for (x = 0; x < state.population.subpops.length; ++x) {
                int numChildrenBetter = 0;
                for (int i = 0; i < this.lambda[x]; ++i) {
                    int parent = i / (this.lambda[x] / this.mu[x]);
                    if (!state.population.subpops[x].individuals[i].fitness.betterThan(this.parentPopulation.subpops[x].individuals[parent].fitness)) continue;
                    ++numChildrenBetter;
                }
                this.comparison[x] = (double)numChildrenBetter > (double)this.lambda[x] / 5.0 ? 1 : ((double)numChildrenBetter < (double)this.lambda[x] / 5.0 ? -1 : 0);
            }
        }
        this.parentPopulation = state.population;
        if (this.mu.length != state.population.subpops.length) {
            state.output.fatal("For some reason the number of subpops is different than was specified in the file (conflicting with Mu and Lambda storage).", null);
        }
        for (x = 0; x < state.population.subpops.length; ++x) {
            if (state.population.subpops[0].individuals.length >= this.mu[x]) continue;
            state.output.error("Subpopulation " + x + " must be a multiple of the equivalent mu (that is, " + this.mu[x] + ").");
        }
        state.output.exitIfErrors();
        int[][] numinds = new int[state.breedthreads][state.population.subpops.length];
        int[][] from = new int[state.breedthreads][state.population.subpops.length];
        for (int x2 = 0; x2 < state.population.subpops.length; ++x2) {
            Individual[] i = state.population.subpops[x2].individuals;
            Arrays.sort(i, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Individual a = (Individual)o1;
                    Individual b = (Individual)o2;
                    if (b.fitness.betterThan(a.fitness)) {
                        return 1;
                    }
                    if (a.fitness.betterThan(b.fitness)) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        Population newpop = this.setToLambda((Population)state.population.emptyClone(), state);
        this.count = new int[state.breedthreads];
        for (int y = 0; y < state.breedthreads; ++y) {
            for (int x3 = 0; x3 < state.population.subpops.length; ++x3) {
                numinds[y][x3] = y < state.breedthreads - 1 ? this.lambda[x3] / state.breedthreads : this.lambda[x3] / state.breedthreads + (this.lambda[x3] - this.lambda[x3] / state.breedthreads * state.breedthreads);
                from[y][x3] = this.lambda[x3] / state.breedthreads * y;
            }
        }
        if (state.breedthreads == 1) {
            this.breedPopChunk(newpop, state, numinds[0], from[0], 0);
        } else {
            int y;
            Thread[] t = new Thread[state.breedthreads];
            for (y = 0; y < state.breedthreads; ++y) {
                MuLambdaBreederThread r = new MuLambdaBreederThread();
                r.threadnum = y;
                r.newpop = newpop;
                r.numinds = numinds[y];
                r.from = from[y];
                r.me = this;
                r.state = state;
                t[y] = new Thread(r);
                t[y].start();
            }
            for (y = 0; y < state.breedthreads; ++y) {
                try {
                    t[y].join();
                    continue;
                }
                catch (InterruptedException e) {
                    state.output.fatal("Whoa! The main breeding thread got interrupted!  Dying...");
                }
            }
        }
        return this.postProcess(newpop, state.population, state);
    }

    public Population postProcess(Population newpop, Population oldpop, EvolutionState state) {
        return newpop;
    }

    public void breedPopChunk(Population newpop, EvolutionState state, int[] numinds, int[] from, int threadnum) {
        for (int subpop = 0; subpop < newpop.subpops.length; ++subpop) {
            this.count[threadnum] = 0;
            BreedingPipeline bp = (BreedingPipeline)newpop.subpops[subpop].species.pipe_prototype.clone();
            if (!bp.produces(state, newpop, subpop, threadnum)) {
                state.output.fatal("The Breeding Pipeline of subpopulation " + subpop + " does not produce individuals of the expected species " + newpop.subpops[subpop].species.getClass().getName() + " or fitness " + newpop.subpops[subpop].species.f_prototype);
            }
            bp.prepareToProduce(state, subpop, threadnum);
            if (this.count[threadnum] == 0) {
                state.output.warning("Whoa!  Breeding Pipeline for subpop " + subpop + " doesn't have an ESSelection, but is being used by MuCommaLambdaBreeder or MuPlusLambdaBreeder.  That's probably not right.");
            }
            this.count[threadnum] = 0;
            int upperbound = from[subpop] + numinds[subpop];
            for (int x = from[subpop]; x < upperbound; ++x) {
                if (bp.produce(1, 1, x, subpop, newpop.subpops[subpop].individuals, state, threadnum) != 1) {
                    state.output.fatal("Whoa! Breeding Pipeline for subpop " + subpop + " is not producing one individual at a time, as is required by the MuLambda strategies.");
                }
                int n = threadnum;
                this.count[n] = this.count[n] + 1;
            }
            bp.finishProducing(state, subpop, threadnum);
        }
    }
}

