/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.Individual;
import ec.util.DataPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Job {
    int type;
    boolean sent = false;
    Individual[] inds;
    Individual[] newinds;
    int[] subPops;
    boolean countVictoriesOnly;
    boolean[] updateFitness;

    void copyIndividualsForward() {
        if (this.newinds == null || this.newinds.length != this.inds.length) {
            this.newinds = new Individual[this.inds.length];
        }
        for (int i = 0; i < this.inds.length; ++i) {
            this.newinds[i] = (Individual)this.inds[i].clone();
        }
    }

    void copyIndividualsBack(EvolutionState state) {
        try {
            DataPipe p = new DataPipe();
            DataInputStream in = p.input;
            DataOutputStream out = p.output;
            for (int i = 0; i < this.inds.length; ++i) {
                p.reset();
                this.newinds[i].writeIndividual(state, out);
                this.inds[i].readIndividual(state, in);
            }
            this.newinds = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            state.output.fatal("Caught impossible IOException in Job.copyIndividualsBack()");
        }
    }
}

