/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Problem;
import ec.coevolve.GroupedProblemForm;
import ec.eval.Job;
import ec.eval.SlaveMonitor;
import ec.simple.SimpleProblemForm;
import ec.steadystate.QueueIndividual;
import ec.util.Parameter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class MasterProblem
extends Problem
implements SimpleProblemForm,
GroupedProblemForm {
    public static final String P_DEBUG_INFO = "debug-info";
    public static final String P_JOB_SIZE = "job-size";
    int jobSize;
    boolean showDebugInfo;
    public Problem problem;
    public boolean batchMode;
    public SlaveMonitor monitor;
    ArrayList queue;

    public Object clone() {
        MasterProblem c = (MasterProblem)super.clone();
        c.monitor = this.monitor;
        c.batchMode = this.batchMode;
        c.jobSize = this.jobSize;
        c.showDebugInfo = this.showDebugInfo;
        c.problem = (Problem)this.problem.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        Thread.currentThread().setName("MainThread: ");
        super.setup(state, base);
        this.showDebugInfo = state.parameters.getBoolean(base.push(P_DEBUG_INFO), null, false);
        this.jobSize = state.parameters.getIntWithDefault(base.push(P_JOB_SIZE), null, 1);
        if (this.jobSize <= 0) {
            state.output.fatal("The job size must be an integer > 0.", base.push(P_JOB_SIZE));
        }
        this.batchMode = false;
    }

    public void prepareToEvaluate(EvolutionState state, int threadnum) {
        if (this.jobSize > 1) {
            this.queue = new ArrayList();
        }
        this.batchMode = true;
    }

    public void finishEvaluating(EvolutionState state, int threadnum) {
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "Waiting for all slaves to finish.");
        }
        this.flush(state, threadnum);
        this.queue = null;
        this.monitor.waitForAllSlavesToFinishEvaluating(state);
        this.batchMode = false;
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "All slaves have finished their jobs.");
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (this.jobSize > 1 && this.batchMode) {
            this.queue.add(new QueueIndividual(ind, subpopulation));
            if (this.queue.size() >= this.jobSize) {
                this.flush(state, threadnum);
            }
        } else {
            this.evaluate(state, new Individual[]{ind}, new int[]{subpopulation}, threadnum);
        }
    }

    void flush(EvolutionState state, int threadnum) {
        if (this.queue != null && this.queue.size() > 0) {
            Individual[] inds = new Individual[this.queue.size()];
            int[] subpopulations = new int[this.queue.size()];
            for (int i = 0; i < this.queue.size(); ++i) {
                QueueIndividual qind = (QueueIndividual)this.queue.get(i);
                inds[i] = qind.ind;
                subpopulations[i] = qind.subpop;
            }
            this.evaluate(state, inds, subpopulations, threadnum);
        }
        this.queue = new ArrayList();
    }

    void evaluate(EvolutionState state, Individual[] inds, int[] subpopulations, int threadnum) {
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "Starting a " + (this.batchMode ? "batched " : "") + "SimpleProblemForm evaluation.");
        }
        Job job = new Job();
        job.type = 1;
        job.inds = inds;
        job.subPops = subpopulations;
        job.updateFitness = new boolean[inds.length];
        for (int i = 0; i < inds.length; ++i) {
            job.updateFitness[i] = true;
        }
        this.monitor.scheduleJobForEvaluation(state, job);
        if (!this.batchMode) {
            this.monitor.waitForAllSlavesToFinishEvaluating(state);
        }
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "Finished a " + (this.batchMode ? "batched " : "") + "SimpleProblemForm evaluation.");
        }
    }

    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        if (this.problem instanceof SimpleProblemForm) {
            ((SimpleProblemForm)((Object)this.problem)).describe(state, ind, subpopulation, threadnum, log);
        }
    }

    public void preprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        if (!(this.problem instanceof GroupedProblemForm)) {
            state.output.fatal("MasterProblem.preprocessPopulation(...) invoked, but the underlying Problem is not of GroupedProblemForm");
        }
        ((GroupedProblemForm)((Object)this.problem)).preprocessPopulation(state, pop, countVictoriesOnly);
    }

    public void postprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        if (!(this.problem instanceof GroupedProblemForm)) {
            state.output.fatal("MasterProblem.postprocessPopulation(...) invoked, but the underlying Problem is not of GroupedProblemForm");
        }
        ((GroupedProblemForm)((Object)this.problem)).postprocessPopulation(state, pop, countVictoriesOnly);
    }

    public void evaluate(EvolutionState state, Individual[] inds, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        if (this.showDebugInfo) {
            state.output.message("Starting a GroupedProblemForm evaluation.");
        }
        Job job = new Job();
        job.type = 2;
        job.subPops = subpops;
        job.countVictoriesOnly = countVictoriesOnly;
        job.inds = inds;
        job.updateFitness = updateFitness;
        this.monitor.scheduleJobForEvaluation(state, job);
        if (!this.batchMode) {
            this.monitor.waitForAllSlavesToFinishEvaluating(state);
        }
        if (this.showDebugInfo) {
            state.output.message("Finished the GroupedProblemForm evaluation.");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.problem);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.problem = (Problem)in.readObject();
    }

    public void initializeContacts(EvolutionState state) {
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "Spawning the server thread.");
        }
        this.monitor = new SlaveMonitor(state, this.showDebugInfo);
    }

    public void reinitializeContacts(EvolutionState state) {
        this.initializeContacts(state);
    }

    public void closeContacts(EvolutionState state, int result) {
        this.monitor.shutdown();
    }

    public boolean canEvaluate() {
        return this.monitor.numAvailableSlaves() != 0;
    }

    public boolean evaluatedIndividualAvailable() {
        return this.monitor.evaluatedIndividualAvailable();
    }

    public QueueIndividual getNextEvaluatedIndividual() {
        return this.monitor.waitForIndividual();
    }
}

