/*
 * Decompiled with CFR 0.152.
 */
package ec.exchange;

import ec.EvolutionState;
import ec.Exchanger;
import ec.Individual;
import ec.Population;
import ec.SelectionMethod;
import ec.exchange.IslandExchangeMailbox;
import ec.exchange.IslandExchangeServer;
import ec.select.RandomSelection;
import ec.util.LocalHost;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class IslandExchange
extends Exchanger {
    public static final String P_SERVER_ADDRESS = "server-addr";
    public static final String P_SERVER_PORT = "server-port";
    public static final String P_CLIENT_PORT = "client-port";
    public static final String P_IS_SERVER = "i-am-server";
    public static final String P_OWN_ID = "id";
    public static final String P_COMPRESSED_COMMUNICATION = "compressed";
    public static final String P_SELECT_METHOD = "select";
    public static final String P_SELECT_TO_DIE_METHOD = "select-to-die";
    public static final int SLEEP_TIME = 100;
    public static final int FOUND_TIMEOUT = 100;
    public static final String P_CHATTY = "chatty";
    public static final String OKAY = "okay";
    public static final String SYNC = "sync";
    public static final String FOUND = "found";
    boolean chatty;
    public Thread serverThread;
    public Parameter base;
    public String serverAddress;
    public int serverPort;
    public int clientPort;
    public boolean iAmServer;
    public String ownId;
    public boolean compressedCommunication;
    public SelectionMethod immigrantsSelectionMethod;
    public SelectionMethod indsToDieSelectionMethod;
    IslandExchangeMailbox mailbox;
    Thread mailboxThread;
    int number_of_destination_islands;
    public boolean synchronous;
    public int modulo;
    public int offset;
    public int size;
    Socket[] outSockets;
    DataOutputStream[] outWriters;
    String[] outgoingIds;
    boolean[] running;
    Socket serverSocket;
    DataOutputStream toServer;
    DataInputStream fromServer;
    static boolean just_server;
    boolean alreadyReadGoodBye = false;
    String message;

    public static void main(String[] args) throws InterruptedException {
        just_server = true;
        ParameterDatabase parameters = null;
        System.err.println("Island Exchange Server\nUsed in ECJ by Sean Luke\n");
        for (int x = 0; x < args.length - 1; ++x) {
            if (!args[x].equals("-file")) continue;
            try {
                parameters = new ParameterDatabase(new File(new File(args[x + 1]).getAbsolutePath()), args);
                break;
            }
            catch (FileNotFoundException e) {
                Output.initialError("A File Not Found Exception was generated uponreading the parameter file \"" + args[x + 1] + "\".\nHere it is:\n" + e);
                continue;
            }
            catch (IOException e) {
                Output.initialError("An IO Exception was generated upon reading theparameter file \"" + args[x + 1] + "\".\nHere it is:\n" + e);
            }
        }
        if (parameters == null) {
            Output.initialError("No parameter file was specified.");
        }
        Output output = new Output(true);
        output.addLog(0, false);
        output.addLog(1, true);
        EvolutionState myEvolutionState = new EvolutionState();
        myEvolutionState.parameters = parameters;
        myEvolutionState.output = output;
        Parameter myBase = new Parameter("exch");
        IslandExchange ie = (IslandExchange)parameters.getInstanceForParameterEq(myBase, null, IslandExchange.class);
        ie.setup(myEvolutionState, myBase);
        ie.fireUpServer(myEvolutionState, myBase);
        ie.serverThread.join();
        output.flush();
        System.err.flush();
        System.out.flush();
        System.exit(0);
    }

    public void setup(EvolutionState state, Parameter _base) {
        this.base = _base;
        Parameter p = this.base.push(P_SERVER_PORT);
        this.serverPort = state.parameters.getInt(p, null, 1);
        if (this.serverPort == 0) {
            state.output.fatal("Could not get the port of the server, or it is invalid.", p);
        }
        this.chatty = state.parameters.getBoolean(this.base.push(P_CHATTY), null, true);
        this.compressedCommunication = state.parameters.getBoolean(this.base.push(P_COMPRESSED_COMMUNICATION), null, false);
        if (this.compressedCommunication) {
            state.output.message("Communication will be compressed");
        }
        p = this.base.push(P_IS_SERVER);
        this.iAmServer = state.parameters.getBoolean(p, null, false);
        if (just_server) {
            try {
                state.output.message("IP ADDRESS: " + LocalHost.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {}
        } else {
            p = this.base.push(P_SELECT_METHOD);
            this.immigrantsSelectionMethod = (SelectionMethod)state.parameters.getInstanceForParameter(p, null, SelectionMethod.class);
            this.immigrantsSelectionMethod.setup(state, this.base);
            p = this.base.push(P_SELECT_TO_DIE_METHOD);
            this.indsToDieSelectionMethod = state.parameters.exists(p, null) ? (SelectionMethod)state.parameters.getInstanceForParameter(p, null, SelectionMethod.class) : new RandomSelection();
            this.indsToDieSelectionMethod.setup(state, this.base);
            p = this.base.push(P_SERVER_ADDRESS);
            this.serverAddress = state.parameters.getStringWithDefault(p, null, "");
            if (this.serverAddress.equalsIgnoreCase("")) {
                state.output.fatal("Could not get the address of the server.", p);
            }
            p = this.base.push(P_CLIENT_PORT);
            this.clientPort = state.parameters.getInt(p, null, 1);
            if (this.clientPort == 0) {
                state.output.fatal("Could not get the port of the client, or it is invalid.", p);
            }
            p = this.base.push(P_OWN_ID);
            this.ownId = state.parameters.getStringWithDefault(p, null, "");
            if (this.ownId.equals("")) {
                state.output.fatal("Could not get the Id of the island.", p);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.base);
        out.writeObject(this.serverAddress);
        out.writeObject(this.ownId);
        out.writeBoolean(this.compressedCommunication);
        out.writeObject(this.immigrantsSelectionMethod);
        out.writeObject(this.indsToDieSelectionMethod);
        out.writeInt(this.serverPort);
        out.writeInt(this.clientPort);
        out.writeBoolean(this.iAmServer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.base = (Parameter)in.readObject();
        this.serverAddress = (String)in.readObject();
        this.ownId = (String)in.readObject();
        this.compressedCommunication = in.readBoolean();
        this.immigrantsSelectionMethod = (SelectionMethod)in.readObject();
        this.indsToDieSelectionMethod = (SelectionMethod)in.readObject();
        this.serverPort = in.readInt();
        this.clientPort = in.readInt();
        this.iAmServer = in.readBoolean();
    }

    public void fireUpServer(EvolutionState state, Parameter serverBase) {
        IslandExchangeServer serv = new IslandExchangeServer();
        serv.setupServerFromDatabase(state, serverBase);
        this.serverThread = serv.spawnThread();
    }

    public void initializeContacts(EvolutionState state) {
        if (this.iAmServer) {
            this.fireUpServer(state, this.base);
            state.output.message("Server Launched.");
        } else {
            state.output.message("I'm just a client.");
        }
        long l = 0L;
        try {
            state.output.message("Connecting to Server " + this.serverAddress + ", port " + this.serverPort);
            while (true) {
                try {
                    this.serverSocket = new Socket(this.serverAddress, this.serverPort);
                }
                catch (IOException e) {
                    ++l;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException f) {
                        state.output.message("" + f);
                    }
                    state.output.message("Retrying");
                    continue;
                }
                break;
            }
            state.output.message("Connected to Server after " + l * 100L + " ms");
            this.fromServer = new DataInputStream(this.serverSocket.getInputStream());
            this.toServer = new DataOutputStream(this.serverSocket.getOutputStream());
            this.toServer.writeUTF(this.ownId);
            this.toServer.flush();
            this.mailbox = new IslandExchangeMailbox(state, this.clientPort, this.fromServer.readInt(), this.fromServer.readInt(), this.ownId, this.chatty, this.compressedCommunication);
            this.mailboxThread = new Thread(this.mailbox);
            this.mailboxThread.start();
            state.output.message("IslandExchangeMailbox created.");
            try {
                this.toServer.writeUTF(LocalHost.getLocalHost().getHostAddress());
                this.toServer.flush();
                state.output.message("My address is: " + LocalHost.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                state.output.fatal("Could not get the address of the local computer.");
            }
            this.toServer.writeInt(this.mailbox.getPort());
            this.toServer.flush();
            boolean bl = this.synchronous = this.fromServer.readInt() == 1;
            if (this.synchronous) {
                state.output.message("The communication will be synchronous.");
            } else {
                state.output.message("The communication will be asynchronous.");
            }
            this.modulo = this.fromServer.readInt();
            this.offset = this.fromServer.readInt();
            this.size = this.fromServer.readInt();
            this.number_of_destination_islands = this.fromServer.readInt();
            this.outSockets = new Socket[this.number_of_destination_islands];
            this.outWriters = new DataOutputStream[this.number_of_destination_islands];
            this.running = new boolean[this.number_of_destination_islands];
            this.outgoingIds = new String[this.number_of_destination_islands];
            for (int y = 0; y < this.number_of_destination_islands; ++y) {
                String address = this.fromServer.readUTF().trim();
                int port = this.fromServer.readInt();
                try {
                    try {
                        state.output.message("Trying to connect to " + address + " : " + port);
                        this.outSockets[y] = new Socket(address, port);
                    }
                    catch (UnknownHostException e) {
                        state.output.warning("Unknown host exception while the client was opening a socket to " + address + " : " + port);
                        this.running[y] = false;
                        continue;
                    }
                    if (this.compressedCommunication) {
                        OutputStream compressedo = Output.makeCompressingOutputStream(this.outSockets[y].getOutputStream());
                        InputStream compressedi = Output.makeCompressingInputStream(this.outSockets[y].getInputStream());
                        if (compressedi == null || compressedo == null) {
                            state.output.fatal("You do not appear to have JZLib installed on your system, and so may must have compression turned off for IslandExchange.  To get JZLib, download from the ECJ website or from http://www.jcraft.com/jzlib/");
                        }
                        this.outWriters[y] = new DataOutputStream(compressedo);
                        this.outgoingIds[y] = new DataInputStream(compressedi).readUTF().trim();
                    } else {
                        this.outWriters[y] = new DataOutputStream(this.outSockets[y].getOutputStream());
                        this.outgoingIds[y] = new DataInputStream(this.outSockets[y].getInputStream()).readUTF().trim();
                    }
                    this.outWriters[y].writeUTF(this.ownId);
                    this.outWriters[y].flush();
                    this.running[y] = true;
                    continue;
                }
                catch (IOException e) {
                    state.output.warning("IO exception while the client was opening sockets to other islands' mailboxes :" + e);
                    this.running[y] = false;
                }
            }
            this.toServer.writeUTF(OKAY);
            this.toServer.flush();
            this.fromServer.readUTF();
        }
        catch (IOException e) {
            state.output.fatal("Error communicating to the server.");
        }
        try {
            this.serverSocket.setSoTimeout(100);
        }
        catch (SocketException e) {
            state.output.fatal("Could not set the connection to the server to non-blocking.");
        }
    }

    public void reinitializeContacts(EvolutionState state) {
        this.initializeContacts(state);
    }

    public Population preBreedingExchangePopulation(EvolutionState state) {
        if (state.generation >= this.offset && (this.modulo == 0 || (state.generation - this.offset) % this.modulo == 0)) {
            for (int x = 0; x < this.number_of_destination_islands; ++x) {
                try {
                    if (!this.running[x]) continue;
                    if (this.chatty) {
                        state.output.message("Sending " + this.size + " emigrants to island " + this.outgoingIds[x]);
                    }
                    for (int subpop = 0; subpop < state.population.subpops.length; ++subpop) {
                        this.outWriters[x].writeInt(subpop);
                        this.outWriters[x].writeInt(this.size);
                        this.immigrantsSelectionMethod.prepareToProduce(state, subpop, 0);
                        for (int y = 0; y < this.size; ++y) {
                            int index = this.immigrantsSelectionMethod.produce(subpop, state, 0);
                            state.population.subpops[subpop].individuals[index].writeIndividual(state, this.outWriters[x]);
                            this.outWriters[x].flush();
                        }
                        this.immigrantsSelectionMethod.finishProducing(state, subpop, 0);
                    }
                    continue;
                }
                catch (IOException e) {
                    this.running[x] = false;
                }
            }
        }
        return state.population;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Population postBreedingExchangePopulation(EvolutionState state) {
        if (this.synchronous) {
            state.output.message("Waiting for synchronization....");
            try {
                this.serverSocket.setSoTimeout(0);
            }
            catch (SocketException e) {
                state.output.fatal("Could not set the connection to the server to blocking.");
            }
            try {
                this.toServer.writeUTF(SYNC);
                this.toServer.flush();
                String temp = this.fromServer.readUTF();
                if (temp.equals("bye-bye")) {
                    this.alreadyReadGoodBye = true;
                }
            }
            catch (IOException e) {
                state.output.fatal("Could not communicate to the server. Exiting....");
            }
            try {
                this.serverSocket.setSoTimeout(100);
            }
            catch (SocketException e) {
                state.output.fatal("Could not set the connection to the server to non-blocking.");
            }
        }
        Individual[][] individualArray = this.mailbox.immigrants;
        synchronized (this.mailbox.immigrants) {
            for (int x = 0; x < this.mailbox.immigrants.length; ++x) {
                int i;
                if (this.mailbox.nImmigrants[x] <= 0) continue;
                if (this.chatty) {
                    state.output.message("Immigrating " + this.mailbox.nImmigrants[x] + " individuals from mailbox for subpopulation " + x);
                }
                boolean[] selected = new boolean[state.population.subpops[x].individuals.length];
                int[] indeces = new int[this.mailbox.nImmigrants[x]];
                for (i = 0; i < selected.length; ++i) {
                    selected[i] = false;
                }
                this.indsToDieSelectionMethod.prepareToProduce(state, x, 0);
                for (i = 0; i < this.mailbox.nImmigrants[x]; ++i) {
                    do {
                        indeces[i] = this.indsToDieSelectionMethod.produce(x, state, 0);
                    } while (selected[indeces[i]]);
                    selected[indeces[i]] = true;
                }
                this.indsToDieSelectionMethod.finishProducing(state, x, 0);
                for (int y = 0; y < this.mailbox.nImmigrants[x]; ++y) {
                    state.population.subpops[x].individuals[indeces[y]] = this.mailbox.immigrants[x][y];
                    state.population.subpops[x].individuals[indeces[y]].evaluated = false;
                }
                this.mailbox.nImmigrants[x] = 0;
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return state.population;
        }
    }

    public String runComplete(EvolutionState state) {
        if (this.message != null) {
            return this.message;
        }
        try {
            String ww = this.fromServer.readUTF();
            if (ww != null || this.alreadyReadGoodBye) {
                if (state.quitOnRunComplete) {
                    this.message = "Exit: Another island found the perfect individual.";
                    state.output.message("Another island found the perfect individual. Exiting....");
                    this.toServer.writeUTF(OKAY);
                    this.toServer.flush();
                } else {
                    state.output.message("Another island found the perfect individual.");
                }
            } else {
                this.message = "Exit: Could not communicate with the server.";
                state.output.warning("Could not communicate with the server. Exiting....");
            }
        }
        catch (InterruptedIOException e) {
        }
        catch (IOException e) {
            state.output.warning("Some weird IO exception reported by the system in the IslandExchange::runComplete function.  Is it possible that the server has crashed?");
        }
        return null;
    }

    public void closeContacts(EvolutionState state, int result) {
        if (result == 0) {
            try {
                this.toServer.writeUTF(FOUND);
                this.toServer.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        state.output.message("Shutting down the mailbox");
        this.mailbox.shutDown();
        this.mailboxThread.interrupt();
        try {
            this.mailboxThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        state.output.message("Mailbox shut down");
        for (int x = 0; x < this.number_of_destination_islands; ++x) {
            try {
                if (!this.running[x]) continue;
                this.outSockets[x].close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.iAmServer) {
            state.output.message("Shutting down the server");
            try {
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            state.output.message("Server shut down");
        }
    }

    public void finish(int result) {
    }

    public void startFromCheckpoint() {
    }

    public void startFresh() {
    }

    public int evolve() throws InternalError {
        return 0;
    }
}

