/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.Problem;
import ec.gp.ADFContext;
import ec.gp.ADFStack;
import ec.gp.GPData;
import ec.gp.GPDefaults;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ADFArgument
extends GPNode {
    public static final String P_ADFARGUMENT = "adf-argument";
    public static final String P_ARGUMENT = "arg";
    public static final String P_FUNCTIONNAME = "name";
    public int argument;
    public String name;

    public String name() {
        return this.name;
    }

    public Parameter defaultBase() {
        return GPDefaults.base().push(P_ADFARGUMENT);
    }

    public String toString() {
        return this.name();
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (this.children.length != 0) {
            state.output.error("Incorrect number of children for ADF Argument terminal -- should be 0.  Check the constraints.", base, def);
        }
        this.argument = state.parameters.getInt(base.push(P_ARGUMENT), def.push(P_ARGUMENT), 0);
        if (this.argument < 0) {
            state.output.fatal("Argument terminal must have a positive argument number.", base.push(P_ARGUMENT), def.push(P_ARGUMENT));
        }
        this.name = state.parameters.getString(base.push(P_FUNCTIONNAME), def.push(P_FUNCTIONNAME));
        if (this.name == null || this.name.equals("")) {
            this.name = "ARG" + this.argument;
            state.output.warning("ADFArgument node for argument " + this.argument + " has no function name.  Using the name " + this.name(), base.push(P_FUNCTIONNAME), def.push(P_FUNCTIONNAME));
        }
    }

    public void writeNode(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.argument);
    }

    public void readNode(EvolutionState state, DataInput dataInput) throws IOException {
        this.argument = dataInput.readInt();
    }

    public void eval(EvolutionState state, int thread, GPData input, ADFStack stack, GPIndividual individual, Problem problem) {
        ADFContext c = stack.top(0);
        if (c == null) {
            state.output.fatal("No context with which to evaluate ADFArgument terminal " + this.toStringForError() + ".  This often happens if you evaluate a tree by hand  which is supposed to only be an ADF's associated tree.");
        }
        c.evaluate(state, thread, input, stack, individual, problem, this.argument);
    }
}

