/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.Clique;
import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeBuilder;
import ec.gp.GPType;
import ec.util.Parameter;
import java.util.Enumeration;
import java.util.Hashtable;

public class GPTreeConstraints
implements Clique {
    public static final int SIZE_OF_BYTE = 256;
    public static final String P_NAME = "name";
    public static final String P_SIZE = "size";
    public static final String P_INIT = "init";
    public static final String P_RETURNS = "returns";
    public static final String P_FUNCTIONSET = "fset";
    public String name;
    public byte constraintNumber;
    public GPNodeBuilder init;
    public GPType treetype;
    public GPFunctionSet functionset;

    public String toString() {
        return this.name;
    }

    public final void setup(EvolutionState state, Parameter base) {
        GPTreeConstraints old_constraints;
        this.name = state.parameters.getString(base.push(P_NAME), null);
        if (this.name == null) {
            state.output.fatal("No name was given for this function set.", base.push(P_NAME));
        }
        if ((old_constraints = ((GPInitializer)state.initializer).treeConstraintRepository.put(this.name, this)) != null) {
            state.output.fatal("The GP tree constraint \"" + this.name + "\" has been defined multiple times.", base.push(P_NAME));
        }
        this.init = (GPNodeBuilder)state.parameters.getInstanceForParameter(base.push(P_INIT), null, GPNodeBuilder.class);
        this.init.setup(state, base.push(P_INIT));
        String s = state.parameters.getString(base.push(P_RETURNS), null);
        if (s == null) {
            state.output.fatal("No return type given for the GPTreeConstraints " + this.name, base.push(P_RETURNS));
        }
        this.treetype = GPType.typeFor(s, state);
        s = state.parameters.getString(base.push(P_FUNCTIONSET), null);
        if (s == null) {
            state.output.fatal("No function set given for the GPTreeConstraints " + this.name, base.push(P_RETURNS));
        }
        this.functionset = GPFunctionSet.functionSetFor(s, state);
        state.output.exitIfErrors();
        Hashtable typ = new Hashtable();
        this.checkFunctionSetValidity(state, typ, this.treetype);
        Enumeration e = typ.elements();
        while (e.hasMoreElements()) {
            GPType t = (GPType)e.nextElement();
            GPNode[] i = this.functionset.nodes[t.type];
            if (i.length == 0) {
                state.output.error("In function set " + this.functionset + " for the GPTreeConstraints " + this + ", no nodes at all are given with the return type " + t + " which is required by other functions in the function set or by the tree's return type.  This almost certainly indicates a serious typing error.", base);
                continue;
            }
            i = this.functionset.terminals[t.type];
            if (i.length == 0) {
                state.output.warning("In function set " + this.functionset + " for the GPTreeConstraints " + this + ", no terminals are given with the return type " + t + " which is required by other functions in the function set or by the tree's return type.  Nearly all tree-builders in ECJ require the ability to add a terminal of any type for which there is a nonterminal, and at any time.  Without terminals, your code may not work.  One common indication that a tree-builder has failed due to this problem is if you get the MersenneTwister error 'n must be positive'.", base);
            }
            if ((i = this.functionset.nonterminals[t.type]).length != 0) continue;
            state.output.warning("In function set " + this.functionset + " for the GPTreeConstraints " + this + ", no *nonterminals* are given with the return type " + t + " which is required by other functions in the function set or by the tree's return type.  This may or may not be a problem for you.", base);
        }
        state.output.exitIfErrors();
    }

    private void checkFunctionSetValidity(EvolutionState state, Hashtable done, GPType type) {
        done.put(type, type);
        GPNode[] i = this.functionset.nodes[type.type];
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int x = 0; x < i.length; ++x) {
            for (int y = 0; y < i[x].constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (done.get(i[x].constraints((GPInitializer)initializer).childtypes[y]) != null) continue;
                this.checkFunctionSetValidity(state, done, i[x].constraints((GPInitializer)initializer).childtypes[y]);
            }
        }
    }

    public static GPTreeConstraints constraintsFor(String constraintsName, EvolutionState state) {
        GPTreeConstraints myConstraints = (GPTreeConstraints)((GPInitializer)state.initializer).treeConstraintRepository.get(constraintsName);
        if (myConstraints == null) {
            state.output.error("The GP tree constraint \"" + constraintsName + "\" could not be found.");
        }
        return myConstraints;
    }
}

