/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPFunctionSet;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeSelector;
import ec.gp.GPTree;
import ec.gp.GPType;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;

public class MutateOneNodePipeline
extends GPBreedingPipeline {
    public static final String P_MUTATEONENODE = "mutate-one-node";
    public static final int NUM_SOURCES = 1;
    public GPNodeSelector nodeselect;
    int tree;

    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_MUTATEONENODE);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        MutateOneNodePipeline c = (MutateOneNodePipeline)super.clone();
        c.nodeselect = (GPNodeSelector)this.nodeselect.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter p = base.push("ns").push("0");
        Parameter def = this.defaultBase();
        this.nodeselect = (GPNodeSelector)state.parameters.getInstanceForParameter(p, def.push("ns").push("0"), GPNodeSelector.class);
        this.nodeselect.setup(state, p);
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    private GPNode pickCompatibleNode(GPNode original, GPFunctionSet set, EvolutionState state, GPType returntype, int thread) {
        boolean failed;
        int numValidNodes = 0;
        int type = returntype.type;
        GPInitializer initializer = (GPInitializer)state.initializer;
        int len = original.constraints((GPInitializer)initializer).childtypes.length;
        if (initializer.numAtomicTypes + initializer.numSetTypes == 1) {
            numValidNodes = set.nodesByArity[type][len].length;
        } else {
            for (int x = 0; x < set.nodesByArity[type][len].length; ++x) {
                failed = false;
                for (int y = 0; y < set.nodesByArity[type][len][x].constraints((GPInitializer)initializer).childtypes.length; ++y) {
                    if (set.nodesByArity[type][len][x].constraints((GPInitializer)initializer).childtypes[y].compatibleWith(initializer, original.children[y].constraints((GPInitializer)initializer).returntype)) continue;
                    failed = true;
                    break;
                }
                if (failed) continue;
                ++numValidNodes;
            }
        }
        int nodenum = state.random[thread].nextInt(numValidNodes);
        int prosnode = 0;
        if (numValidNodes == set.nodesByArity[type][len].length) {
            return set.nodesByArity[type][len][nodenum];
        }
        for (int x = 0; x < set.nodesByArity[type][len].length; ++x) {
            failed = false;
            for (int y = 0; y < set.nodesByArity[type][len][x].constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (set.nodesByArity[type][len][x].constraints((GPInitializer)initializer).childtypes[y].compatibleWith(initializer, original.children[y].constraints((GPInitializer)initializer).returntype)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            if (prosnode == nodenum) {
                return set.nodesByArity[type][len][x];
            }
            ++prosnode;
        }
        throw new InternalError();
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int q = start; q < n + start; ++q) {
            GPIndividual j;
            GPIndividual i = (GPIndividual)inds[q];
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("MutateOneNodePipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
            this.nodeselect.reset();
            GPNode p1 = null;
            GPNode p2 = null;
            p1 = this.nodeselect.pickNode(state, subpopulation, thread, i, i.trees[t]);
            GPType type = p1.parentType(initializer);
            p2 = this.pickCompatibleNode(p1, i.trees[t].constraints((GPInitializer)initializer).functionset, state, type, thread).lightClone();
            p2.resetNode(state, thread);
            if (this.sources[0] instanceof BreedingPipeline) {
                j = i;
                p1.replaceWith(p2);
                j.evaluated = false;
            } else {
                j = i.lightClone();
                j.trees = new GPTree[i.trees.length];
                for (int x = 0; x < j.trees.length; ++x) {
                    if (x == t) {
                        j.trees[x] = i.trees[x].lightClone();
                        j.trees[x].owner = j;
                        j.trees[x].child = i.trees[x].child.cloneReplacingAtomic(p2, p1);
                        j.trees[x].child.parent = j.trees[x];
                        j.trees[x].child.argposition = 0;
                        j.evaluated = false;
                        continue;
                    }
                    j.trees[x] = i.trees[x].lightClone();
                    j.trees[x].owner = j;
                    j.trees[x].child = (GPNode)i.trees[x].child.clone();
                    j.trees[x].child.parent = j.trees[x];
                    j.trees[x].child.argposition = 0;
                }
            }
            inds[q] = j;
        }
        return n;
    }
}

