/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.build;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPInitializer;
import ec.gp.build.PTCFunctionSetForm;
import ec.util.Parameter;
import ec.util.RandomChoice;

public class PTCFunctionSet
extends GPFunctionSet
implements PTCFunctionSetForm {
    public float[][] q_ty;
    public float[][] q_ny;
    public static final int CACHE_SIZE = 1024;
    public float[][] p_y;

    public float[] terminalProbabilities(int type) {
        return this.q_ty[type];
    }

    public float[] nonterminalProbabilities(int type) {
        return this.q_ny[type];
    }

    public void setup(EvolutionState state, Parameter base) {
        int x;
        int type;
        super.setup(state, base);
        this.q_ny = new float[this.nonterminals.length][];
        this.q_ty = new float[this.terminals.length][];
        boolean allOnes = true;
        boolean noOnes = true;
        boolean allZeros = true;
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (type = 0; type < this.nonterminals.length; ++type) {
            this.q_ny[type] = new float[this.nonterminals[type].length];
            for (x = 0; x < this.nonterminals[type].length; ++x) {
                this.q_ny[type][x] = this.nonterminals[type][x].constraints((GPInitializer)initializer).probabilityOfSelection;
                if (this.q_ny[type][x] != 0.0f) {
                    allZeros = false;
                }
                if (this.q_ny[type][x] == 1.0f) {
                    noOnes = false;
                    continue;
                }
                allOnes = false;
            }
        }
        if (allZeros) {
            state.output.warning("In this function set, the probabilities of all nonterminal functions have a 0.0 selection probability -- this will cause them all to be selected uniformly.  That could be an error.", base);
        }
        allZeros = false;
        for (type = 0; type < this.terminals.length; ++type) {
            this.q_ty[type] = new float[this.terminals[type].length];
            for (x = 0; x < this.terminals[type].length; ++x) {
                this.q_ty[type][x] = this.terminals[type][x].constraints((GPInitializer)initializer).probabilityOfSelection;
                if (this.q_ty[type][x] != 0.0f) {
                    allZeros = false;
                }
                if (this.q_ty[type][x] == 1.0f) {
                    noOnes = false;
                    continue;
                }
                allOnes = false;
            }
        }
        if (allZeros) {
            state.output.warning("In this function set, the probabilities of all terminal functions have a 0.0 selection probability -- this will cause them all to be selected uniformly.  That could be an error.", base);
        }
        if (!allOnes && !noOnes) {
            state.output.warning("In this function set, there are some functions with a selection probability of 1.0, but not all of them.  That could be an error.", base);
        }
        for (int x2 = 0; x2 < this.q_ty.length; ++x2) {
            if (this.q_ty[x2].length == 0) {
                state.output.warning("Function Set " + this.name + " has no terminals for type number " + x2 + ".  This may cause problems for you.");
            } else {
                RandomChoice.organizeDistribution(this.q_ty[x2], true);
            }
            if (this.q_ny[x2].length == 0) {
                state.output.warning("Function Set " + this.name + " has no nonterminals for type number " + x2 + ".  This may cause problems for you.");
                continue;
            }
            RandomChoice.organizeDistribution(this.q_ny[x2], true);
        }
        this.p_y = new float[1024][];
    }

    public float[] nonterminalSelectionProbabilities(int expectedTreeSize) {
        if (expectedTreeSize < 1024) {
            if (this.p_y[expectedTreeSize - 1] != null) {
                return this.p_y[expectedTreeSize - 1];
            }
            float[] fArray = this.computeNonterminalSelectionProbabilities(expectedTreeSize);
            this.p_y[expectedTreeSize - 1] = fArray;
            return fArray;
        }
        return this.computeNonterminalSelectionProbabilities(expectedTreeSize);
    }

    public float[] computeNonterminalSelectionProbabilities(int expectedTreeSize) {
        float[] p = new float[this.q_ny.length];
        for (int x = 0; x < this.q_ny.length; ++x) {
            double count = 0.0;
            for (int y = 0; y < this.q_ny[x].length; ++y) {
                count += (double)((y == 0 ? this.q_ny[x][y] : this.q_ny[x][y] - this.q_ny[x][y - 1]) * (float)this.nonterminals[x][y].children.length);
            }
            p[x] = (float)((1.0 - 1.0 / (double)expectedTreeSize) / count);
        }
        return p;
    }
}

