/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.build;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeBuilder;
import ec.gp.GPNodeParent;
import ec.gp.GPType;
import ec.gp.build.GPBuildDefaults;
import ec.util.Parameter;
import ec.util.RandomChoice;
import java.util.LinkedList;
import java.util.Stack;

public class RandTree
extends GPNodeBuilder {
    public static final String P_RANDOMBRANCH = "randtree";
    int[] arities;
    boolean aritySetupDone = false;
    LinkedList permutations;

    public Parameter defaultBase() {
        return GPBuildDefaults.base().push(P_RANDOMBRANCH);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!this.canPick()) {
            state.output.fatal("RandTree requires some kind of size distribution set, either with min-size/max-size, or with num-sizes.", base, this.defaultBase());
        }
    }

    private boolean contains(LinkedList initArities, int a) {
        boolean truth = false;
        if (initArities.size() != 0) {
            for (int counter = 0; counter < initArities.size() && !truth; ++counter) {
                ArityObject b = (ArityObject)initArities.get(counter);
                if (b.arity != a) continue;
                truth = true;
            }
        }
        return truth;
    }

    private void remove(LinkedList initArities, int a) {
        boolean removed = false;
        for (int counter = 0; counter < initArities.size() && !removed; ++counter) {
            ArityObject b = (ArityObject)initArities.get(counter);
            if (b.arity != a) continue;
            initArities.remove(counter);
            removed = true;
        }
    }

    public void setupArities(EvolutionState state, GPFunctionSet set) {
        int current;
        int noOfArities = 0;
        int marker = 0;
        int counter = 0;
        LinkedList<ArityObject> initArities = new LinkedList<ArityObject>();
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (current = 0; current < set.nodes[0].length; ++current) {
            int a = set.nodes[0][current].constraints((GPInitializer)initializer).childtypes.length;
            if (this.contains(initArities, a) || a == 0) continue;
            initArities.add(new ArityObject(a));
            ++noOfArities;
        }
        if (initArities.size() == 0) {
            state.output.fatal("Arity count failed... counted 0.");
        }
        this.arities = new int[noOfArities];
        for (current = 0; current < noOfArities; ++current) {
            marker = 0;
            for (counter = 0; counter < initArities.size(); ++counter) {
                ArityObject max = (ArityObject)initArities.get(counter);
                if (max.arity <= marker) continue;
                marker = max.arity;
            }
            this.arities[current] = marker;
            this.remove(initArities, marker);
        }
        this.aritySetupDone = true;
    }

    private long fact(long num) {
        if (num == 0L) {
            return 1L;
        }
        return num * this.fact(num - 1L);
    }

    private int[] select(LinkedList permutations, int size) {
        int counter1;
        int total = 0;
        long denominator = 1L;
        int[] quantity = new int[permutations.size()];
        for (counter1 = 0; counter1 < permutations.size(); ++counter1) {
            int[] current = (int[])permutations.get(counter1);
            long residue = size;
            for (int counter2 = 0; counter2 < current.length; ++counter2) {
                residue -= (long)current[counter2];
                denominator *= this.fact(current[counter2]);
            }
            quantity[counter1] = (int)(this.fact(size - 1) / (denominator * this.fact(residue)));
            total += quantity[counter1];
        }
        double[] prob = new double[quantity.length];
        for (counter1 = 0; counter1 < quantity.length; ++counter1) {
            prob[counter1] = (double)quantity[counter1] / (double)total;
        }
        RandomChoice.organizeDistribution(prob);
        double s = 0.0;
        int selection = RandomChoice.pickFromDistribution(prob, s);
        return (int[])permutations.get(selection);
    }

    public GPNode newRootedTree(EvolutionState state, GPType type, int thread, GPNodeParent parent, GPFunctionSet set, int argposition, int requestedSize) {
        boolean valid = false;
        String word = new String();
        int treeSize = this.pickSize(state, thread);
        if (!this.aritySetupDone) {
            this.setupArities(state, set);
        }
        int[] temp = new int[this.arities.length];
        this.permutations = new LinkedList();
        this.Permute(0, temp, treeSize - 1);
        if (this.permutations.size() == 0) {
            state.output.fatal("Not able to build combination of nodes.");
        }
        int[] scheme = this.select(this.permutations, treeSize);
        word = this.buildDyckWord(treeSize, this.arities, scheme, state, thread);
        int cycle = 0;
        while (!valid) {
            valid = this.checkDyckWord(word);
            if (valid) continue;
            word = word.substring(word.length() - 1, word.length()).concat(word.substring(0, word.length() - 1));
            if (++cycle < treeSize * 2 - 1) continue;
            state.output.fatal("Not able to find valid permutation for generated Dyck word: " + word);
        }
        return this.buildTree(state, thread, parent, argposition, set, word);
    }

    private void Permute(int current, int[] sol, int size) {
        int result;
        int counter = 0;
        if (current == this.arities.length - 1) {
            for (result = 0; result <= size; result += this.arities[current]) {
                ++counter;
            }
            --counter;
            if ((result -= this.arities[current]) < 0) {
                result = 0;
                counter = 0;
            }
            sol[current] = counter;
            this.permutations.add(sol);
        } else {
            while (result <= size) {
                if (result <= size) {
                    sol[current] = counter;
                    this.Permute(current + 1, sol, size - result);
                }
                result += this.arities[current];
                ++counter;
            }
        }
    }

    public String buildDyckWord(int requestedSize, int[] arities, int[] s, EvolutionState state, int thread) {
        int counter;
        int arity = 0;
        int checksum = 0;
        int size = 0;
        int[] scheme = new int[s.length];
        String dyck = new String("");
        String addStr = new String();
        scheme = s;
        for (counter = 0; counter < scheme.length; ++counter) {
            checksum += scheme[counter] * arities[counter];
        }
        size = checksum + 1;
        if (size != requestedSize) {
            state.output.message("A tree of the requested size could not be built.  Using smaller size.");
        }
        int choices = size;
        for (counter = 0; counter < size; ++counter) {
            dyck = dyck.concat("x*");
        }
        for (counter = 0; arity == 0 && counter < scheme.length; ++counter) {
            if (scheme[counter] <= 0) continue;
            arity = arities[counter];
            int n = counter;
            scheme[n] = scheme[n] - 1;
        }
        while (arity != 0) {
            int choice = state.random[thread].nextInt(choices--) + 1;
            int pos = -1;
            counter = 0;
            while (counter != choice) {
                if (dyck.charAt(++pos) != '*') continue;
                ++counter;
            }
            addStr = "";
            while (addStr.length() < arity) {
                addStr = addStr.concat("y");
            }
            dyck = dyck.substring(0, pos).concat(addStr).concat(dyck.substring(pos + 1, dyck.length()));
            arity = 0;
            for (counter = 0; arity == 0 && counter < scheme.length; ++counter) {
                if (scheme[counter] <= 0) continue;
                arity = arities[counter];
                int n = counter;
                scheme[n] = scheme[n] - 1;
            }
        }
        for (counter = 0; counter < dyck.length(); ++counter) {
            if (dyck.charAt(counter) != '*') continue;
            dyck = dyck.substring(0, counter).concat(dyck.substring(counter + 1, dyck.length()));
        }
        return dyck;
    }

    public boolean checkDyckWord(String dyck) {
        boolean underflow = false;
        String stack = new String();
        block4: for (int counter = 0; counter < dyck.length() && !underflow; ++counter) {
            switch (dyck.charAt(counter)) {
                case 'x': {
                    stack = stack.concat("x");
                    continue block4;
                }
                case 'y': {
                    if (stack.length() <= 1) {
                        underflow = true;
                        stack = "";
                        continue block4;
                    }
                    stack = stack.substring(0, stack.length() - 1);
                }
            }
        }
        return stack.length() == 1;
    }

    private GPNode buildTree(EvolutionState state, int thread, GPNodeParent parent, int argposition, GPFunctionSet set, String dyckWord) {
        int counter = 0;
        Stack<GPNode> s = new Stack<GPNode>();
        for (counter = 0; counter < dyckWord.length(); ++counter) {
            int nextChar = counter < dyckWord.length() - 1 ? (int)dyckWord.charAt(counter + 1) : 42;
            if (nextChar == 120 || nextChar == 42) {
                GPNode[] nn = set.terminals[0];
                GPNode n = nn[state.random[thread].nextInt(nn.length)].lightClone();
                n.resetNode(state, thread);
                s.push(n);
                continue;
            }
            if (nextChar != 121) continue;
            int Ycount = 0;
            boolean nextCharY = nextChar == 121;
            ++counter;
            while (counter < dyckWord.length() && nextCharY) {
                if (dyckWord.charAt(counter) == 'y') {
                    ++Ycount;
                }
                if (counter < dyckWord.length() - 1) {
                    nextCharY = dyckWord.charAt(counter + 1) == 'y';
                }
                ++counter;
            }
            GPNode[] nonTerms = set.nodesByArity[0][Ycount];
            GPNode nT = nonTerms[state.random[thread].nextInt(nonTerms.length)].lightClone();
            int childcount = Ycount;
            while (childcount > 0) {
                --childcount;
                if (s.size() == 0) {
                    state.output.fatal("Stack underflow when building tree.");
                }
                GPNode child = (GPNode)s.pop();
                child.parent = nT;
                child.argposition = (byte)childcount;
                nT.children[childcount] = child;
            }
            nT.argposition = 0;
            nT.parent = null;
            s.push(nT);
            if (counter == dyckWord.length()) continue;
            --counter;
        }
        return (GPNode)s.pop();
    }

    private class ArityObject {
        public int arity;

        public ArityObject(int a) {
            this.arity = a;
        }
    }
}

