/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.ge;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Problem;
import ec.coevolve.GroupedProblemForm;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.ge.GEIndividual;
import ec.gp.ge.GESpecies;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class GEProblem
extends Problem
implements SimpleProblemForm,
GroupedProblemForm {
    public static final String P_PROBLEM = "problem";
    public GPProblem problem;

    public void setup(EvolutionState state, Parameter base) {
        this.problem = (GPProblem)state.parameters.getInstanceForParameter(base.push(P_PROBLEM), null, GPProblem.class);
        this.problem.setup(state, base.push(P_PROBLEM));
    }

    public Object clone() {
        GEProblem other = (GEProblem)super.clone();
        other.problem = (GPProblem)this.problem.clone();
        return other;
    }

    public void prepareToEvaluate(EvolutionState state, int threadnum) {
        this.problem.prepareToEvaluate(state, threadnum);
    }

    public void finishEvaluating(EvolutionState state, int threadnum) {
        this.problem.finishEvaluating(state, threadnum);
    }

    public void initializeContacts(EvolutionState state) {
        this.problem.initializeContacts(state);
    }

    public void reinitializeContacts(EvolutionState state) {
        this.problem.reinitializeContacts(state);
    }

    public void closeContacts(EvolutionState state, int result) {
        this.problem.closeContacts(state, result);
    }

    public boolean canEvaluate() {
        return this.problem.canEvaluate();
    }

    public void preprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        if (!(this.problem instanceof GroupedProblemForm)) {
            state.output.fatal("GEProblem's underlying Problem is not a GroupedProblemForm");
        }
        ((GroupedProblemForm)((Object)this.problem)).preprocessPopulation(state, pop, countVictoriesOnly);
    }

    public void postprocessPopulation(EvolutionState state, Population pop, boolean countVictoriesOnly) {
        ((GroupedProblemForm)((Object)this.problem)).preprocessPopulation(state, pop, countVictoriesOnly);
    }

    public void evaluate(EvolutionState state, Individual[] ind, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        int i;
        Individual[] gpi = new GPIndividual[ind.length];
        for (i = 0; i < gpi.length; ++i) {
            GEIndividual indiv = (GEIndividual)ind[i];
            GESpecies species = (GESpecies)ind[i].species;
            gpi[i] = species.map(state, indiv, threadnum);
        }
        ((GroupedProblemForm)((Object)this.problem)).evaluate(state, gpi, updateFitness, countVictoriesOnly, subpops, threadnum);
        for (i = 0; i < gpi.length; ++i) {
            ind[i].fitness = ((GPIndividual)gpi[i]).fitness;
            ind[i].evaluated = ((GPIndividual)gpi[i]).evaluated;
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        GEIndividual indiv;
        GESpecies species;
        GPIndividual gpi;
        if (!(this.problem instanceof SimpleProblemForm)) {
            state.output.fatal("GEProblem's underlying Problem is not a SimpleProblemForm");
        }
        if ((gpi = (species = (GESpecies)ind.species).map(state, indiv = (GEIndividual)ind, threadnum)) == null) {
            KozaFitness fitness = (KozaFitness)ind.fitness;
            fitness.setStandardizedFitness(state, Float.MAX_VALUE);
        } else {
            this.problem.evaluate(state, gpi, subpopulation, threadnum);
            ind.fitness = gpi.fitness;
            ind.evaluated = gpi.evaluated;
        }
    }

    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        GESpecies species = (GESpecies)ind.species;
        GEIndividual indiv = (GEIndividual)ind;
        GPIndividual gpi = species.map(state, indiv, threadnum);
        if (gpi != null) {
            this.problem.describe(state, gpi, subpopulation, threadnum, log);
            ind.fitness = gpi.fitness;
            ind.evaluated = gpi.evaluated;
        }
    }
}

