/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.ge;

import ec.EvolutionState;
import ec.gp.ERC;
import ec.gp.GPFunctionSet;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPSpecies;
import ec.gp.GPTree;
import ec.gp.ge.GEDefaults;
import ec.gp.ge.GEIndividual;
import ec.gp.ge.GrammarFunctionNode;
import ec.gp.ge.GrammarNode;
import ec.gp.ge.GrammarParser;
import ec.gp.ge.GrammarRuleNode;
import ec.util.Parameter;
import ec.vector.ByteVectorIndividual;
import ec.vector.IntegerVectorSpecies;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;

public class GESpecies
extends IntegerVectorSpecies {
    public static final String P_GESPECIES = "species";
    public static final String P_FILE = "file";
    public static final String P_GPSPECIES = "gp-species";
    public static final String P_PARSER = "parser";
    public static final int BIG_TREE_ERROR = -1;
    public GPSpecies gpspecies;
    public HashMap ERCBank;
    public GrammarRuleNode[] grammar;
    public GrammarParser parser_prototype;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter p = base;
        Parameter def = this.defaultBase();
        p = base.push(P_GPSPECIES);
        this.gpspecies = (GPSpecies)state.parameters.getInstanceForParameterEq(p, def.push(P_GPSPECIES), GPSpecies.class);
        this.gpspecies.setup(state, p);
        if (!(this.i_prototype instanceof ByteVectorIndividual)) {
            state.output.fatal("The Individual class for the Species " + this.getClass().getName() + " is must be a subclass of ec.gp.ge.GEIndividual.", base);
        }
        this.ERCBank = new HashMap();
        GPIndividual gpi = (GPIndividual)this.gpspecies.i_prototype;
        GPTree[] trees = gpi.trees;
        int numGrammars = trees.length;
        this.parser_prototype = (GrammarParser)state.parameters.getInstanceForParameterEq(base.push(P_PARSER), def.push(P_PARSER), GrammarParser.class);
        this.grammar = new GrammarRuleNode[numGrammars];
        for (int i = 0; i < numGrammars; ++i) {
            p = base.push(P_FILE);
            File grammarFile = state.parameters.getFile(p, (def = this.defaultBase()).push(P_FILE).push("" + i));
            if (grammarFile == null) {
                state.output.fatal("Error retrieving grammar file(s): " + def.toString() + "." + P_FILE + "." + i + " is undefined.");
            }
            try {
                GPFunctionSet gpfs = trees[i].constraints((GPInitializer)((GPInitializer)state.initializer)).functionset;
                GrammarParser grammarparser = (GrammarParser)this.parser_prototype.clone();
                this.grammar[i] = grammarparser.parseRules(state, new BufferedReader(new FileReader(grammarFile)), gpfs);
                continue;
            }
            catch (FileNotFoundException e) {
                state.output.fatal("Error retrieving grammar file(s): " + def.toString() + "." + P_FILE + "." + i + " does not exist or cannot be opened.");
            }
        }
    }

    public int makeTrees(EvolutionState state, GEIndividual ind, GPTree[] trees, int threadnum) {
        int position = 0;
        for (int i = 0; i < trees.length; ++i) {
            if (position < 0) {
                return -1;
            }
            position = this.makeTree(state, ind, trees[i], position, i, threadnum);
        }
        return position;
    }

    public int makeTree(EvolutionState state, GEIndividual ind, GPTree tree, int position, int treeNum, int threadnum) {
        GPNode root;
        int[] countNumberOfChromosomesUsed = new int[]{position};
        byte[] genome = ind.genome;
        GPFunctionSet gpfs = tree.constraints((GPInitializer)((GPInitializer)state.initializer)).functionset;
        try {
            root = this.makeSubtree(countNumberOfChromosomesUsed, genome, state, gpfs, this.grammar[treeNum], treeNum, threadnum);
        }
        catch (BigTreeException e) {
            return -1;
        }
        if (root == null) {
            state.output.fatal("Invalid tree: tree #" + treeNum);
        }
        root.parent = tree;
        tree.child = root;
        return countNumberOfChromosomesUsed[0];
    }

    GPNode makeSubtree(int[] index, byte[] genome, EvolutionState es, GPFunctionSet gpfs, GrammarRuleNode rule, int treeNum, int threadnum) {
        int i;
        if (index[0] >= genome.length) {
            throw new BigTreeException();
        }
        byte key = genome[index[0]];
        if (rule == null) {
            es.output.fatal("An undefined rule exists within the grammar.");
        }
        if (rule.getNumChoices() > 1) {
            i = (genome[index[0]] - (int)this.minGene(index[0])) % rule.getNumChoices();
            index[0] = index[0] + 1;
        } else {
            i = 0;
        }
        GrammarNode choice = rule.getChoice(i);
        if (choice instanceof GrammarRuleNode) {
            GrammarRuleNode nextrule = (GrammarRuleNode)choice;
            return this.makeSubtree(index, genome, es, gpfs, nextrule, treeNum, threadnum);
        }
        GrammarFunctionNode funcgrammarnode = (GrammarFunctionNode)choice;
        GPNode validNode = funcgrammarnode.getGPNodePrototype();
        int numChildren = validNode.children.length;
        int numChildrenInGrammar = funcgrammarnode.getNumArguments();
        if (numChildren != numChildrenInGrammar) {
            es.output.fatal("GPNode " + validNode.toStringForHumans() + " requires " + numChildren + " children.  " + numChildrenInGrammar + " children found in the grammar.");
        }
        validNode = validNode instanceof ERC ? this.obtainERC(es, key, genome, threadnum, validNode) : validNode.lightClone();
        int childNumber = 0;
        for (int j = 0; j < funcgrammarnode.getNumArguments(); ++j) {
            validNode.children[childNumber] = this.makeSubtree(index, genome, es, gpfs, (GrammarRuleNode)funcgrammarnode.getArgument(j), treeNum, threadnum);
            if (validNode.children[childNumber] == null) {
                return null;
            }
            ++childNumber;
        }
        return validNode;
    }

    public GPNode obtainERC(EvolutionState state, int key, byte[] genome, int threadnum, GPNode node) {
        ArrayList<GPNode> ERCList = (ArrayList<GPNode>)this.ERCBank.get(new Integer(key));
        if (ERCList == null) {
            ERCList = new ArrayList<GPNode>();
            this.ERCBank.put(new Integer(key), ERCList);
        }
        GPNode dummy = null;
        for (int i = 0; i < ERCList.size(); ++i) {
            dummy = (GPNode)ERCList.get(i);
            if (!dummy.nodeEquivalentTo(node)) continue;
            return dummy.lightClone();
        }
        node = node.lightClone();
        node.resetNode(state, threadnum);
        ERCList.add(node);
        return node;
    }

    public Object clone() {
        GESpecies other = (GESpecies)super.clone();
        other.gpspecies = (GPSpecies)this.gpspecies.clone();
        return other;
    }

    public Parameter defaultBase() {
        return GEDefaults.base().push(P_GESPECIES);
    }

    public int consumed(EvolutionState state, GEIndividual ind, int threadnum) {
        GPIndividual newind = ((GPIndividual)this.gpspecies.i_prototype).lightClone();
        return this.makeTrees(state, ind, newind.trees, threadnum);
    }

    public GPIndividual map(EvolutionState state, GEIndividual ind, int threadnum) {
        GPIndividual newind = ((GPIndividual)this.gpspecies.i_prototype).lightClone();
        newind.fitness = ind.fitness;
        newind.evaluated = false;
        newind.species = this.gpspecies;
        if (this.makeTrees(state, ind, newind.trees, threadnum) < 0) {
            return null;
        }
        return newind;
    }

    class BigTreeException
    extends RuntimeException {
        static final long serialVersionUID = 1L;

        BigTreeException() {
        }
    }
}

