/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeBuilder;
import ec.gp.GPNodeParent;
import ec.gp.GPType;
import ec.util.Parameter;

public abstract class KozaBuilder
extends GPNodeBuilder {
    public static final String P_MAXDEPTH = "max-depth";
    public static final String P_MINDEPTH = "min-depth";
    public int maxDepth;
    public int minDepth;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.maxDepth = state.parameters.getInt(base.push(P_MAXDEPTH), def.push(P_MAXDEPTH), 1);
        if (this.maxDepth <= 0) {
            state.output.fatal("The Max Depth for a KozaBuilder must be at least 1.", base.push(P_MAXDEPTH), def.push(P_MAXDEPTH));
        }
        this.minDepth = state.parameters.getInt(base.push(P_MINDEPTH), def.push(P_MINDEPTH), 1);
        if (this.minDepth <= 0) {
            state.output.fatal("The Min Depth for a KozaBuilder must be at least 1.", base.push(P_MINDEPTH), def.push(P_MINDEPTH));
        }
        if (this.maxDepth < this.minDepth) {
            state.output.fatal("Max Depth must be >= Min Depth for a KozaBuilder", base.push(P_MAXDEPTH), def.push(P_MAXDEPTH));
        }
    }

    protected GPNode fullNode(EvolutionState state, int current, int max, GPType type, int thread, GPNodeParent parent, int argposition, GPFunctionSet set) {
        GPNode[] nodesToPick;
        boolean triedTerminals = false;
        int t = type.type;
        GPNode[] terminals = set.terminals[t];
        GPNode[] nonterminals = set.nonterminals[t];
        GPNode[] nodes = set.nodes[t];
        if (nodes.length == 0) {
            this.errorAboutNoNodeWithType(type, state);
        }
        if (current + 1 >= max || this.warnAboutNonterminal(nonterminals.length == 0, type, false, state)) {
            triedTerminals = true;
            if (true && terminals.length != 0) {
                GPNode n = terminals[state.random[thread].nextInt(terminals.length)].lightClone();
                n.resetNode(state, thread);
                n.argposition = (byte)argposition;
                n.parent = parent;
                return n;
            }
        }
        if (triedTerminals) {
            this.warnAboutNoTerminalWithType(type, false, state);
        }
        if ((nodesToPick = set.nonterminals[type.type]) == null || nodesToPick.length == 0) {
            nodesToPick = set.terminals[type.type];
        }
        GPNode n = nodesToPick[state.random[thread].nextInt(nodesToPick.length)].lightClone();
        n.resetNode(state, thread);
        n.argposition = (byte)argposition;
        n.parent = parent;
        GPType[] childtypes = n.constraints((GPInitializer)((GPInitializer)state.initializer)).childtypes;
        for (int x = 0; x < childtypes.length; ++x) {
            n.children[x] = this.fullNode(state, current + 1, max, childtypes[x], thread, n, x, set);
        }
        return n;
    }

    protected GPNode growNode(EvolutionState state, int current, int max, GPType type, int thread, GPNodeParent parent, int argposition, GPFunctionSet set) {
        boolean triedTerminals = false;
        int t = type.type;
        GPNode[] terminals = set.terminals[t];
        GPNode[] nonterminals = set.nonterminals[t];
        GPNode[] nodes = set.nodes[t];
        if (nodes.length == 0) {
            this.errorAboutNoNodeWithType(type, state);
        }
        if (current + 1 >= max) {
            triedTerminals = true;
            if (true && terminals.length != 0) {
                GPNode n = terminals[state.random[thread].nextInt(terminals.length)].lightClone();
                n.resetNode(state, thread);
                n.argposition = (byte)argposition;
                n.parent = parent;
                return n;
            }
        }
        if (triedTerminals) {
            this.warnAboutNoTerminalWithType(type, false, state);
        }
        GPNode n = nodes[state.random[thread].nextInt(nodes.length)].lightClone();
        n.resetNode(state, thread);
        n.argposition = (byte)argposition;
        n.parent = parent;
        GPType[] childtypes = n.constraints((GPInitializer)((GPInitializer)state.initializer)).childtypes;
        for (int x = 0; x < childtypes.length; ++x) {
            n.children[x] = this.growNode(state, current + 1, max, childtypes[x], thread, n, x, set);
        }
        return n;
    }
}

