/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.Fitness;
import ec.gp.koza.GPKozaDefaults;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class KozaFitness
extends Fitness {
    public static final String P_KOZAFITNESS = "fitness";
    protected float standardizedFitness;
    public int hits;

    public Parameter defaultBase() {
        return GPKozaDefaults.base().push(P_KOZAFITNESS);
    }

    public final void setFitness(EvolutionState state, float _f) {
        this.setStandardizedFitness(state, _f);
    }

    public final void setStandardizedFitness(EvolutionState state, float _f) {
        if (_f < 0.0f || _f == Float.POSITIVE_INFINITY || Float.isNaN(_f)) {
            state.output.warning("Bad fitness (may not be < 0, NaN, or infinity): " + _f + ", setting to 0.");
            this.standardizedFitness = 0.0f;
        } else {
            this.standardizedFitness = _f;
        }
    }

    public final float fitness() {
        return 1.0f / (1.0f + this.standardizedFitness);
    }

    public final float rawFitness() {
        return this.standardizedFitness();
    }

    public final float standardizedFitness() {
        return this.standardizedFitness;
    }

    public final float adjustedFitness() {
        return this.fitness();
    }

    public void setup(EvolutionState state, Parameter base) {
    }

    public final boolean isIdealFitness() {
        return this.standardizedFitness == 0.0f;
    }

    public boolean equivalentTo(Fitness _fitness) {
        return _fitness.fitness() == this.fitness();
    }

    public boolean betterThan(Fitness _fitness) {
        return _fitness.fitness() < this.fitness();
    }

    public String fitnessToString() {
        return "Fitness: " + Code.encode(this.standardizedFitness) + Code.encode(this.hits);
    }

    public String fitnessToStringForHumans() {
        return "Fitness: Standardized=" + this.standardizedFitness + " Adjusted=" + this.adjustedFitness() + " Hits=" + this.hits;
    }

    public final void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        DecodeReturn d = Code.checkPreamble("Fitness: ", state, reader);
        Code.decode(d);
        if (d.type != 6) {
            state.output.fatal("Reading Line " + d.lineNumber + ": " + "Bad Fitness.");
        }
        this.standardizedFitness = (float)d.d;
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Reading Line " + d.lineNumber + ": " + "Bad Fitness.");
        }
        this.hits = (int)d.l;
    }

    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.standardizedFitness);
        dataOutput.writeInt(this.hits);
    }

    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        this.standardizedFitness = dataInput.readFloat();
        this.hits = dataInput.readInt();
    }

    public void setToMeanOf(EvolutionState state, Fitness[] fitnesses) {
        double f = 0.0;
        long h = 0L;
        for (int i = 0; i < fitnesses.length; ++i) {
            KozaFitness fit = (KozaFitness)fitnesses[i];
            f += (double)fit.standardizedFitness;
            h += (long)fit.hits;
        }
        this.standardizedFitness = (float)(f /= (double)fitnesses.length);
        this.hits = (int)(h /= (long)fitnesses.length);
    }
}

