/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.gp.GPIndividual;
import ec.gp.GPSpecies;
import ec.gp.koza.KozaFitness;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;

public class KozaShortStatistics
extends Statistics {
    public static final String P_COMPRESS = "gzip";
    public static final String P_FULL = "gather-full";
    public boolean doFull;
    public Individual[] best_of_run;
    public long[] totalNodes;
    public long[] totalDepths;
    public long lastTime;
    public long lastUsage;
    public static final String P_STATISTICS_FILE = "file";
    public int statisticslog = 0;

    public Individual[] getBestSoFar() {
        return this.best_of_run;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        File statisticsFile = state.parameters.getFile(base.push(P_STATISTICS_FILE), null);
        if (statisticsFile != null) {
            try {
                this.statisticslog = state.output.addLog(statisticsFile, !state.parameters.getBoolean(base.push(P_COMPRESS), null, false), state.parameters.getBoolean(base.push(P_COMPRESS), null, false));
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + statisticsFile + ":\n" + i);
            }
        }
        this.doFull = state.parameters.getBoolean(base.push(P_FULL), null, false);
    }

    public void preInitializationStatistics(EvolutionState state) {
        super.preInitializationStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    public void postInitializationStatistics(EvolutionState state) {
        super.postInitializationStatistics(state);
        this.best_of_run = new Individual[state.population.subpops.length];
        state.output.print("0 ", this.statisticslog);
        if (this.doFull) {
            int x;
            this.totalNodes = new long[state.population.subpops.length];
            for (x = 0; x < this.totalNodes.length; ++x) {
                this.totalNodes[x] = 0L;
            }
            this.totalDepths = new long[state.population.subpops.length];
            for (x = 0; x < this.totalDepths.length; ++x) {
                this.totalDepths[x] = 0L;
            }
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
            state.output.print("" + (curU - this.lastUsage) + " ", this.statisticslog);
        }
    }

    public void preBreedingStatistics(EvolutionState state) {
        super.preBreedingStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    public void postBreedingStatistics(EvolutionState state) {
        super.postBreedingStatistics(state);
        state.output.print("" + (state.generation + 1) + " ", this.statisticslog);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
            state.output.print("" + (curU - this.lastUsage) + " ", this.statisticslog);
        }
    }

    public void preEvaluationStatistics(EvolutionState state) {
        super.preEvaluationStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    protected void _postEvaluationStatistics(EvolutionState state) {
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
            state.output.print("" + (curU - this.lastUsage) + " ", this.statisticslog);
        }
        Individual[] best_i = new Individual[state.population.subpops.length];
        for (int x = 0; x < state.population.subpops.length; ++x) {
            if (this.doFull) {
                int tr;
                long totNodesPerGen = 0L;
                long totDepthPerGen = 0L;
                if (!(state.population.subpops[x].species instanceof GPSpecies)) {
                    state.output.fatal("Subpopulation " + x + " is not of the species form GPSpecies." + "  Cannot do timing statistics with KozaShortStatistics.");
                }
                long[] numNodes = new long[((GPIndividual)state.population.subpops[x].species.i_prototype).trees.length];
                long[] numDepth = new long[((GPIndividual)state.population.subpops[x].species.i_prototype).trees.length];
                for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                    GPIndividual i = (GPIndividual)state.population.subpops[x].individuals[y];
                    for (int z = 0; z < i.trees.length; ++z) {
                        int n = z;
                        numNodes[n] = numNodes[n] + (long)i.trees[z].child.numNodes(0);
                        int n2 = z;
                        numDepth[n2] = numDepth[n2] + (long)i.trees[z].child.depth();
                    }
                }
                for (tr = 0; tr < numNodes.length; ++tr) {
                    totNodesPerGen += numNodes[tr];
                }
                int n = x;
                this.totalNodes[n] = this.totalNodes[n] + totNodesPerGen;
                state.output.print("" + (double)totNodesPerGen / (double)state.population.subpops[x].individuals.length + " [", this.statisticslog);
                for (tr = 0; tr < numNodes.length; ++tr) {
                    if (tr > 0) {
                        state.output.print("|", this.statisticslog);
                    }
                    state.output.print("" + (double)numNodes[tr] / (double)state.population.subpops[x].individuals.length, this.statisticslog);
                }
                state.output.print("] ", this.statisticslog);
                state.output.print("" + (double)this.totalNodes[x] / (double)(state.population.subpops[x].individuals.length * (state.generation + 1)) + " ", this.statisticslog);
                for (tr = 0; tr < numDepth.length; ++tr) {
                    totDepthPerGen += numDepth[tr];
                }
                int n3 = x;
                this.totalDepths[n3] = this.totalDepths[n3] + totDepthPerGen;
                state.output.print("" + (double)totDepthPerGen / (double)(state.population.subpops[x].individuals.length * numDepth.length) + " [", this.statisticslog);
                for (tr = 0; tr < numDepth.length; ++tr) {
                    if (tr > 0) {
                        state.output.print("|", this.statisticslog);
                    }
                    state.output.print("" + (double)numDepth[tr] / (double)state.population.subpops[x].individuals.length, this.statisticslog);
                }
                state.output.print("] ", this.statisticslog);
                state.output.print("" + (double)this.totalDepths[x] / (double)(state.population.subpops[x].individuals.length * (state.generation + 1)) + " ", this.statisticslog);
            }
            float meanStandardized = 0.0f;
            float meanAdjusted = 0.0f;
            long hits = 0L;
            if (!(state.population.subpops[x].species.f_prototype instanceof KozaFitness)) {
                state.output.fatal("Subpopulation " + x + " is not of the fitness KozaFitness.  Cannot do timing statistics with KozaStatistics.");
            }
            best_i[x] = null;
            for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                if (best_i[x] == null || state.population.subpops[x].individuals[y].fitness.betterThan(best_i[x].fitness)) {
                    best_i[x] = state.population.subpops[x].individuals[y];
                }
                meanStandardized += ((KozaFitness)state.population.subpops[x].individuals[y].fitness).standardizedFitness();
                meanAdjusted += ((KozaFitness)state.population.subpops[x].individuals[y].fitness).adjustedFitness();
                hits += (long)((KozaFitness)state.population.subpops[x].individuals[y].fitness).hits;
            }
            state.output.print("" + (meanStandardized /= (float)state.population.subpops[x].individuals.length) + " " + (meanAdjusted /= (float)state.population.subpops[x].individuals.length) + " " + (double)hits / (double)state.population.subpops[x].individuals.length + " ", this.statisticslog);
            state.output.print("" + ((KozaFitness)best_i[x].fitness).standardizedFitness() + " " + ((KozaFitness)best_i[x].fitness).adjustedFitness() + " " + ((KozaFitness)best_i[x].fitness).hits + " ", this.statisticslog);
            if (this.best_of_run[x] == null || best_i[x].fitness.betterThan(this.best_of_run[x].fitness)) {
                this.best_of_run[x] = best_i[x];
            }
            state.output.print("" + ((KozaFitness)this.best_of_run[x].fitness).standardizedFitness() + " " + ((KozaFitness)this.best_of_run[x].fitness).adjustedFitness() + " " + ((KozaFitness)this.best_of_run[x].fitness).hits + " ", this.statisticslog);
        }
    }

    public void postEvaluationStatistics(EvolutionState state) {
        super.postEvaluationStatistics(state);
        this._postEvaluationStatistics(state);
        state.output.println("", this.statisticslog);
    }
}

