/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.gp.GPIndividual;
import ec.gp.GPSpecies;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;

public class KozaStatistics
extends Statistics
implements SteadyStateStatisticsForm {
    public static final String P_STATISTICS_FILE = "file";
    public int statisticslog = 0;
    public Individual[] best_of_run = null;
    public static final String P_COMPRESS = "gzip";
    public static final String P_FULL = "gather-full";
    boolean doFull;
    long numInds;
    long lastTime;
    long initializationTime;
    long breedingTime;
    long evaluationTime;
    long nodesInitialized;
    long nodesEvaluated;
    long nodesBred;
    long lastUsage = 0L;
    long initializationUsage = 0L;
    long breedingUsage = 0L;
    long evaluationUsage = 0L;

    public Individual[] getBestSoFar() {
        return this.best_of_run;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        state.output.warnOnce("KozaStatistics is deprecated and will soon be deleted.  Use SimpleStatistics instead.");
        File statisticsFile = state.parameters.getFile(base.push(P_STATISTICS_FILE), null);
        if (statisticsFile != null) {
            try {
                this.statisticslog = state.output.addLog(statisticsFile, !state.parameters.getBoolean(base.push(P_COMPRESS), null, false), state.parameters.getBoolean(base.push(P_COMPRESS), null, false));
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + statisticsFile + ":\n" + i);
            }
        }
        this.doFull = state.parameters.getBoolean(base.push(P_FULL), null, false);
        this.nodesBred = 0L;
        this.nodesEvaluated = 0L;
        this.nodesInitialized = 0L;
        this.evaluationTime = 0L;
        this.breedingTime = 0L;
    }

    public void preInitializationStatistics(EvolutionState state) {
        super.preInitializationStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    public void postInitializationStatistics(EvolutionState state) {
        super.postInitializationStatistics(state);
        this.best_of_run = new Individual[state.population.subpops.length];
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            if (curU > this.lastUsage) {
                this.initializationUsage = curU - this.lastUsage;
            }
            this.initializationTime = System.currentTimeMillis() - this.lastTime;
            for (int x = 0; x < state.population.subpops.length; ++x) {
                if (!(state.population.subpops[x].species instanceof GPSpecies)) {
                    state.output.fatal("Subpopulation " + x + " is not of the species form GPSpecies." + "  Cannot do timing statistics with KozaStatistics.");
                }
                for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                    GPIndividual i = (GPIndividual)state.population.subpops[x].individuals[y];
                    for (int z = 0; z < i.trees.length; ++z) {
                        this.nodesInitialized += (long)i.trees[z].child.numNodes(0);
                    }
                }
            }
        }
    }

    public void preBreedingStatistics(EvolutionState state) {
        super.preBreedingStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    public void postBreedingStatistics(EvolutionState state) {
        super.postBreedingStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            if (curU > this.lastUsage) {
                this.breedingUsage += curU - this.lastUsage;
            }
            this.breedingTime += System.currentTimeMillis() - this.lastTime;
            for (int x = 0; x < state.population.subpops.length; ++x) {
                if (!(state.population.subpops[x].species instanceof GPSpecies)) {
                    state.output.fatal("Subpopulation " + x + " is not of the species form GPSpecies." + "  Cannot do timing statistics with KozaStatistics.");
                }
                for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                    GPIndividual i = (GPIndividual)state.population.subpops[x].individuals[y];
                    for (int z = 0; z < i.trees.length; ++z) {
                        this.nodesBred += (long)i.trees[z].child.numNodes(0);
                    }
                }
            }
        }
    }

    public void preEvaluationStatistics(EvolutionState state) {
        super.preEvaluationStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    public void postEvaluationStatistics(EvolutionState state) {
        int x;
        super.postEvaluationStatistics(state);
        Runtime r = Runtime.getRuntime();
        long curU = r.totalMemory() - r.freeMemory();
        if (curU > this.lastUsage) {
            this.evaluationUsage += curU - this.lastUsage;
        }
        if (this.doFull) {
            this.evaluationTime += System.currentTimeMillis() - this.lastTime;
        }
        state.output.println("\n\n\nGeneration " + state.generation + "\n================", this.statisticslog);
        Individual[] best_i = new Individual[state.population.subpops.length];
        for (x = 0; x < state.population.subpops.length; ++x) {
            state.output.println("\nSubpopulation " + x + "\n----------------", this.statisticslog);
            if (this.doFull) {
                int tr;
                long totNodesPerGen = 0L;
                long totDepthPerGen = 0L;
                if (!(state.population.subpops[x].species instanceof GPSpecies)) {
                    state.output.fatal("Subpopulation " + x + " is not of the species form GPSpecies." + "  Cannot do timing statistics with KozaStatistics.");
                }
                long[] numNodes = new long[((GPIndividual)state.population.subpops[x].species.i_prototype).trees.length];
                long[] numDepth = new long[((GPIndividual)state.population.subpops[x].species.i_prototype).trees.length];
                for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                    GPIndividual i = (GPIndividual)state.population.subpops[x].individuals[y];
                    for (int z = 0; z < i.trees.length; ++z) {
                        this.nodesEvaluated += (long)i.trees[z].child.numNodes(0);
                        int n = z;
                        numNodes[n] = numNodes[n] + (long)i.trees[z].child.numNodes(0);
                        int n2 = z;
                        numDepth[n2] = numDepth[n2] + (long)i.trees[z].child.depth();
                    }
                }
                for (tr = 0; tr < numNodes.length; ++tr) {
                    totNodesPerGen += numNodes[tr];
                }
                state.output.println("Avg Nodes: " + (double)totNodesPerGen / (double)state.population.subpops[x].individuals.length, this.statisticslog);
                state.output.print("Nodes/tree: [", this.statisticslog);
                for (tr = 0; tr < numNodes.length; ++tr) {
                    if (tr > 0) {
                        state.output.print("|", this.statisticslog);
                    }
                    state.output.print("" + (double)numNodes[tr] / (double)state.population.subpops[x].individuals.length, this.statisticslog);
                }
                state.output.println("]", this.statisticslog);
                for (tr = 0; tr < numDepth.length; ++tr) {
                    totDepthPerGen += numDepth[tr];
                }
                state.output.println("Avg Depth: " + (double)totDepthPerGen / (double)(state.population.subpops[x].individuals.length * numDepth.length), this.statisticslog);
                state.output.print("Depth/tree: [", this.statisticslog);
                for (tr = 0; tr < numDepth.length; ++tr) {
                    if (tr > 0) {
                        state.output.print("|", this.statisticslog);
                    }
                    state.output.print("" + (double)numDepth[tr] / (double)state.population.subpops[x].individuals.length, this.statisticslog);
                }
                state.output.println("]", this.statisticslog);
            }
            float meanStandardized = 0.0f;
            float meanAdjusted = 0.0f;
            long hits = 0L;
            if (!(state.population.subpops[x].species.f_prototype instanceof KozaFitness)) {
                state.output.fatal("Subpopulation " + x + " is not of the fitness KozaFitness.  Cannot do timing statistics with KozaStatistics.");
            }
            best_i[x] = state.population.subpops[x].individuals[0];
            for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                if (state.population.subpops[x].individuals[y].fitness.betterThan(best_i[x].fitness)) {
                    best_i[x] = state.population.subpops[x].individuals[y];
                }
                meanStandardized += ((KozaFitness)state.population.subpops[x].individuals[y].fitness).standardizedFitness();
                meanAdjusted += ((KozaFitness)state.population.subpops[x].individuals[y].fitness).adjustedFitness();
                hits += (long)((KozaFitness)state.population.subpops[x].individuals[y].fitness).hits;
            }
            state.output.print("Mean fitness raw: " + (meanStandardized /= (float)state.population.subpops[x].individuals.length) + " adjusted: " + (meanAdjusted /= (float)state.population.subpops[x].individuals.length) + " hits: " + (double)hits / (double)state.population.subpops[x].individuals.length, this.statisticslog);
            state.output.println("", this.statisticslog);
            this.numInds += (long)state.population.subpops[x].individuals.length;
        }
        for (x = 0; x < state.population.subpops.length; ++x) {
            if (this.best_of_run[x] == null || best_i[x].fitness.betterThan(this.best_of_run[x].fitness)) {
                this.best_of_run[x] = (Individual)best_i[x].clone();
            }
            state.output.println("\nBest Individual of Generation:", this.statisticslog);
            best_i[x].printIndividualForHumans(state, this.statisticslog);
            state.output.message("Subpop " + x + " best fitness of generation: " + best_i[x].fitness.fitnessToStringForHumans());
        }
    }

    public void finalStatistics(EvolutionState state, int result) {
        super.finalStatistics(state, result);
        state.output.println("\n\n\nFinal Statistics\n================", this.statisticslog);
        state.output.println("Total Individuals Evaluated: " + this.numInds, this.statisticslog);
        state.output.println("\nBest Individual of Run:", this.statisticslog);
        for (int x = 0; x < state.population.subpops.length; ++x) {
            this.best_of_run[x].printIndividualForHumans(state, this.statisticslog);
            state.output.message("Subpop " + x + " best fitness of run: " + this.best_of_run[x].fitness.fitnessToStringForHumans());
            ((SimpleProblemForm)state.evaluator.p_problem.clone()).describe(state, this.best_of_run[x], x, 0, this.statisticslog);
        }
        if (this.doFull) {
            state.output.println("\n\n\nTimings\n=======", this.statisticslog);
            state.output.println("Initialization: " + (float)this.initializationTime / 1000.0f + " secs total, " + this.nodesInitialized + " nodes, " + (float)this.nodesInitialized / ((float)this.initializationTime / 1000.0f) + " nodes/sec", this.statisticslog);
            state.output.println("Evaluating: " + (float)this.evaluationTime / 1000.0f + " secs total, " + this.nodesEvaluated + " nodes, " + (float)this.nodesEvaluated / ((float)this.evaluationTime / 1000.0f) + " nodes/sec", this.statisticslog);
            state.output.println("Breeding: " + (float)this.breedingTime / 1000.0f + " secs total, " + this.nodesBred + " nodes, " + (float)this.nodesBred / ((float)this.breedingTime / 1000.0f) + " nodes/sec", this.statisticslog);
            state.output.println("\n\n\nMemory Usage\n==============", this.statisticslog);
            state.output.println("Initialization: " + (float)this.initializationUsage / 1024.0f + " KB total, " + this.nodesInitialized + " nodes, " + (float)this.nodesInitialized / ((float)this.initializationUsage / 1024.0f) + " nodes/KB", this.statisticslog);
            state.output.println("Evaluating: " + (float)this.evaluationUsage / 1024.0f + " KB total, " + this.nodesEvaluated + " nodes, " + (float)this.nodesEvaluated / ((float)this.evaluationUsage / 1024.0f) + " nodes/KB", this.statisticslog);
            state.output.println("Breeding: " + (float)this.breedingUsage / 1024.0f + " KB total, " + this.nodesBred + " nodes, " + (float)this.nodesBred / ((float)this.breedingUsage / 1024.0f) + " nodes/KB", this.statisticslog);
        }
    }
}

