/*
 * Decompiled with CFR 0.152.
 */
package ec.rule;

import ec.EvolutionState;
import ec.Prototype;
import ec.rule.Rule;
import ec.rule.RuleDefaults;
import ec.rule.RuleInitializer;
import ec.rule.RuleSetConstraints;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Arrays;

public class RuleSet
implements Prototype {
    public static final String N_RULES = "Num: ";
    public static final String P_RULESET = "ruleset";
    public static final String P_CONSTRAINTS = "constraints";
    public byte constraints;
    public Rule[] rules = new Rule[0];
    public int numRules = 0;

    public final RuleSetConstraints constraints(RuleInitializer initializer) {
        return initializer.ruleSetConstraints[this.constraints];
    }

    public Object clone() {
        try {
            RuleSet newRuleSet = (RuleSet)super.clone();
            newRuleSet.rules = this.rules != null ? (Rule[])this.rules.clone() : null;
            for (int x = 0; x < this.numRules; ++x) {
                newRuleSet.rules[x] = (Rule)this.rules[x].clone();
            }
            return newRuleSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int numRules() {
        return this.numRules;
    }

    public void reset(EvolutionState state, int thread) {
        RuleInitializer initializer = (RuleInitializer)state.initializer;
        this.numRules = this.constraints(initializer).numRulesForReset(this, state, thread);
        this.rules = new Rule[this.numRules];
        for (int i = 0; i < this.rules.length; ++i) {
            this.rules[i] = (Rule)this.constraints((RuleInitializer)initializer).rulePrototype.clone();
            this.rules[i].reset(state, thread);
        }
    }

    public void mutate(EvolutionState state, int thread) {
        RuleInitializer initializer = (RuleInitializer)state.initializer;
        for (int i = 0; i < this.numRules; ++i) {
            this.rules[i].mutate(state, thread);
        }
        while (state.random[thread].nextBoolean(this.constraints((RuleInitializer)initializer).p_del) && this.numRules > this.constraints((RuleInitializer)initializer).minSize) {
            this.removeRandomRule(state, thread);
        }
        while (state.random[thread].nextBoolean(this.constraints((RuleInitializer)initializer).p_add) && this.numRules < this.constraints((RuleInitializer)initializer).maxSize) {
            this.addRandomRule(state, thread);
        }
        if (state.random[thread].nextBoolean(this.constraints((RuleInitializer)initializer).p_randorder)) {
            this.randomizeRulesOrder(state, thread);
        }
    }

    public void preprocessRules(EvolutionState state, int thread) {
    }

    public void postprocessRules(EvolutionState state, int thread) {
    }

    public void randomizeRulesOrder(EvolutionState state, int thread) {
        for (int i = this.numRules - 1; i > 0; --i) {
            int j = state.random[thread].nextInt(i + 1);
            Rule temp = this.rules[i];
            this.rules[i] = this.rules[j];
            this.rules[j] = temp;
        }
    }

    public void addRandomRule(EvolutionState state, int thread) {
        Rule newRule = (Rule)this.constraints((RuleInitializer)((RuleInitializer)state.initializer)).rulePrototype.clone();
        newRule.reset(state, thread);
        this.addRule(newRule);
    }

    public void addRule(Rule rule) {
        if (this.rules == null && this.numRules == 0 || this.numRules == this.rules.length) {
            Rule[] tempRules = this.rules == null ? new Rule[2] : new Rule[(this.rules.length + 1) * 2];
            if (this.rules != null) {
                System.arraycopy(this.rules, 0, tempRules, 0, this.rules.length);
            }
            this.rules = tempRules;
        }
        this.rules[this.numRules++] = rule;
    }

    public Rule removeRule(int index) {
        if (index >= this.numRules || index < 0) {
            return null;
        }
        Rule myrule = this.rules[index];
        System.arraycopy(this.rules, index + 1, this.rules, index, this.numRules - index + 1);
        --this.numRules;
        return myrule;
    }

    public Rule removeRandomRule(EvolutionState state, int thread) {
        if (this.numRules <= 0) {
            return null;
        }
        return this.removeRule(state.random[thread].nextInt(this.numRules));
    }

    public void join(RuleSet other) {
        if (this.rules.length <= this.numRules + other.numRules) {
            Rule[] tempRules = new Rule[this.rules.length + other.rules.length];
            System.arraycopy(this.rules, 0, tempRules, 0, this.numRules);
            this.rules = tempRules;
        }
        System.arraycopy(other.rules, 0, this.rules, this.numRules, other.numRules);
        for (int x = this.numRules; x < this.numRules + other.numRules; ++x) {
            this.rules[x] = (Rule)this.rules[x].clone();
        }
        this.numRules += other.numRules;
    }

    public void copyNoClone(RuleSet other) {
        if (this.rules.length <= other.numRules) {
            this.rules = new Rule[other.numRules];
        }
        System.arraycopy(other.rules, 0, this.rules, 0, other.numRules);
        this.numRules = other.numRules;
    }

    public RuleSet[] split(int[] points, RuleSet[] sets) {
        int i;
        for (i = 0; i < (points.length > 0 ? points[0] : this.rules.length); ++i) {
            sets[0].addRule((Rule)this.rules[i].clone());
        }
        if (points.length > 0) {
            for (int p = 1; p < points.length; ++p) {
                for (int i2 = points[p - 1]; i2 < points[p]; ++i2) {
                    sets[p].addRule((Rule)this.rules[i2].clone());
                }
            }
            for (i = points[points.length - 1]; i < this.rules.length; ++i) {
                sets[points.length].addRule((Rule)this.rules[i].clone());
            }
        }
        return sets;
    }

    public RuleSet[] split(EvolutionState state, int thread, RuleSet[] sets) {
        for (int i = 0; i < this.numRules; ++i) {
            sets[state.random[thread].nextInt(sets.length)].addRule((Rule)this.rules[i].clone());
        }
        return sets;
    }

    public RuleSet[] splitIntoTwo(EvolutionState state, int thread, RuleSet[] sets, float prob) {
        for (int i = 0; i < this.numRules; ++i) {
            if (state.random[thread].nextBoolean(prob)) {
                sets[0].addRule((Rule)this.rules[i].clone());
                continue;
            }
            sets[1].addRule((Rule)this.rules[i].clone());
        }
        return sets;
    }

    public void printRuleSetForHumans(EvolutionState state, int log) {
        this.printRuleSetForHumans(state, log, 0);
    }

    public void printRuleSetForHumans(EvolutionState state, int log, int verbosity) {
        state.output.println("Ruleset contains " + this.numRules + " rules", log);
        for (int i = 0; i < this.numRules; ++i) {
            state.output.println("Rule " + i + ":", log);
            this.rules[i].printRuleForHumans(state, log);
        }
    }

    public void printRuleSet(EvolutionState state, int log) {
        this.printRuleSet(state, log, 0);
    }

    public void printRuleSet(EvolutionState state, int log, int verbosity) {
        state.output.println(N_RULES + Code.encode(this.numRules), log);
        for (int i = 0; i < this.numRules; ++i) {
            this.rules[i].printRule(state, log);
        }
    }

    public void printRuleSet(EvolutionState state, PrintWriter writer) {
        writer.println(N_RULES + Code.encode(this.numRules));
        for (int i = 0; i < this.numRules; ++i) {
            this.rules[i].printRule(state, writer);
        }
    }

    public void readRuleSet(EvolutionState state, LineNumberReader reader) throws IOException {
        this.numRules = Code.readIntegerWithPreamble(N_RULES, state, reader);
        this.rules = new Rule[this.numRules];
        for (int x = 0; x < this.numRules; ++x) {
            this.rules[x] = (Rule)this.constraints((RuleInitializer)((RuleInitializer)state.initializer)).rulePrototype.clone();
            this.rules[x].readRule(state, reader);
        }
    }

    public void writeRuleSet(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.numRules);
        for (int x = 0; x < this.numRules; ++x) {
            this.rules[x].writeRule(state, dataOutput);
        }
    }

    public void readRuleSet(EvolutionState state, DataInput dataInput) throws IOException {
        int ruleCount = dataInput.readInt();
        if (this.rules == null || this.rules.length != ruleCount) {
            this.rules = new Rule[ruleCount];
        }
        for (int x = 0; x < ruleCount; ++x) {
            this.rules[x] = (Rule)this.constraints((RuleInitializer)((RuleInitializer)state.initializer)).rulePrototype.clone();
            this.rules[x].readRule(state, dataInput);
        }
    }

    public Parameter defaultBase() {
        return RuleDefaults.base().push(P_RULESET);
    }

    public void setup(EvolutionState state, Parameter base) {
        String constraintname = state.parameters.getString(base.push(P_CONSTRAINTS), this.defaultBase().push(P_CONSTRAINTS));
        if (constraintname == null) {
            state.output.fatal("No RuleSetConstraints name given", base.push(P_CONSTRAINTS), this.defaultBase().push(P_CONSTRAINTS));
        }
        this.constraints = RuleSetConstraints.constraintsFor((String)constraintname, (EvolutionState)state).constraintNumber;
        state.output.exitIfErrors();
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (int x = 0; x < this.rules.length; ++x) {
            if (this.rules[x] == null) continue;
            hash += this.rules[x].hashCode();
        }
        return hash;
    }

    public boolean equals(Object _other) {
        if (!this.getClass().equals(_other.getClass())) {
            return false;
        }
        RuleSet other = (RuleSet)_other;
        if (this.numRules != other.numRules) {
            return false;
        }
        if (this.numRules == 0 && other.numRules == 0) {
            return true;
        }
        Object[] srules = (Rule[])this.rules.clone();
        Object[] orules = (Rule[])other.rules.clone();
        Arrays.sort(srules);
        Arrays.sort(orules);
        for (int x = 0; x < this.numRules; ++x) {
            if (((Rule)srules[x]).equals(orules[x])) continue;
            return false;
        }
        return true;
    }
}

