/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;

public class TournamentSelection
extends SelectionMethod
implements SteadyStateBSourceForm {
    public static final String P_TOURNAMENT = "tournament";
    public static final String P_PICKWORST = "pick-worst";
    public static final String P_SIZE = "size";
    public static final int DEFAULT_SIZE = 7;
    int size;
    public double probabilityOfPickingSizePlusOne;
    public boolean pickWorst;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_TOURNAMENT);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        double val = state.parameters.getDouble(base.push(P_SIZE), def.push(P_SIZE), 1.0);
        if (val < 1.0) {
            state.output.fatal("Tournament size must be >= 1.", base.push(P_SIZE), def.push(P_SIZE));
        } else if (val == (double)((int)val)) {
            this.size = (int)val;
            this.probabilityOfPickingSizePlusOne = 0.0;
        } else {
            this.size = (int)Math.floor(val);
            this.probabilityOfPickingSizePlusOne = val - (double)this.size;
        }
        this.pickWorst = state.parameters.getBoolean(base.push(P_PICKWORST), def.push(P_PICKWORST), false);
    }

    public int getTournamentSizeToUse(MersenneTwisterFast random) {
        double p = this.probabilityOfPickingSizePlusOne;
        if (p == 0.0) {
            return this.size;
        }
        return this.size + (random.nextBoolean(p) ? 1 : 0);
    }

    public int getRandomIndividual(int number, int subpopulation, EvolutionState state, int thread) {
        Individual[] oldinds = state.population.subpops[subpopulation].individuals;
        return state.random[thread].nextInt(oldinds.length);
    }

    public boolean betterThan(Individual first, Individual second, int subpopulation, EvolutionState state, int thread) {
        return first.fitness.betterThan(second.fitness);
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        Individual[] oldinds = state.population.subpops[subpopulation].individuals;
        int best = this.getRandomIndividual(0, subpopulation, state, thread);
        int s = this.getTournamentSizeToUse(state.random[thread]);
        if (this.pickWorst) {
            for (int x = 1; x < s; ++x) {
                int j = this.getRandomIndividual(x, subpopulation, state, thread);
                if (this.betterThan(oldinds[j], oldinds[best], subpopulation, state, thread)) continue;
                best = j;
            }
        } else {
            for (int x = 1; x < s; ++x) {
                int j = this.getRandomIndividual(x, subpopulation, state, thread);
                if (!this.betterThan(oldinds[j], oldinds[best], subpopulation, state, thread)) continue;
                best = j;
            }
        }
        return best;
    }

    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState state) {
    }
}

