/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.Breeder;
import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.simple.SimpleBreederThread;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparatorL;

public class SimpleBreeder
extends Breeder {
    public static final String P_ELITE = "elite";
    public static final String P_REEVALUATE_ELITES = "reevalate-elites";
    public int[] elite;
    public boolean[] reevaluateElites;

    public void setup(EvolutionState state, Parameter base) {
        Parameter p = new Parameter("pop").push("subpops");
        int size = state.parameters.getInt(p, null, 1);
        this.elite = new int[size];
        this.reevaluateElites = new boolean[size];
        for (int x = 0; x < size; ++x) {
            this.elite[x] = state.parameters.getIntWithDefault(base.push(P_ELITE).push("" + x), null, 0);
            if (this.elite[x] < 0) {
                state.output.error("The number of elites for subpopulation " + x + " must be >= 0", base.push(P_ELITE).push("" + x));
            }
            this.reevaluateElites[x] = state.parameters.getBoolean(base.push(P_REEVALUATE_ELITES).push("" + x), null, false);
        }
        state.output.exitIfErrors();
    }

    public int computeSubpopulationLength(Population newpop, int subpopulation) {
        return newpop.subpops[subpopulation].individuals.length - this.elite[subpopulation];
    }

    public Population breedPopulation(EvolutionState state) {
        int[][] numinds = new int[state.breedthreads][state.population.subpops.length];
        int[][] from = new int[state.breedthreads][state.population.subpops.length];
        Population newpop = (Population)state.population.emptyClone();
        this.loadElites(state, newpop);
        for (int y = 0; y < state.breedthreads; ++y) {
            for (int x = 0; x < state.population.subpops.length; ++x) {
                int length = this.computeSubpopulationLength(newpop, x);
                int firstBreedChunkSizes = length / state.breedthreads;
                int lastBreedChunkSize = firstBreedChunkSizes + length - firstBreedChunkSizes * state.breedthreads;
                numinds[y][x] = y < state.breedthreads - 1 ? firstBreedChunkSizes : lastBreedChunkSize;
                from[y][x] = firstBreedChunkSizes * y;
            }
        }
        if (state.breedthreads == 1) {
            this.breedPopChunk(newpop, state, numinds[0], from[0], 0);
        } else {
            int y;
            Thread[] t = new Thread[state.breedthreads];
            for (y = 0; y < state.breedthreads; ++y) {
                SimpleBreederThread r = new SimpleBreederThread();
                r.threadnum = y;
                r.newpop = newpop;
                r.numinds = numinds[y];
                r.from = from[y];
                r.me = this;
                r.state = state;
                t[y] = new Thread(r);
                t[y].start();
            }
            for (y = 0; y < state.breedthreads; ++y) {
                try {
                    t[y].join();
                    continue;
                }
                catch (InterruptedException e) {
                    state.output.fatal("Whoa! The main breeding thread got interrupted!  Dying...");
                }
            }
        }
        return newpop;
    }

    protected void breedPopChunk(Population newpop, EvolutionState state, int[] numinds, int[] from, int threadnum) {
        for (int subpop = 0; subpop < newpop.subpops.length; ++subpop) {
            int x;
            BreedingPipeline bp = (BreedingPipeline)newpop.subpops[subpop].species.pipe_prototype.clone();
            if (!bp.produces(state, newpop, subpop, threadnum)) {
                state.output.fatal("The Breeding Pipeline of subpopulation " + subpop + " does not produce individuals of the expected species " + newpop.subpops[subpop].species.getClass().getName() + " or fitness " + newpop.subpops[subpop].species.f_prototype);
            }
            bp.prepareToProduce(state, subpop, threadnum);
            int upperbound = from[subpop] + numinds[subpop];
            for (x = from[subpop]; x < upperbound; x += bp.produce(1, upperbound - x, x, subpop, newpop.subpops[subpop].individuals, state, threadnum)) {
            }
            if (x > upperbound) {
                state.output.fatal("Whoa!  A breeding pipeline overwrote the space of another pipeline in subpopulation " + subpop + ".  You need to check your breeding pipeline code (in produce() ).");
            }
            bp.finishProducing(state, subpop, threadnum);
        }
    }

    protected void unmarkElitesEvaluated(Population newpop) {
        for (int sub = 0; sub < newpop.subpops.length; ++sub) {
            for (int e = 0; e < this.elite[sub]; ++e) {
                int len = newpop.subpops[sub].individuals.length;
                if (!this.reevaluateElites[sub]) continue;
                newpop.subpops[sub].individuals[len - this.elite[sub]].evaluated = false;
            }
        }
    }

    protected void loadElites(EvolutionState state, Population newpop) {
        for (int x = 0; x < state.population.subpops.length; ++x) {
            if (this.elite[x] <= state.population.subpops[x].individuals.length) continue;
            state.output.error("The number of elites for subpopulation " + x + " exceeds the actual size of the subpopulation", new Parameter("breed").push(P_ELITE).push("" + x));
        }
        state.output.exitIfErrors();
        for (int sub = 0; sub < state.population.subpops.length; ++sub) {
            if (this.elite[sub] == 1) {
                int best = 0;
                Individual[] oldinds = state.population.subpops[sub].individuals;
                for (int x = 1; x < oldinds.length; ++x) {
                    if (!oldinds[x].fitness.betterThan(oldinds[best].fitness)) continue;
                    best = x;
                }
                Individual[] inds = newpop.subpops[sub].individuals;
                inds[inds.length - 1] = (Individual)oldinds[best].clone();
                continue;
            }
            if (this.elite[sub] <= 0) continue;
            int[] orderedPop = new int[state.population.subpops[sub].individuals.length];
            for (int x = 0; x < state.population.subpops[sub].individuals.length; ++x) {
                orderedPop[x] = x;
            }
            QuickSort.qsort(orderedPop, (SortComparatorL)new EliteComparator(state.population.subpops[sub].individuals));
            Individual[] inds = newpop.subpops[sub].individuals;
            Individual[] oldinds = state.population.subpops[sub].individuals;
            for (int x = inds.length - this.elite[sub]; x < inds.length; ++x) {
                inds[x] = (Individual)oldinds[orderedPop[x]].clone();
            }
        }
        this.unmarkElitesEvaluated(newpop);
    }

    class EliteComparator
    implements SortComparatorL {
        Individual[] inds;

        public EliteComparator(Individual[] inds) {
            this.inds = inds;
        }

        public boolean lt(long a, long b) {
            return this.inds[(int)b].fitness.betterThan(this.inds[(int)a].fitness);
        }

        public boolean gt(long a, long b) {
            return this.inds[(int)a].fitness.betterThan(this.inds[(int)b].fitness);
        }
    }
}

