/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.Evaluator;
import ec.EvolutionState;
import ec.Problem;
import ec.simple.SimpleEvaluatorThread;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class SimpleEvaluator
extends Evaluator {
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.p_problem instanceof SimpleProblemForm)) {
            state.output.fatal("" + this.getClass() + " used, but the Problem is not of SimpleProblemForm", base.push("problem"));
        }
    }

    public void evaluatePopulation(EvolutionState state) {
        int[][] numinds = new int[state.evalthreads][state.population.subpops.length];
        int[][] from = new int[state.evalthreads][state.population.subpops.length];
        for (int y = 0; y < state.evalthreads; ++y) {
            for (int x = 0; x < state.population.subpops.length; ++x) {
                numinds[y][x] = y < state.evalthreads - 1 ? state.population.subpops[x].individuals.length / state.evalthreads : state.population.subpops[x].individuals.length / state.evalthreads + (state.population.subpops[x].individuals.length - state.population.subpops[x].individuals.length / state.evalthreads * state.evalthreads);
                from[y][x] = state.population.subpops[x].individuals.length / state.evalthreads * y;
            }
        }
        if (state.evalthreads == 1) {
            this.evalPopChunk(state, numinds[0], from[0], 0, (SimpleProblemForm)this.p_problem.clone());
        } else {
            int y;
            Thread[] t = new Thread[state.evalthreads];
            for (y = 0; y < state.evalthreads; ++y) {
                SimpleEvaluatorThread r = new SimpleEvaluatorThread();
                r.threadnum = y;
                r.numinds = numinds[y];
                r.from = from[y];
                r.me = this;
                r.state = state;
                r.p = (SimpleProblemForm)this.p_problem.clone();
                t[y] = new Thread(r);
                t[y].start();
            }
            for (y = 0; y < state.evalthreads; ++y) {
                try {
                    t[y].join();
                    continue;
                }
                catch (InterruptedException e) {
                    state.output.fatal("Whoa! The main evaluation thread got interrupted!  Dying...");
                }
            }
        }
    }

    protected void evalPopChunk(EvolutionState state, int[] numinds, int[] from, int threadnum, SimpleProblemForm p) {
        ((Problem)((Object)p)).prepareToEvaluate(state, threadnum);
        for (int pop = 0; pop < state.population.subpops.length; ++pop) {
            int upperbound = from[pop] + numinds[pop];
            for (int x = from[pop]; x < upperbound; ++x) {
                p.evaluate(state, state.population.subpops[pop].individuals[x], pop, threadnum);
            }
        }
        ((Problem)((Object)p)).finishEvaluating(state, threadnum);
    }

    public boolean runComplete(EvolutionState state) {
        for (int x = 0; x < state.population.subpops.length; ++x) {
            for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                if (!state.population.subpops[x].individuals[y].fitness.isIdealFitness()) continue;
                return true;
            }
        }
        return false;
    }
}

