/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Fitness;
import ec.simple.SimpleDefaults;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class SimpleFitness
extends Fitness {
    protected float fitness;
    protected boolean isIdeal;

    public Parameter defaultBase() {
        return SimpleDefaults.base().push("fitness");
    }

    public void setFitness(EvolutionState state, float _f) {
        this.setFitness(state, _f, false);
    }

    public void setFitness(EvolutionState state, float _f, boolean _isIdeal) {
        if (_f == Float.POSITIVE_INFINITY || _f == Float.NEGATIVE_INFINITY || Float.isNaN(_f)) {
            state.output.warning("Bad fitness: " + _f + ", setting to 0.");
            this.fitness = 0.0f;
        } else {
            this.fitness = _f;
        }
        this.isIdeal = _isIdeal;
    }

    public float fitness() {
        return this.fitness;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
    }

    public boolean isIdealFitness() {
        return this.isIdeal;
    }

    public boolean equivalentTo(Fitness _fitness) {
        return _fitness.fitness() == this.fitness();
    }

    public boolean betterThan(Fitness _fitness) {
        return _fitness.fitness() < this.fitness();
    }

    public String fitnessToString() {
        return "Fitness: " + Code.encode(this.fitness());
    }

    public String fitnessToStringForHumans() {
        return "Fitness: " + this.fitness();
    }

    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        this.setFitness(state, Code.readFloatWithPreamble("Fitness: ", state, reader));
    }

    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.fitness);
        dataOutput.writeBoolean(this.isIdeal);
    }

    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        this.fitness = dataInput.readFloat();
        this.isIdeal = dataInput.readBoolean();
    }

    public void setToMeanOf(EvolutionState state, Fitness[] fitnesses) {
        double f = 0.0;
        boolean ideal = true;
        for (int i = 0; i < fitnesses.length; ++i) {
            SimpleFitness fit = (SimpleFitness)fitnesses[i];
            f += (double)fit.fitness;
            ideal = ideal && fit.isIdeal;
        }
        this.fitness = (float)(f /= (double)fitnesses.length);
        this.isIdeal = ideal;
    }
}

