/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.simple.SimpleProblemForm;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;

public class SimpleStatistics
extends Statistics
implements SteadyStateStatisticsForm {
    public static final String P_STATISTICS_FILE = "file";
    public static final String P_COMPRESS = "gzip";
    public int statisticslog = 0;
    public Individual[] best_of_run = null;
    public boolean compress;

    public Individual[] getBestSoFar() {
        return this.best_of_run;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.compress = state.parameters.getBoolean(base.push(P_COMPRESS), null, false);
        File statisticsFile = state.parameters.getFile(base.push(P_STATISTICS_FILE), null);
        if (statisticsFile != null) {
            try {
                this.statisticslog = state.output.addLog(statisticsFile, !this.compress, this.compress);
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + statisticsFile + ":\n" + i);
            }
        }
    }

    public void postInitializationStatistics(EvolutionState state) {
        super.postInitializationStatistics(state);
        this.best_of_run = new Individual[state.population.subpops.length];
    }

    public void postEvaluationStatistics(EvolutionState state) {
        int x;
        super.postEvaluationStatistics(state);
        Individual[] best_i = new Individual[state.population.subpops.length];
        for (x = 0; x < state.population.subpops.length; ++x) {
            best_i[x] = state.population.subpops[x].individuals[0];
            for (int y = 1; y < state.population.subpops[x].individuals.length; ++y) {
                if (!state.population.subpops[x].individuals[y].fitness.betterThan(best_i[x].fitness)) continue;
                best_i[x] = state.population.subpops[x].individuals[y];
            }
            if (this.best_of_run[x] != null && !best_i[x].fitness.betterThan(this.best_of_run[x].fitness)) continue;
            this.best_of_run[x] = (Individual)best_i[x].clone();
        }
        state.output.println("\nGeneration: " + state.generation, this.statisticslog);
        state.output.println("Best Individual:", this.statisticslog);
        for (x = 0; x < state.population.subpops.length; ++x) {
            state.output.println("Subpopulation " + x + ":", this.statisticslog);
            best_i[x].printIndividualForHumans(state, this.statisticslog);
            state.output.message("Subpop " + x + " best fitness of generation: " + best_i[x].fitness.fitnessToStringForHumans());
        }
    }

    public void finalStatistics(EvolutionState state, int result) {
        super.finalStatistics(state, result);
        state.output.println("\nBest Individual of Run:", this.statisticslog);
        for (int x = 0; x < state.population.subpops.length; ++x) {
            state.output.println("Subpopulation " + x + ":", this.statisticslog);
            this.best_of_run[x].printIndividualForHumans(state, this.statisticslog);
            state.output.message("Subpop " + x + " best fitness of run: " + this.best_of_run[x].fitness.fitnessToStringForHumans());
            if (!(state.evaluator.p_problem instanceof SimpleProblemForm)) continue;
            ((SimpleProblemForm)state.evaluator.p_problem.clone()).describe(state, this.best_of_run[x], x, 0, this.statisticslog);
        }
    }
}

