/*
 * Decompiled with CFR 0.152.
 */
package ec.steadystate;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.simple.SimpleBreeder;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateDefaults;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;

public class SteadyStateBreeder
extends SimpleBreeder {
    BreedingPipeline[] bp = null;
    public static final String P_DESELECTOR = "deselector";
    SelectionMethod[] deselectors = null;
    static /* synthetic */ Class class$ec$SelectionMethod;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter p = new Parameter("pop").push("subpops");
        int size = state.parameters.getInt(p, null, 1);
        if (size > 0) {
            this.deselectors = new SelectionMethod[size];
        }
        for (int x = 0; x < this.deselectors.length; ++x) {
            this.deselectors[x] = (SelectionMethod)state.parameters.getInstanceForParameter(SteadyStateDefaults.base().push(P_DESELECTOR).push("" + x), null, class$ec$SelectionMethod == null ? SteadyStateBreeder.class$("ec.SelectionMethod") : class$ec$SelectionMethod);
            if (!(this.deselectors[x] instanceof SteadyStateBSourceForm)) {
                state.output.error("Deselector for subpopulation " + x + " is not of SteadyStateBSourceForm.");
            }
            this.deselectors[x].setup(state, SteadyStateDefaults.base().push(P_DESELECTOR).push("" + x));
        }
        state.output.exitIfErrors();
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState state, BreedingPipeline[] breedingPipelines) {
        for (int x = 0; x < breedingPipelines.length; ++x) {
            if (!(breedingPipelines[x] instanceof SteadyStateBSourceForm)) {
                state.output.error("Breeding Pipeline of subpopulation " + x + " is not of SteadyStateBSourceForm");
            }
            breedingPipelines[x].sourcesAreProperForm(state);
        }
    }

    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
        for (int x = 0; x < this.bp.length; ++x) {
            this.bp[x].individualReplaced(state, subpopulation, thread, individual);
        }
        ((SteadyStateBSourceForm)((Object)this.deselectors[subpopulation])).individualReplaced(state, subpopulation, thread, individual);
    }

    public void finishPipelines(EvolutionState state) {
        for (int x = 0; x < this.deselectors.length; ++x) {
            this.bp[x].finishProducing(state, x, 0);
            this.deselectors[x].finishProducing(state, x, 0);
        }
    }

    public void prepareToBreed(EvolutionState state, int thread) {
        int pop;
        SteadyStateEvolutionState st = (SteadyStateEvolutionState)state;
        this.bp = new BreedingPipeline[st.population.subpops.length];
        for (pop = 0; pop < this.bp.length; ++pop) {
            this.bp[pop] = (BreedingPipeline)st.population.subpops[pop].species.pipe_prototype.clone();
            if (this.bp[pop].produces(st, st.population, pop, 0)) continue;
            st.output.error("The Breeding Pipeline of subpopulation " + pop + " does not produce individuals of the expected species " + st.population.subpops[pop].species.getClass().getName() + " and with the expected Fitness class " + st.population.subpops[pop].species.f_prototype.getClass().getName());
        }
        this.sourcesAreProperForm(st, this.bp);
        st.output.exitIfErrors();
        for (pop = 0; pop < this.bp.length; ++pop) {
            this.bp[pop].prepareToProduce(state, pop, 0);
            this.deselectors[pop].prepareToProduce(state, pop, 0);
        }
    }

    public Individual breedIndividual(EvolutionState state, int subpop, int thread) {
        SteadyStateEvolutionState st = (SteadyStateEvolutionState)state;
        Individual[] newind = new Individual[1];
        this.bp[subpop].produce(1, 1, 0, subpop, newind, state, thread);
        return newind[0];
    }
}

