/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.ParamClassLoadException;
import ec.util.Parameter;
import ec.util.ParameterDatabaseTreeModel;
import ec.util.ParameterDatabaseTreeNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class ParameterDatabase
extends Properties
implements Serializable {
    public static final String C_HERE = "$";
    public static final String UNKNOWN_VALUE = "";
    public static final String PRINT_PARAMS = "print-params";
    public static final int PS_UNKNOWN = -1;
    public static final int PS_NONE = 0;
    public static final int PS_PRINT_PARAMS = 1;
    public int printState = -1;
    Vector parents;
    File directory;
    String filename = "";
    boolean checked = false;
    Hashtable gotten;
    Hashtable accessed = new Hashtable();
    Vector listeners;

    public Object getInstanceForParameter(Parameter parameter, Parameter defaultParameter, Class mustCastTosuperclass) throws ParamClassLoadException {
        Parameter p;
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            p = parameter;
        } else if (this._exists(defaultParameter)) {
            p = defaultParameter;
        } else {
            throw new ParamClassLoadException("No class name provided.\nPARAMETER: " + parameter + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter));
        }
        try {
            Class<?> c = Class.forName(this.get(p));
            if (!mustCastTosuperclass.isAssignableFrom(c)) {
                throw new ParamClassLoadException("The class " + c.getName() + "\ndoes not cast into the superclass " + mustCastTosuperclass.getName() + "\nPARAMETER: " + parameter + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter));
            }
            if (mustCastTosuperclass == c) {
                throw new ParamClassLoadException("The class " + c.getName() + "\nmust not be the same as the required superclass " + mustCastTosuperclass.getName() + "\nPARAMETER: " + parameter + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter));
            }
            return c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ParamClassLoadException("Class not found: " + this.get(p) + "\nPARAMETER: " + parameter + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
        catch (IllegalArgumentException e) {
            throw new ParamClassLoadException("Could not load class: " + this.get(p) + "\nPARAMETER: " + parameter + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
        catch (InstantiationException e) {
            throw new ParamClassLoadException("The requested class is an interface or an abstract class: " + this.get(p) + "\nPARAMETER: " + parameter + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
        catch (IllegalAccessException e) {
            throw new ParamClassLoadException("The requested class cannot be initialized with the default initializer: " + this.get(p) + "\nPARAMETER: " + parameter + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
    }

    public Object getInstanceForParameterEq(Parameter parameter, Parameter defaultParameter, Class mustCastTosuperclass) throws ParamClassLoadException {
        Parameter p;
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            p = parameter;
        } else if (this._exists(defaultParameter)) {
            p = defaultParameter;
        } else {
            throw new ParamClassLoadException("No class name provided.\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter));
        }
        try {
            Class<?> c = Class.forName(this.get(p));
            if (!mustCastTosuperclass.isAssignableFrom(c)) {
                throw new ParamClassLoadException("The class " + c.getName() + "\ndoes not cast into the superclass " + mustCastTosuperclass.getName() + "\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter));
            }
            return c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ParamClassLoadException("Class not found: " + this.get(p) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
        catch (IllegalArgumentException e) {
            throw new ParamClassLoadException("Could not load class: " + this.get(p) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
        catch (InstantiationException e) {
            throw new ParamClassLoadException("The requested class is an interface or an abstract class: " + this.get(p) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
        catch (IllegalAccessException e) {
            throw new ParamClassLoadException("The requested class cannot be initialized with the default initializer: " + this.get(p) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
    }

    public Object getClassForParameter(Parameter parameter, Parameter defaultParameter, Class mustCastTosuperclass) throws ParamClassLoadException {
        Parameter p;
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            p = parameter;
        } else if (this._exists(defaultParameter)) {
            p = defaultParameter;
        } else {
            throw new ParamClassLoadException("No class name provided.\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter));
        }
        try {
            Class<?> c = Class.forName(this.get(p));
            if (!mustCastTosuperclass.isAssignableFrom(c)) {
                throw new ParamClassLoadException("The class " + c.getName() + "\ndoes not cast into the superclass " + mustCastTosuperclass.getName() + "\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter));
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new ParamClassLoadException("Class not found: " + this.get(p) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
        catch (IllegalArgumentException e) {
            throw new ParamClassLoadException("Could not load class: " + this.get(p) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (defaultParameter == null ? UNKNOWN_VALUE : "\n     ALSO: " + defaultParameter) + "\nEXCEPTION: \n\n" + e);
        }
    }

    public boolean getBoolean(Parameter parameter, Parameter defaultParameter, boolean defaultValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getBoolean(parameter, defaultValue);
        }
        return this.getBoolean(defaultParameter, defaultValue);
    }

    boolean getBoolean(Parameter parameter, boolean defaultValue) {
        if (!this._exists(parameter)) {
            return defaultValue;
        }
        return !this.get(parameter).equalsIgnoreCase("false");
    }

    int parseInt(String string) throws NumberFormatException {
        if (string != null && string.length() > 0) {
            char c = 'x';
            if (string.charAt(0) == 'x' || c == 'X') {
                return Integer.parseInt(string.substring(1), 16);
            }
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            try {
                double d = Double.parseDouble(string);
                if (d == (double)((int)d)) {
                    return (int)d;
                }
                throw e;
            }
            catch (NumberFormatException e2) {
                throw e;
            }
        }
    }

    long parseLong(String string) throws NumberFormatException {
        if (string != null && string.length() > 0) {
            char c = 'x';
            if (string.charAt(0) == 'x' || c == 'X') {
                return Long.parseLong(string.substring(1), 16);
            }
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            try {
                double d = Double.parseDouble(string);
                if (d == (double)((long)d)) {
                    return (long)d;
                }
                throw e;
            }
            catch (NumberFormatException e2) {
                throw e;
            }
        }
    }

    int getInt(Parameter parameter) throws NumberFormatException {
        if (this._exists(parameter)) {
            try {
                return this.parseInt(this.get(parameter));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Bad integer (" + this.get(parameter) + " ) for parameter " + parameter);
            }
        }
        throw new NumberFormatException("Integer does not exist for parameter " + parameter);
    }

    public int getInt(Parameter parameter, Parameter defaultParameter) throws NumberFormatException {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getInt(parameter);
        }
        if (this._exists(defaultParameter)) {
            return this.getInt(defaultParameter);
        }
        throw new NumberFormatException("Integer does not exist for either parameter " + parameter + "\nor\n" + defaultParameter);
    }

    public int getInt(Parameter parameter, Parameter defaultParameter, int minValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getInt(parameter, minValue);
        }
        return this.getInt(defaultParameter, minValue);
    }

    int getInt(Parameter parameter, int minValue) {
        if (this._exists(parameter)) {
            try {
                int i = this.parseInt(this.get(parameter));
                if (i < minValue) {
                    return minValue - 1;
                }
                return i;
            }
            catch (NumberFormatException e) {
                return minValue - 1;
            }
        }
        return minValue - 1;
    }

    public int getIntWithDefault(Parameter parameter, Parameter defaultParameter, int defaultValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getIntWithDefault(parameter, defaultValue);
        }
        return this.getIntWithDefault(defaultParameter, defaultValue);
    }

    int getIntWithDefault(Parameter parameter, int defaultValue) {
        if (this._exists(parameter)) {
            try {
                return this.parseInt(this.get(parameter));
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int getIntWithMax(Parameter parameter, Parameter defaultParameter, int minValue, int maxValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getIntWithMax(parameter, minValue, maxValue);
        }
        return this.getIntWithMax(defaultParameter, minValue, maxValue);
    }

    int getIntWithMax(Parameter parameter, int minValue, int maxValue) {
        if (this._exists(parameter)) {
            try {
                int i = this.parseInt(this.get(parameter));
                if (i < minValue) {
                    return minValue - 1;
                }
                if (i > maxValue) {
                    return minValue - 1;
                }
                return i;
            }
            catch (NumberFormatException e) {
                return minValue - 1;
            }
        }
        return minValue - 1;
    }

    float getFloat(Parameter parameter) throws NumberFormatException {
        if (this._exists(parameter)) {
            try {
                return Float.valueOf(this.get(parameter)).floatValue();
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Bad float (" + this.get(parameter) + " ) for parameter " + parameter);
            }
        }
        throw new NumberFormatException("Float does not exist for parameter " + parameter);
    }

    public float getFloat(Parameter parameter, Parameter defaultParameter) throws NumberFormatException {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getFloat(parameter);
        }
        if (this._exists(defaultParameter)) {
            return this.getFloat(defaultParameter);
        }
        throw new NumberFormatException("Float does not exist for either parameter " + parameter + "\nor\n" + defaultParameter);
    }

    public float getFloat(Parameter parameter, Parameter defaultParameter, double minValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getFloat(parameter, minValue);
        }
        return this.getFloat(defaultParameter, minValue);
    }

    float getFloat(Parameter parameter, double minValue) {
        if (this._exists(parameter)) {
            try {
                float i = Float.valueOf(this.get(parameter)).floatValue();
                if ((double)i < minValue) {
                    return (float)(minValue - 1.0);
                }
                return i;
            }
            catch (NumberFormatException e) {
                return (float)(minValue - 1.0);
            }
        }
        return (float)(minValue - 1.0);
    }

    public float getFloatWithDefault(Parameter parameter, Parameter defaultParameter, double defaultValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getFloatWithDefault(parameter, defaultValue);
        }
        return this.getFloatWithDefault(defaultParameter, defaultValue);
    }

    float getFloatWithDefault(Parameter parameter, double defaultValue) {
        if (this._exists(parameter)) {
            try {
                return Float.valueOf(this.get(parameter)).floatValue();
            }
            catch (NumberFormatException e) {
                return (float)defaultValue;
            }
        }
        return (float)defaultValue;
    }

    public float getFloatWithMax(Parameter parameter, Parameter defaultParameter, double minValue, double maxValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getFloat(parameter, minValue, maxValue);
        }
        return this.getFloat(defaultParameter, minValue, maxValue);
    }

    public float getFloat(Parameter parameter, Parameter defaultParameter, double minValue, double maxValue) {
        return this.getFloatWithMax(parameter, defaultParameter, minValue, maxValue);
    }

    float getFloat(Parameter parameter, double minValue, double maxValue) {
        if (this._exists(parameter)) {
            try {
                float i = Float.valueOf(this.get(parameter)).floatValue();
                if ((double)i < minValue) {
                    return (float)(minValue - 1.0);
                }
                if ((double)i > maxValue) {
                    return (float)(minValue - 1.0);
                }
                return i;
            }
            catch (NumberFormatException e) {
                return (float)(minValue - 1.0);
            }
        }
        return (float)(minValue - 1.0);
    }

    double getDouble(Parameter parameter) throws NumberFormatException {
        if (this._exists(parameter)) {
            try {
                return Double.valueOf(this.get(parameter));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Bad double (" + this.get(parameter) + " ) for parameter " + parameter);
            }
        }
        throw new NumberFormatException("Double does not exist for parameter " + parameter);
    }

    public double getDouble(Parameter parameter, Parameter defaultParameter) throws NumberFormatException {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getDouble(parameter);
        }
        if (this._exists(defaultParameter)) {
            return this.getDouble(defaultParameter);
        }
        throw new NumberFormatException("Double does not exist for either parameter " + parameter + "\nor\n" + defaultParameter);
    }

    public double getDouble(Parameter parameter, Parameter defaultParameter, double minValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getDouble(parameter, minValue);
        }
        return this.getDouble(defaultParameter, minValue);
    }

    double getDouble(Parameter parameter, double minValue) {
        if (this._exists(parameter)) {
            try {
                double i = Double.valueOf(this.get(parameter));
                if (i < minValue) {
                    return minValue - 1.0;
                }
                return i;
            }
            catch (NumberFormatException e) {
                return minValue - 1.0;
            }
        }
        return minValue - 1.0;
    }

    public double getDoubleWithMax(Parameter parameter, Parameter defaultParameter, double minValue, double maxValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getDouble(parameter, minValue, maxValue);
        }
        return this.getDouble(defaultParameter, minValue, maxValue);
    }

    public double getDouble(Parameter parameter, Parameter defaultParameter, double minValue, double maxValue) {
        return this.getDoubleWithMax(parameter, defaultParameter, minValue, maxValue);
    }

    double getDouble(Parameter parameter, double minValue, double maxValue) {
        if (this._exists(parameter)) {
            try {
                double i = Double.valueOf(this.get(parameter));
                if (i < minValue) {
                    return minValue - 1.0;
                }
                if (i > maxValue) {
                    return minValue - 1.0;
                }
                return i;
            }
            catch (NumberFormatException e) {
                return minValue - 1.0;
            }
        }
        return minValue - 1.0;
    }

    public double getDoubleWithDefault(Parameter parameter, Parameter defaultParameter, double defaultValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getDoubleWithDefault(parameter, defaultValue);
        }
        return this.getDoubleWithDefault(defaultParameter, defaultValue);
    }

    double getDoubleWithDefault(Parameter parameter, double defaultValue) {
        if (this._exists(parameter)) {
            try {
                return Double.valueOf(this.get(parameter));
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    long getLong(Parameter parameter) throws NumberFormatException {
        if (this._exists(parameter)) {
            try {
                return this.parseLong(this.get(parameter));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Bad long (" + this.get(parameter) + " ) for parameter " + parameter);
            }
        }
        throw new NumberFormatException("Long does not exist for parameter " + parameter);
    }

    public long getLong(Parameter parameter, Parameter defaultParameter) throws NumberFormatException {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getLong(parameter);
        }
        if (this._exists(defaultParameter)) {
            return this.getLong(defaultParameter);
        }
        throw new NumberFormatException("Long does not exist for either parameter " + parameter + "\nor\n" + defaultParameter);
    }

    public long getLong(Parameter parameter, Parameter defaultParameter, long minValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getLong(parameter, minValue);
        }
        return this.getLong(defaultParameter, minValue);
    }

    long getLong(Parameter parameter, long minValue) {
        if (this._exists(parameter)) {
            try {
                long i = this.parseLong(this.get(parameter));
                if (i < minValue) {
                    return minValue - 1L;
                }
                return i;
            }
            catch (NumberFormatException e) {
                return minValue - 1L;
            }
        }
        return minValue - 1L;
    }

    public long getLongWithDefault(Parameter parameter, Parameter defaultParameter, long defaultValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getLongWithDefault(parameter, defaultValue);
        }
        return this.getLongWithDefault(defaultParameter, defaultValue);
    }

    long getLongWithDefault(Parameter parameter, long defaultValue) {
        if (this._exists(parameter)) {
            try {
                return this.parseLong(this.get(parameter));
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongWithMax(Parameter parameter, Parameter defaultParameter, long minValue, long maxValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getLong(parameter, minValue, maxValue);
        }
        return this.getLong(defaultParameter, minValue, maxValue);
    }

    long getLongWithMax(Parameter parameter, long minValue, long maxValue) {
        if (this._exists(parameter)) {
            try {
                long i = this.parseLong(this.get(parameter));
                if (i < minValue) {
                    return minValue - 1L;
                }
                if (i > maxValue) {
                    return minValue - 1L;
                }
                return i;
            }
            catch (NumberFormatException e) {
                return minValue - 1L;
            }
        }
        return minValue - 1L;
    }

    public long getLong(Parameter parameter, Parameter defaultParameter, long minValue, long maxValue) {
        this.printGotten(parameter, defaultParameter, false);
        return this.getLongWithMax(parameter, defaultParameter, minValue, maxValue);
    }

    long getLong(Parameter parameter, long minValue, long maxValue) {
        return this.getLongWithMax(parameter, minValue, maxValue);
    }

    public File getFile(Parameter parameter, Parameter defaultParameter) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getFile(parameter);
        }
        return this.getFile(defaultParameter);
    }

    File getFile(Parameter parameter) {
        if (this._exists(parameter)) {
            String p = this.get(parameter);
            if (p == null) {
                return null;
            }
            if (p.startsWith(C_HERE)) {
                return new File(p.substring(C_HERE.length()));
            }
            File f = new File(p);
            if (f.isAbsolute()) {
                return f;
            }
            return new File(this.directoryFor(parameter), p);
        }
        return null;
    }

    public synchronized String getString(Parameter parameter, Parameter defaultParameter) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getString(parameter);
        }
        return this.getString(defaultParameter);
    }

    synchronized String getString(Parameter parameter) {
        if (this._exists(parameter)) {
            return this.get(parameter);
        }
        return null;
    }

    public String getStringWithDefault(Parameter parameter, Parameter defaultParameter, String defaultValue) {
        this.printGotten(parameter, defaultParameter, false);
        if (this._exists(parameter)) {
            return this.getStringWithDefault(parameter, defaultValue);
        }
        return this.getStringWithDefault(defaultParameter, defaultValue);
    }

    String getStringWithDefault(Parameter parameter, String defaultValue) {
        if (this._exists(parameter)) {
            String result = this.get(parameter);
            if (result == null) {
                if (defaultValue == null) {
                    return null;
                }
                result = defaultValue.trim();
            } else if ((result = result.trim()).length() == 0) {
                if (defaultValue == null) {
                    return null;
                }
                result = defaultValue.trim();
            }
            return result;
        }
        if (defaultValue == null) {
            return null;
        }
        return defaultValue.trim();
    }

    synchronized void uncheck() {
        if (!this.checked) {
            return;
        }
        this.checked = false;
        int size = this.parents.size();
        for (int x = 0; x < size; ++x) {
            ((ParameterDatabase)this.parents.elementAt(x)).uncheck();
        }
    }

    public synchronized void set(Parameter parameter, String value) {
        String tmp = value.trim();
        this.put(parameter.param, tmp);
    }

    public synchronized void listGotten(PrintWriter p) {
        Vector vec = new Vector();
        Enumeration e = this.gotten.keys();
        while (e.hasMoreElements()) {
            vec.addElement(e.nextElement());
        }
        Object[] array = new Object[vec.size()];
        vec.copyInto(array);
        Collections.sort(vec);
        for (int x = 0; x < array.length; ++x) {
            String s = (String)array[x];
            String v = null;
            if (s != null) {
                v = this._get(s);
                this.uncheck();
            }
            if (v == null) {
                v = UNKNOWN_VALUE;
            }
            p.println(s + " = " + v);
        }
        p.flush();
    }

    public synchronized void listNotGotten(PrintWriter p) {
        Vector vec = new Vector();
        Hashtable all = new Hashtable();
        this._list(null, false, null, all);
        Enumeration e = this.gotten.keys();
        while (e.hasMoreElements()) {
            all.remove(e.nextElement());
        }
        e = all.keys();
        while (e.hasMoreElements()) {
            vec.addElement(e.nextElement());
        }
        Object[] array = new Object[vec.size()];
        vec.copyInto(array);
        Collections.sort(vec);
        for (int x = 0; x < array.length; ++x) {
            String s = (String)array[x];
            String v = null;
            if (s != null) {
                v = this._get(s);
                this.uncheck();
            }
            if (v == null) {
                v = UNKNOWN_VALUE;
            }
            p.println(s + " = " + v);
        }
        p.flush();
    }

    public synchronized void listNotAccessed(PrintWriter p) {
        Vector vec = new Vector();
        Hashtable all = new Hashtable();
        this._list(null, false, null, all);
        Enumeration e = this.accessed.keys();
        while (e.hasMoreElements()) {
            all.remove(e.nextElement());
        }
        e = all.keys();
        while (e.hasMoreElements()) {
            vec.addElement(e.nextElement());
        }
        Object[] array = new Object[vec.size()];
        vec.copyInto(array);
        Collections.sort(vec);
        for (int x = 0; x < array.length; ++x) {
            String s = (String)array[x];
            String v = null;
            if (s != null) {
                v = this._get(s);
                this.uncheck();
            }
            if (v == null) {
                v = UNKNOWN_VALUE;
            }
            p.println(s + " = " + v);
        }
        p.flush();
    }

    public synchronized void listAccessed(PrintWriter p) {
        Vector vec = new Vector();
        Enumeration e = this.accessed.keys();
        while (e.hasMoreElements()) {
            vec.addElement(e.nextElement());
        }
        Object[] array = new Object[vec.size()];
        vec.copyInto(array);
        Collections.sort(vec);
        for (int x = 0; x < array.length; ++x) {
            String s = (String)array[x];
            String v = null;
            if (s != null) {
                v = this._get(s);
                this.uncheck();
            }
            if (v == null) {
                v = UNKNOWN_VALUE;
            }
            p.println(s + " = " + v);
        }
        p.flush();
    }

    public synchronized boolean exists(Parameter parameter) {
        this.printGotten(parameter, null, true);
        return this._exists(parameter);
    }

    synchronized boolean _exists(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        String result = this._get(parameter.param);
        this.uncheck();
        this.accessed.put(parameter.param, Boolean.TRUE);
        return result != null;
    }

    public synchronized boolean exists(Parameter parameter, Parameter defaultParameter) {
        this.printGotten(parameter, defaultParameter, true);
        if (this.exists(parameter)) {
            return true;
        }
        return this.exists(defaultParameter);
    }

    void printGotten(Parameter parameter, Parameter defaultParameter, boolean exists) {
        Object p;
        if (this.printState == -1) {
            p = new Parameter(PRINT_PARAMS);
            String jp = this.get((Parameter)p);
            this.printState = jp == null || jp.equalsIgnoreCase("false") ? 0 : 1;
            this.uncheck();
            this.printGotten((Parameter)p, null, false);
        }
        if (this.printState == 1) {
            String result;
            p = "P: ";
            if (exists) {
                p = "E: ";
            }
            if (parameter == null && defaultParameter == null) {
                return;
            }
            if (parameter == null) {
                result = this._get(defaultParameter.param);
                this.uncheck();
                if (result == null) {
                    System.err.println("\t!" + (String)p + defaultParameter.param);
                } else {
                    System.err.println("\t " + (String)p + defaultParameter.param + " = " + result);
                }
            } else if (defaultParameter == null) {
                result = this._get(parameter.param);
                this.uncheck();
                if (result == null) {
                    System.err.println("\t!" + (String)p + parameter.param);
                } else {
                    System.err.println("\t " + (String)p + parameter.param + " = " + result);
                }
            } else {
                result = this._get(parameter.param);
                this.uncheck();
                if (result == null) {
                    System.err.println("\t!" + (String)p + parameter.param);
                    result = this._get(defaultParameter.param);
                    this.uncheck();
                    if (result == null) {
                        System.err.println("\t!" + (String)p + defaultParameter.param);
                    } else {
                        System.err.println("\t " + (String)p + defaultParameter.param + " = " + result);
                    }
                } else {
                    System.err.println("\t " + (String)p + parameter.param + " = " + result);
                    System.err.println("\t<" + (String)p + defaultParameter.param);
                }
            }
        }
    }

    synchronized String get(Parameter parameter) {
        String result = this._get(parameter.param);
        this.uncheck();
        if (parameter != null) {
            this.accessed.put(parameter.param, Boolean.TRUE);
        }
        if (parameter != null) {
            this.gotten.put(parameter.param, Boolean.TRUE);
        }
        return result;
    }

    synchronized String _get(String parameter) {
        if (parameter == null) {
            return null;
        }
        if (this.checked) {
            return null;
        }
        this.checked = true;
        String result = this.getProperty(parameter);
        if (result == null) {
            int size = this.parents.size();
            for (int x = 0; x < size; ++x) {
                result = ((ParameterDatabase)this.parents.elementAt(x))._get(parameter);
                if (result == null) continue;
                return result;
            }
        } else if ((result = result.trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    Set _getShadowedValues(Parameter parameter, Set vals) {
        if (parameter == null) {
            return vals;
        }
        if (this.checked) {
            return vals;
        }
        this.checked = true;
        String result = this.getProperty(parameter.param);
        if (result != null && (result = result.trim()).length() != 0) {
            vals.add(result);
        }
        int size = this.parents.size();
        for (int i = 0; i < size; ++i) {
            ((ParameterDatabase)this.parents.elementAt(i))._getShadowedValues(parameter, vals);
        }
        return vals;
    }

    public Set getShadowedValues(Parameter parameter) {
        Set vals = new HashSet();
        vals = this._getShadowedValues(parameter, vals);
        this.uncheck();
        return vals;
    }

    public File directoryFor(Parameter parameter) {
        File result = this._directoryFor(parameter);
        this.uncheck();
        return result;
    }

    synchronized File _directoryFor(Parameter parameter) {
        if (this.checked) {
            return null;
        }
        this.checked = true;
        File result = null;
        String p = this.getProperty(parameter.param);
        if (p == null) {
            int size = this.parents.size();
            for (int x = 0; x < size; ++x) {
                result = ((ParameterDatabase)this.parents.elementAt(x))._directoryFor(parameter);
                if (result == null) continue;
                return result;
            }
            return result;
        }
        return this.directory;
    }

    public String getLocation(Parameter parameter) {
        File file = this.fileFor(parameter);
        if (file == null) {
            return UNKNOWN_VALUE;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return UNKNOWN_VALUE;
        }
    }

    public File fileFor(Parameter parameter) {
        File result = this._fileFor(parameter);
        this.uncheck();
        return result;
    }

    synchronized File _fileFor(Parameter parameter) {
        if (this.checked) {
            return null;
        }
        this.checked = true;
        File result = null;
        String p = this.getProperty(parameter.param);
        if (p == null) {
            int size = this.parents.size();
            for (int i = 0; i < size; ++i) {
                result = ((ParameterDatabase)this.parents.elementAt(i))._fileFor(parameter);
                if (result == null) continue;
                return result;
            }
            return result;
        }
        return new File(this.directory, this.filename);
    }

    public synchronized void remove(Parameter parameter) {
        if (parameter.param.equals(PRINT_PARAMS)) {
            this.printState = -1;
        }
        this.remove(parameter.param);
    }

    public synchronized void removeDeeply(Parameter parameter) {
        this._removeDeeply(parameter);
        this.uncheck();
    }

    synchronized void _removeDeeply(Parameter parameter) {
        if (this.checked) {
            return;
        }
        this.checked = true;
        this.remove(parameter);
        int size = this.parents.size();
        for (int x = 0; x < size; ++x) {
            ((ParameterDatabase)this.parents.elementAt(x)).removeDeeply(parameter);
        }
    }

    public void addParent(ParameterDatabase database) {
        this.parents.addElement(database);
    }

    public ParameterDatabase() {
        this.gotten = new Hashtable();
        this.directory = new File(new File(UNKNOWN_VALUE).getAbsolutePath());
        this.parents = new Vector();
        this.listeners = new Vector();
    }

    public ParameterDatabase(Dictionary map) throws FileNotFoundException, IOException {
        this();
        Enumeration keys = map.keys();
        while (keys.hasMoreElements()) {
            Object obj = keys.nextElement();
            this.set(new Parameter(UNKNOWN_VALUE + obj), UNKNOWN_VALUE + map.get(obj));
        }
        int x = 0;
        String s;
        while ((s = this.getProperty("parent." + x)) != null) {
            if (!new File(s).isAbsolute()) {
                throw new FileNotFoundException("Attempt to load a relative file, but there's no parent file: " + s);
            }
            this.parents.addElement(new ParameterDatabase(new File(s)));
            ++x;
        }
        return;
    }

    public ParameterDatabase(String pathNameInJar, Class jarResourceLocation) throws FileNotFoundException, IOException {
        this();
        this.load(jarResourceLocation.getResourceAsStream(pathNameInJar));
        this.listeners = new Vector();
        int x = 0;
        String s;
        while ((s = this.getProperty("parent." + x)) != null) {
            String path = new File(new File(pathNameInJar).getParent(), s).toString();
            this.parents.addElement(new ParameterDatabase(path, jarResourceLocation));
            ++x;
        }
        return;
    }

    public ParameterDatabase(InputStream stream) throws FileNotFoundException, IOException {
        this();
        this.load(stream);
        this.listeners = new Vector();
        int x = 0;
        String s;
        while ((s = this.getProperty("parent." + x)) != null) {
            if (!new File(s).isAbsolute()) {
                throw new FileNotFoundException("Attempt to load a relative file, but there's no parent file: " + s);
            }
            this.parents.addElement(new ParameterDatabase(new File(s)));
            ++x;
        }
        return;
    }

    public ParameterDatabase(File filename) throws FileNotFoundException, IOException {
        this();
        this.filename = filename.getName();
        this.directory = new File(filename.getParent());
        this.load(new FileInputStream(filename));
        this.listeners = new Vector();
        int x = 0;
        String s;
        while ((s = this.getProperty("parent." + x)) != null) {
            if (new File(s).isAbsolute()) {
                this.parents.addElement(new ParameterDatabase(new File(s)));
            } else {
                this.parents.addElement(new ParameterDatabase(new File(filename.getParent(), s)));
            }
            ++x;
        }
        return;
    }

    public ParameterDatabase(File filename, String[] args) throws FileNotFoundException, IOException {
        this();
        this.filename = filename.getName();
        this.directory = new File(filename.getParent());
        ParameterDatabase files = new ParameterDatabase(filename);
        ParameterDatabase a = new ParameterDatabase();
        a.parents.addElement(files);
        for (int x = 0; x < args.length - 1; ++x) {
            int eq;
            String s;
            if (!args[x].equals("-p") || (s = args[x + 1].trim()).length() == 0 || (eq = s.indexOf(61)) <= 0) continue;
            this.put(s.substring(0, eq), s.substring(eq + 1));
        }
        this.parents.addElement(a);
        this.listeners = new Vector();
    }

    public void list(PrintWriter p) {
        this.list(p, false);
    }

    public void list(PrintWriter p, boolean listShadowed) {
        if (listShadowed) {
            this._list(p, listShadowed, "root", null);
        } else {
            Hashtable gather = new Hashtable();
            this._list(null, listShadowed, "root", gather);
            Vector vec = new Vector();
            Enumeration e = gather.keys();
            while (e.hasMoreElements()) {
                vec.addElement(e.nextElement());
            }
            Collections.sort(vec);
            for (int x = 0; x < vec.size(); ++x) {
                String s = (String)vec.get(x);
                String v = null;
                if (s != null) {
                    v = (String)gather.get(s);
                }
                if (v == null) {
                    v = UNKNOWN_VALUE;
                }
                if (p == null) continue;
                p.println(s + " = " + v);
            }
        }
        if (p != null) {
            p.flush();
        }
    }

    void _list(PrintWriter p, boolean listShadowed, String prefix, Hashtable gather) {
        if (listShadowed) {
            if (p != null) {
                p.println("\n########" + prefix);
            }
            super.list(p);
            int size = this.parents.size();
            for (int x = 0; x < size; ++x) {
                ((ParameterDatabase)this.parents.elementAt(x))._list(p, listShadowed, prefix + "." + x, gather);
            }
        } else {
            int size = this.parents.size();
            for (int x = size - 1; x >= 0; --x) {
                ((ParameterDatabase)this.parents.elementAt(x))._list(p, listShadowed, prefix, gather);
            }
            Enumeration<Object> e = this.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                gather.put(key, this.get(key));
            }
        }
        if (p != null) {
            p.flush();
        }
    }

    public String toString() {
        String s = super.toString();
        if (this.parents.size() > 0) {
            s = s + " : (";
            for (int x = 0; x < this.parents.size(); ++x) {
                if (x > 0) {
                    s = s + ", ";
                }
                s = s + this.parents.elementAt(x);
            }
            s = s + ")";
        }
        return s;
    }

    public TreeModel buildTreeModel() {
        String sep = System.getProperty("file.separator");
        ParameterDatabaseTreeNode root = new ParameterDatabaseTreeNode(this.directory.getAbsolutePath() + sep + this.filename);
        ParameterDatabaseTreeModel model = new ParameterDatabaseTreeModel(root);
        this._buildTreeModel(model, root);
        model.sort(root, new Comparator(){

            public int compare(Object o1, Object o2) {
                ParameterDatabaseTreeNode t1 = (ParameterDatabaseTreeNode)o1;
                ParameterDatabaseTreeNode t2 = (ParameterDatabaseTreeNode)o2;
                return ((Comparable)t1.getUserObject()).compareTo(t2.getUserObject());
            }
        });
        model.setVisibleLeaves(false);
        return model;
    }

    void _buildTreeModel(DefaultTreeModel model, DefaultMutableTreeNode root) {
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            this._addNodeForParameter(model, root, (String)e.nextElement());
        }
        int size = this.parents.size();
        for (int i = 0; i < size; ++i) {
            ParameterDatabase parentDB = (ParameterDatabase)this.parents.elementAt(i);
            parentDB._buildTreeModel(model, root);
        }
    }

    void _addNodeForParameter(DefaultTreeModel model, DefaultMutableTreeNode root, String key) {
        if (key.indexOf("parent.") == -1) {
            StringTokenizer tok = new StringTokenizer(key, ".");
            String[] path = new String[tok.countTokens()];
            int t = 0;
            while (tok.hasMoreTokens()) {
                path[t++] = tok.nextToken();
            }
            DefaultMutableTreeNode parent = root;
            for (int i = 0; i < path.length; ++i) {
                int children = model.getChildCount(parent);
                if (children > 0) {
                    DefaultMutableTreeNode child;
                    int c;
                    for (c = 0; c < children; ++c) {
                        child = (DefaultMutableTreeNode)parent.getChildAt(c);
                        if (!child.getUserObject().equals(path[i])) continue;
                        parent = child;
                        break;
                    }
                    if (c != children) continue;
                    child = new ParameterDatabaseTreeNode(path[i]);
                    model.insertNodeInto(child, parent, parent.getChildCount());
                    parent = child;
                    continue;
                }
                ParameterDatabaseTreeNode child = new ParameterDatabaseTreeNode(path[i]);
                model.insertNodeInto(child, parent, 0);
                parent = child;
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        ParameterDatabase pd = new ParameterDatabase(new File(args[0]), args);
        pd.set(new Parameter("Hi there"), "Whatever");
        pd.set(new Parameter(new String[]{"1", "2", "3"}), " Whatever ");
        pd.set(new Parameter(new String[]{"a", "b", "c"}).pop().push("d"), "Whatever");
        System.err.println("\n\n PRINTING ALL PARAMETERS \n\n");
        pd.list(new PrintWriter(System.err, true), true);
        System.err.println("\n\n PRINTING ONLY VALID PARAMETERS \n\n");
        pd.list(new PrintWriter(System.err, true), false);
    }
}

