/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import ec.vector.FloatVectorIndividual;
import ec.vector.VectorSpecies;

public class FloatVectorSpecies
extends VectorSpecies {
    public static final String P_MINGENE = "min-gene";
    public static final String P_MAXGENE = "max-gene";
    public static final String P_MUTATIONTYPE = "mutation-type";
    public static final String P_STDEV = "mutation-stdev";
    public static final String P_MUTATION_DISTRIBUTION_INDEX = "mutation-distribution-index";
    public static final String P_POLYNOMIAL_ALTERNATIVE = "alternative-polynomial-version";
    public static final String V_RESET_MUTATION = "reset";
    public static final String V_GAUSS_MUTATION = "gauss";
    public static final String V_POLYNOMIAL_MUTATION = "polynomial";
    public static final String P_OUTOFBOUNDS_RETRIES = "out-of-bounds-retries";
    public static final String P_NUM_SEGMENTS = "num-segments";
    public static final String P_SEGMENT_TYPE = "segment-type";
    public static final String P_SEGMENT_START = "start";
    public static final String P_SEGMENT_END = "end";
    public static final String P_SEGMENT = "segment";
    public static final String P_MUTATION_BOUNDED = "mutation-bounded";
    public static final int C_RESET_MUTATION = 0;
    public static final int C_GAUSS_MUTATION = 1;
    public static final int C_POLYNOMIAL_MUTATION = 2;
    public double[] minGenes;
    public double[] maxGenes;
    public int mutationType;
    public double gaussMutationStdev;
    public boolean mutationIsBounded;
    public int outOfBoundsRetries = 100;
    public int mutationDistributionIndex;
    public boolean polynomialIsAlternative;
    static final double SIMULATED_BINARY_CROSSOVER_EPS = 1.0E-14;
    private boolean outOfBoundsRetriesWarningPrinted = false;

    public void outOfRangeRetryLimitReached(EvolutionState state) {
        if (!this.outOfBoundsRetriesWarningPrinted) {
            this.outOfBoundsRetriesWarningPrinted = true;
            state.output.warning("The limit of 'out-of-range' retries for gaussian mutation was reached.");
        }
    }

    public double maxGene(int gene) {
        double[] m = this.maxGenes;
        if (m.length <= gene) {
            if (!this.dynamicInitialSize && !this.warned) {
                this.warnAboutGene(gene);
            }
            gene = m.length - 1;
        }
        return m[gene];
    }

    public double minGene(int gene) {
        double[] m = this.minGenes;
        if (m.length <= gene) {
            if (!this.dynamicInitialSize && !this.warned) {
                this.warnAboutGene(gene);
            }
            gene = m.length - 1;
        }
        return m[gene];
    }

    public boolean inNumericalTypeRange(double geneVal) {
        if (this.i_prototype instanceof FloatVectorIndividual) {
            return geneVal <= 3.4028234663852886E38 && geneVal >= -3.4028234663852886E38;
        }
        return this.i_prototype instanceof DoubleVectorIndividual;
    }

    public void setup(EvolutionState state, Parameter base) {
        int x;
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.minGenes = new double[this.genomeSize];
        this.maxGenes = new double[this.genomeSize];
        double minGene = state.parameters.getDoubleWithDefault(base.push(P_MINGENE), def.push(P_MINGENE), 0.0);
        double maxGene = state.parameters.getDouble(base.push(P_MAXGENE), def.push(P_MAXGENE), minGene);
        if (maxGene < minGene) {
            state.output.fatal("FloatVectorSpecies must have a default min-gene which is <= the default max-gene", base.push(P_MAXGENE), def.push(P_MAXGENE));
        }
        for (int x2 = 0; x2 < this.genomeSize; ++x2) {
            this.minGenes[x2] = minGene;
            this.maxGenes[x2] = maxGene;
        }
        int numSegments = 0;
        if (state.parameters.exists(base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS))) {
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-segment min/max gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            }
            if ((numSegments = state.parameters.getIntWithDefault(base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS), 0)) == 0) {
                state.output.warning("The number of genome segments has been defined to be equal to 0.\nHence, no genome segments will be defined.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            } else if (numSegments < 0) {
                state.output.fatal("Invalid number of genome segments: " + numSegments + "\nIt must be a nonnegative value.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            }
            String segmentType = state.parameters.getStringWithDefault(base.push(P_SEGMENT_TYPE), def.push(P_SEGMENT_TYPE), P_SEGMENT_START);
            if (segmentType.equalsIgnoreCase(P_SEGMENT_START)) {
                this.initializeGenomeSegmentsByStartIndices(state, base, def, numSegments, minGene, maxGene);
            } else if (segmentType.equalsIgnoreCase(P_SEGMENT_END)) {
                this.initializeGenomeSegmentsByEndIndices(state, base, def, numSegments, minGene, maxGene);
            } else {
                state.output.fatal("Invalid specification of genome segment type: " + segmentType + "\nThe " + P_SEGMENT_TYPE + " parameter must have the value of " + P_SEGMENT_START + " or " + P_SEGMENT_END, base.push(P_SEGMENT_TYPE), def.push(P_SEGMENT_TYPE));
            }
        }
        boolean foundStuff = false;
        boolean warnedMin = false;
        boolean warnedMax = false;
        for (x = 0; x < this.genomeSize; ++x) {
            if (!state.parameters.exists(base.push(P_MINGENE).push("" + x), def.push(P_MINGENE).push("" + x))) {
                if (foundStuff && !warnedMin) {
                    state.output.warning("FloatVectorSpecies has missing min-gene values for some genes.\nThe first one is gene #" + x + ".", base.push(P_MINGENE).push("" + x), def.push(P_MINGENE).push("" + x));
                    warnedMin = true;
                }
            } else {
                if (this.dynamicInitialSize) {
                    state.output.warnOnce("Using dynamic initial sizing, but per-gene min/max gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_MINGENE).push("" + x), base.push(P_MINGENE).push("" + x));
                }
                this.minGenes[x] = state.parameters.getDoubleWithDefault(base.push(P_MINGENE).push("" + x), def.push(P_MINGENE).push("" + x), minGene);
                foundStuff = true;
            }
            if (!state.parameters.exists(base.push(P_MAXGENE).push("" + x), def.push(P_MAXGENE).push("" + x))) {
                if (!foundStuff || warnedMax) continue;
                state.output.warning("FloatVectorSpecies has missing max-gene values for some genes.\nThe first one is gene #" + x + ".", base.push(P_MAXGENE).push("" + x), def.push(P_MAXGENE).push("" + x));
                warnedMax = true;
                continue;
            }
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-gene min/max gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_MINGENE).push("" + x), base.push(P_MINGENE).push("" + x));
            }
            this.maxGenes[x] = state.parameters.getDoubleWithDefault(base.push(P_MAXGENE).push("" + x), def.push(P_MAXGENE).push("" + x), maxGene);
            foundStuff = true;
        }
        for (x = 0; x < this.genomeSize; ++x) {
            if (this.maxGenes[x] != this.maxGenes[x]) {
                state.output.fatal("FloatVectorSpecies found that max-gene[" + x + "] is NaN");
            }
            if (this.minGenes[x] != this.minGenes[x]) {
                state.output.fatal("FloatVectorSpecies found that min-gene[" + x + "] is NaN");
            }
            if (this.maxGenes[x] < this.minGenes[x]) {
                state.output.fatal("FloatVectorSpecies must have a min-gene[" + x + "] which is <= the max-gene[" + x + "]");
            }
            if (!this.inNumericalTypeRange(this.minGenes[x])) {
                state.output.fatal("This FloatvectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a min-gene[" + x + "] value within the range of this prototype's genome's data types");
            }
            if (this.inNumericalTypeRange(this.maxGenes[x])) continue;
            state.output.fatal("This FloatvectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a max-gene[" + x + "] value within the range of this prototype's genome's data types");
        }
        this.mutationIsBounded = state.parameters.getBoolean(base.push(P_MUTATION_BOUNDED), def.push(P_MUTATION_BOUNDED), true);
        String mtype = state.parameters.getStringWithDefault(base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE), null);
        this.mutationType = 0;
        if (mtype == null) {
            state.output.warning("No mutation type given for FloatVectorSpecies, assuming 'reset' mutation", base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE));
        } else if (mtype.equalsIgnoreCase(V_RESET_MUTATION)) {
            this.mutationType = 0;
        } else if (mtype.equalsIgnoreCase(V_POLYNOMIAL_MUTATION)) {
            this.mutationType = 2;
        } else if (mtype.equalsIgnoreCase(V_GAUSS_MUTATION)) {
            this.mutationType = 1;
        } else {
            state.output.fatal("FloatVectorSpecies given a bad mutation type: " + mtype, base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE));
        }
        if (this.mutationType == 2) {
            this.mutationDistributionIndex = state.parameters.getInt(base.push(P_MUTATION_DISTRIBUTION_INDEX), def.push(P_MUTATION_DISTRIBUTION_INDEX), 0);
            if (this.mutationDistributionIndex < 0) {
                state.output.fatal("If FloatVectorSpecies is going to use polynomial mutation, the distribution index must be defined and >= 0.", base.push(P_MUTATION_DISTRIBUTION_INDEX), def.push(P_MUTATION_DISTRIBUTION_INDEX));
            }
            this.polynomialIsAlternative = state.parameters.getBoolean(base.push(P_POLYNOMIAL_ALTERNATIVE), def.push(P_POLYNOMIAL_ALTERNATIVE), true);
            this.outOfBoundsRetries = state.parameters.getIntWithDefault(base.push(P_OUTOFBOUNDS_RETRIES), def.push(P_OUTOFBOUNDS_RETRIES), this.outOfBoundsRetries);
            if (this.outOfBoundsRetries < 0) {
                state.output.fatal("If it's going to use polynomial mutation, FloatvectorSpecies must have a positive number of out-of-bounds retries or 0 (for don't give up).  This is even the case if doing so-called \"bounded\" polynomial mutation, which auto-bounds anyway, or if the mutation is unbounded.  In either case, just provide an arbitrary value, which will be ignored.", base.push(P_OUTOFBOUNDS_RETRIES), def.push(P_OUTOFBOUNDS_RETRIES));
            }
        }
        if (this.mutationType == 1) {
            this.gaussMutationStdev = state.parameters.getDouble(base.push(P_STDEV), def.push(P_STDEV), 0.0);
            if (this.gaussMutationStdev <= 0.0) {
                state.output.fatal("If it's going to use gaussian mutation, FloatvectorSpecies must have a strictly positive standard deviation", base.push(P_STDEV), def.push(P_STDEV));
            }
            this.outOfBoundsRetries = state.parameters.getIntWithDefault(base.push(P_OUTOFBOUNDS_RETRIES), def.push(P_OUTOFBOUNDS_RETRIES), this.outOfBoundsRetries);
            if (this.outOfBoundsRetries < 0) {
                state.output.fatal("If it's going to use gaussian mutation, FloatvectorSpecies must have a positive number of out-of-bounds retries or 0 (for don't give up).  This is even the case if the mutation is unbounded.  In that case, just provide an arbitrary value, which will be ignored.", base.push(P_OUTOFBOUNDS_RETRIES), def.push(P_OUTOFBOUNDS_RETRIES));
            }
        }
    }

    private void initializeGenomeSegmentsByStartIndices(EvolutionState state, Parameter base, Parameter def, int numSegments, double minGene, double maxGene) {
        boolean warnedMin = false;
        boolean warnedMax = false;
        double currentSegmentMinGeneValue = Double.MAX_VALUE;
        double currentSegmentMaxGeneValue = Double.MIN_VALUE;
        int previousSegmentEnd = this.genomeSize;
        int currentSegmentEnd = 0;
        for (int i = numSegments - 1; i >= 0; --i) {
            if (state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START))) {
                currentSegmentEnd = state.parameters.getInt(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START));
            } else {
                state.output.fatal("Genome segment " + i + " has not been defined!" + "\nYou must specify start indices for " + numSegments + " segment(s)", base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START));
            }
            if (currentSegmentEnd >= previousSegmentEnd || currentSegmentEnd < 0) {
                state.output.fatal("Invalid start index value for segment " + i + ": " + currentSegmentEnd + "\nThe value must be smaller than " + previousSegmentEnd + " and greater than or equal to  " + 0);
            }
            if (i == 0 && currentSegmentEnd != 0) {
                state.output.fatal("Invalid start index value for the first segment " + i + ": " + currentSegmentEnd + "\nThe value must be equal to " + 0);
            }
            if (!state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE))) {
                if (!warnedMin) {
                    state.output.warning("IntegerVectorSpecies has missing min-gene values for some segments.\nThe first segment is #" + i + ".", base.push(P_SEGMENT).push("" + i), base.push(P_SEGMENT).push("" + i));
                    warnedMin = true;
                }
                currentSegmentMinGeneValue = minGene;
            } else {
                currentSegmentMinGeneValue = state.parameters.getDoubleWithDefault(base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE), minGene);
                if (!this.inNumericalTypeRange(currentSegmentMinGeneValue)) {
                    state.output.error("This IntegerVectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a min-gene " + " value for segment " + i + " within the range of this prototype's genome's data types", base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE));
                }
            }
            if (!state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE))) {
                if (!warnedMax) {
                    state.output.warning("IntegerVectorSpecies has missing max-gene values for some segments.\nThe first segment is #" + i + ".", base.push(P_SEGMENT).push("" + i), base.push(P_SEGMENT).push("" + i));
                    warnedMax = true;
                }
                currentSegmentMaxGeneValue = maxGene;
            } else {
                currentSegmentMaxGeneValue = state.parameters.getDoubleWithDefault(base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), maxGene);
                if (!this.inNumericalTypeRange(currentSegmentMaxGeneValue)) {
                    state.output.fatal("This IntegerVectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a max-gene " + " value for segment " + i + " within the range of this prototype's genome's data types", base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE));
                }
            }
            if (currentSegmentMaxGeneValue < currentSegmentMinGeneValue) {
                state.output.fatal("IntegerVectorSpecies must have a min-gene value for segment " + i + " which is <= the max-gene value", base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE));
            }
            for (int j = previousSegmentEnd - 1; j >= currentSegmentEnd; --j) {
                this.minGenes[j] = currentSegmentMinGeneValue;
                this.maxGenes[j] = currentSegmentMaxGeneValue;
            }
            previousSegmentEnd = currentSegmentEnd;
        }
    }

    private void initializeGenomeSegmentsByEndIndices(EvolutionState state, Parameter base, Parameter def, int numSegments, double minGene, double maxGene) {
        boolean warnedMin = false;
        boolean warnedMax = false;
        double currentSegmentMinGeneValue = Double.MAX_VALUE;
        double currentSegmentMaxGeneValue = Double.MIN_VALUE;
        int previousSegmentEnd = -1;
        int currentSegmentEnd = 0;
        for (int i = 0; i < numSegments; ++i) {
            if (state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END))) {
                currentSegmentEnd = state.parameters.getInt(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END));
            } else {
                state.output.fatal("Genome segment " + i + " has not been defined!" + "\nYou must specify end indices for " + numSegments + " segment(s)", base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END));
            }
            if (currentSegmentEnd <= previousSegmentEnd || currentSegmentEnd >= this.genomeSize) {
                state.output.fatal("Invalid end index value for segment " + i + ": " + currentSegmentEnd + "\nThe value must be greater than " + previousSegmentEnd + " and smaller than " + this.genomeSize);
            }
            if (i == numSegments - 1 && currentSegmentEnd != this.genomeSize - 1) {
                state.output.fatal("Invalid end index value for the last segment " + i + ": " + currentSegmentEnd + "\nThe value must be equal to the index of the last gene in the genome:  " + (this.genomeSize - 1));
            }
            if (!state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE))) {
                if (!warnedMin) {
                    state.output.warning("IntegerVectorSpecies has missing min-gene values for some segments.\nThe first segment is #" + i + ".", base.push(P_SEGMENT).push("" + i), base.push(P_SEGMENT).push("" + i));
                    warnedMin = true;
                }
                currentSegmentMinGeneValue = minGene;
            } else {
                currentSegmentMinGeneValue = state.parameters.getDoubleWithDefault(base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE), minGene);
                if (!this.inNumericalTypeRange(currentSegmentMinGeneValue)) {
                    state.output.error("This IntegerVectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a min-gene " + " value for segment " + i + " within the range of this prototype's genome's data types", base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE));
                }
            }
            if (!state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE))) {
                if (!warnedMax) {
                    state.output.warning("IntegerVectorSpecies has missing max-gene values for some segments.\nThe first segment is #" + i + ".", base.push(P_SEGMENT).push("" + i), base.push(P_SEGMENT).push("" + i));
                    warnedMax = true;
                }
                currentSegmentMaxGeneValue = maxGene;
            } else {
                currentSegmentMaxGeneValue = state.parameters.getDoubleWithDefault(base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), maxGene);
                if (!this.inNumericalTypeRange(currentSegmentMaxGeneValue)) {
                    state.output.fatal("This IntegerVectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a max-gene " + " value for segment " + i + " within the range of this prototype's genome's data types", base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE));
                }
            }
            if (currentSegmentMaxGeneValue < currentSegmentMinGeneValue) {
                state.output.fatal("IntegerVectorSpecies must have a min-gene value for segment " + i + " which is <= the max-gene value", base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE));
            }
            for (int j = previousSegmentEnd + 1; j <= currentSegmentEnd; ++j) {
                this.minGenes[j] = currentSegmentMinGeneValue;
                this.maxGenes[j] = currentSegmentMaxGeneValue;
            }
            previousSegmentEnd = currentSegmentEnd;
        }
    }
}

