/*
 * Decompiled with CFR 0.152.
 */
package ec.vector.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;

public class VectorCrossoverPipeline
extends BreedingPipeline {
    public static final String P_TOSS = "toss";
    public static final String P_CROSSOVER = "xover";
    public static final int NUM_SOURCES = 2;
    public boolean tossSecondParent;
    VectorIndividual[] parents = new VectorIndividual[2];

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_CROSSOVER);
    }

    public int numSources() {
        return 2;
    }

    public Object clone() {
        VectorCrossoverPipeline c = (VectorCrossoverPipeline)super.clone();
        c.parents = (VectorIndividual[])this.parents.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.tossSecondParent = state.parameters.getBoolean(base.push(P_TOSS), def.push(P_TOSS), false);
    }

    public int typicalIndsProduced() {
        return this.tossSecondParent ? this.minChildProduction() : this.minChildProduction() * 2;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.typicalIndsProduced();
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, true);
        }
        int q = start;
        while (q < n + start) {
            if (this.sources[0] == this.sources[1]) {
                this.sources[0].produce(2, 2, 0, subpopulation, this.parents, state, thread);
                if (!(this.sources[0] instanceof BreedingPipeline)) {
                    this.parents[0] = (VectorIndividual)this.parents[0].clone();
                    this.parents[1] = (VectorIndividual)this.parents[1].clone();
                }
            } else {
                this.sources[0].produce(1, 1, 0, subpopulation, this.parents, state, thread);
                this.sources[1].produce(1, 1, 1, subpopulation, this.parents, state, thread);
                if (!(this.sources[0] instanceof BreedingPipeline)) {
                    this.parents[0] = (VectorIndividual)this.parents[0].clone();
                }
                if (!(this.sources[1] instanceof BreedingPipeline)) {
                    this.parents[1] = (VectorIndividual)this.parents[1].clone();
                }
            }
            this.parents[0].defaultCrossover(state, thread, this.parents[1]);
            this.parents[0].evaluated = false;
            this.parents[1].evaluated = false;
            inds[q] = this.parents[0];
            if (++q >= n + start || this.tossSecondParent) continue;
            inds[q] = this.parents[1];
            ++q;
        }
        return n;
    }
}

