/*
 * Decompiled with CFR 0.152.
 */
package ec.vector.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;

public class VectorMutationPipeline
extends BreedingPipeline {
    public static final String P_MUTATION = "mutate";
    public static final int NUM_SOURCES = 1;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_MUTATION);
    }

    public int numSources() {
        return 1;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int q;
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            for (q = start; q < n + start; ++q) {
                inds[q] = (Individual)inds[q].clone();
            }
        }
        for (q = start; q < n + start; ++q) {
            ((VectorIndividual)inds[q]).defaultMutate(state, thread);
            ((VectorIndividual)inds[q]).evaluated = false;
        }
        return n;
    }
}

