/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WrappedParameter {
    private Parameter m_parameter;
    private DynamicParameter m_dynamicParameter;

    public WrappedParameter(Parameter p) {
        this.m_parameter = p;
    }

    public WrappedParameter(DynamicParameter p) {
        this.m_dynamicParameter = p;
    }

    public int arity() {
        return this.m_parameter != null ? this.m_parameter.arity() : 1;
    }

    public boolean hidden() {
        return this.m_parameter != null ? this.m_parameter.hidden() : this.m_dynamicParameter.hidden();
    }

    public boolean required() {
        return this.m_parameter != null ? this.m_parameter.required() : this.m_dynamicParameter.required();
    }

    public boolean password() {
        return this.m_parameter != null ? this.m_parameter.password() : false;
    }

    public String[] names() {
        return this.m_parameter != null ? this.m_parameter.names() : this.m_dynamicParameter.names();
    }

    public boolean variableArity() {
        return this.m_parameter != null ? this.m_parameter.variableArity() : false;
    }

    public Class<? extends IParameterValidator> validateWith() {
        return this.m_parameter != null ? this.m_parameter.validateWith() : this.m_dynamicParameter.validateWith();
    }

    public void addValue(Field field, Object object, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (this.m_parameter != null) {
            field.set(object, value);
        } else {
            String a = this.m_dynamicParameter.assignment();
            String sv = value.toString();
            int aInd = sv.indexOf(a);
            if (aInd == -1) {
                throw new ParameterException("Dynamic parameter expected a value of the form a" + a + "b" + " but got:" + sv);
            }
            this.callPut(object, field, sv.substring(0, aInd), sv.substring(aInd + 1));
        }
    }

    private void callPut(Object object, Field field, String key, String value) {
        try {
            Method m = this.findPut(field.getType());
            m.invoke(field.get(object), key, value);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private Method findPut(Class<?> cls) throws SecurityException, NoSuchMethodException {
        return cls.getMethod("put", Object.class, Object.class);
    }

    public String getAssignment() {
        return this.m_dynamicParameter != null ? this.m_dynamicParameter.assignment() : "";
    }
}

