/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.deploy.log;

import com.zenjava.javafx.deploy.log.Log;

public abstract class AbstractLog
implements Log {
    private Log.LogLevel logLevel;

    public AbstractLog(Log.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public Log.LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Log.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void debug(String message, Object ... values) {
        this.log(Log.LogLevel.debug, message, values);
    }

    @Override
    public void info(String message, Object ... values) {
        this.log(Log.LogLevel.info, message, values);
    }

    @Override
    public void warn(String message, Object ... values) {
        this.log(Log.LogLevel.warn, message, values);
    }

    @Override
    public void error(String message, Object ... values) {
        this.log(Log.LogLevel.error, message, values);
    }

    @Override
    public void exception(String message, Throwable error, Object ... values) {
        this.log(Log.LogLevel.error, message, values);
    }

    protected boolean isLogLevelSet(Log.LogLevel level) {
        return this.logLevel.ordinal() >= level.ordinal();
    }

    protected void log(Log.LogLevel level, String message, Object ... values) {
        if (this.isLogLevelSet(level)) {
            this.write(String.format(message, values));
        }
    }

    protected abstract void write(String var1);
}

