/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.HistogramWindow;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.StackWindow;
import ij.gui.YesNoCancelDialog;
import ij.io.FileSaver;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.frame.Channels;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;

public class ImageWindow
extends Frame
implements FocusListener,
WindowListener,
WindowStateListener,
MouseWheelListener {
    public static final int MIN_WIDTH = 128;
    public static final int MIN_HEIGHT = 32;
    protected ImagePlus imp;
    protected ImageJ ij;
    protected ImageCanvas ic;
    private double initialMagnification = 1.0;
    private int newWidth;
    private int newHeight;
    protected boolean closed;
    private boolean newCanvas;
    private boolean unzoomWhenMinimizing = true;
    Rectangle maxWindowBounds;
    Rectangle maxBounds;
    long setMaxBoundsTime;
    private static final int XINC = 8;
    private static final int YINC = 12;
    private static final int TEXT_GAP = 10;
    private static int xbase = -1;
    private static int ybase;
    private static int xloc;
    private static int yloc;
    private static int count;
    private static boolean centerOnScreen;
    private static Point nextLocation;
    private int textGap;
    public boolean running;
    public boolean running2;

    public ImageWindow(String string) {
        super(string);
        this.textGap = centerOnScreen ? 0 : 10;
    }

    public ImageWindow(ImagePlus imagePlus) {
        this(imagePlus, null);
    }

    public ImageWindow(ImagePlus imagePlus, ImageCanvas imageCanvas) {
        super(imagePlus.getTitle());
        int n = this.textGap = centerOnScreen ? 0 : 10;
        if (Prefs.blackCanvas && this.getClass().getName().equals("ij.gui.ImageWindow")) {
            this.setForeground(Color.white);
            this.setBackground(Color.black);
        } else {
            this.setForeground(Color.black);
            if (IJ.isLinux()) {
                this.setBackground(ImageJ.backgroundColor);
            } else {
                this.setBackground(Color.white);
            }
        }
        this.ij = IJ.getInstance();
        this.imp = imagePlus;
        if (imageCanvas == null) {
            imageCanvas = new ImageCanvas(imagePlus);
            this.newCanvas = true;
        }
        this.ic = imageCanvas;
        ImageWindow imageWindow = imagePlus.getWindow();
        this.setLayout(new ImageLayout(imageCanvas));
        this.add(imageCanvas);
        this.addFocusListener(this);
        this.addWindowListener(this);
        this.addWindowStateListener(this);
        this.addKeyListener(this.ij);
        this.setFocusTraversalKeysEnabled(false);
        if (!(this instanceof StackWindow)) {
            this.addMouseWheelListener(this);
        }
        this.setResizable(true);
        WindowManager.addWindow(this);
        imagePlus.setWindow(this);
        if (imageWindow != null) {
            if (this.newCanvas) {
                this.setLocationAndSize(false);
            } else {
                imageCanvas.update(imageWindow.getCanvas());
            }
            Point point = imageWindow.getLocation();
            this.setLocation(point.x, point.y);
            if (!(this instanceof StackWindow)) {
                this.pack();
                this.show();
            }
            if (imageCanvas.getMagnification() != 0.0) {
                imagePlus.setTitle(imagePlus.getTitle());
            }
            boolean bl = imagePlus.lockSilently();
            boolean bl2 = imagePlus.changes;
            imagePlus.changes = false;
            imageWindow.close();
            imagePlus.changes = bl2;
            if (bl) {
                imagePlus.unlock();
            }
            WindowManager.setCurrentWindow(this);
        } else {
            Image image;
            this.setLocationAndSize(false);
            if (this.ij != null && !IJ.isMacintosh() && (image = this.ij.getIconImage()) != null) {
                try {
                    this.setIconImage(image);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (centerOnScreen) {
                GUI.center(this);
                centerOnScreen = false;
            } else if (nextLocation != null) {
                this.setLocation(nextLocation);
                nextLocation = null;
            }
            if (Interpreter.isBatchMode() || IJ.getInstance() == null && this instanceof HistogramWindow) {
                WindowManager.setTempCurrentImage(imagePlus);
                Interpreter.addBatchModeImage(imagePlus);
            } else {
                this.show();
            }
        }
    }

    private void setLocationAndSize(boolean bl) {
        double d;
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        Rectangle rectangle = this.getMaxWindow(0, 0);
        if (WindowManager.getWindowCount() <= 1) {
            xbase = -1;
        }
        if (n > rectangle.width / 2 && xbase > rectangle.x + 5 + 48) {
            xbase = -1;
        }
        if (xbase == -1) {
            count = 0;
            xbase = rectangle.x + 5;
            if (n * 2 <= rectangle.width) {
                xbase = rectangle.x + rectangle.width / 2 - n / 2;
            }
            ybase = rectangle.y;
            xloc = xbase;
            yloc = ybase;
        }
        int n3 = xloc;
        int n4 = yloc;
        xloc += 8;
        yloc += 12;
        if (++count % 6 == 0) {
            xloc = xbase;
            yloc = ybase;
        }
        int n5 = this instanceof StackWindow ? 20 : 0;
        int n6 = rectangle.y + rectangle.height - n5;
        double d2 = 1.0;
        while (((double)(xbase + 32) + (double)n * d2 > (double)(rectangle.x + rectangle.width) || (double)ybase + (double)n2 * d2 >= (double)n6) && (d = ImageCanvas.getLowerZoomLevel(d2)) != d2) {
            d2 = d;
        }
        if (d2 < 1.0) {
            this.initialMagnification = d2;
            this.ic.setDrawingSize((int)((double)n * d2), (int)((double)n2 * d2));
        }
        this.ic.setMagnification(d2);
        if ((double)n4 + (double)n2 * d2 > (double)n6) {
            n4 = ybase;
        }
        if (!bl) {
            this.setLocation(n3, n4);
        }
        if (Prefs.open100Percent && this.ic.getMagnification() < 1.0) {
            while (this.ic.getMagnification() < 1.0) {
                this.ic.zoomIn(0, 0);
            }
            this.setSize(Math.min(n, rectangle.width - n3), Math.min(n2, n6 - n4));
            this.validate();
        } else {
            this.pack();
        }
    }

    Rectangle getMaxWindow(int n, int n2) {
        Cloneable cloneable;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        if (IJ.debugMode) {
            IJ.log("getMaxWindow: " + rectangle + "  " + n + "," + n2);
        }
        if ((n > rectangle.x + rectangle.width || n2 > rectangle.y + rectangle.height) && (cloneable = this.getSecondaryMonitorBounds(graphicsEnvironment, n, n2)) != null) {
            return cloneable;
        }
        Cloneable cloneable2 = cloneable = this.ij != null ? this.ij.getSize() : new Dimension(0, 0);
        if (rectangle.height > 600) {
            rectangle.y += ((Dimension)cloneable).height;
            rectangle.height -= ((Dimension)cloneable).height;
        }
        return rectangle;
    }

    private Rectangle getSecondaryMonitorBounds(GraphicsEnvironment graphicsEnvironment, int n, int n2) {
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                Rectangle rectangle = graphicsConfigurationArray[j].getBounds();
                if (rectangle == null || !rectangle.contains(n, n2)) continue;
                return rectangle;
            }
        }
        return null;
    }

    public double getInitialMagnification() {
        return this.initialMagnification;
    }

    @Override
    public Insets getInsets() {
        int n;
        Insets insets = super.getInsets();
        double d = this.ic.getMagnification();
        int n2 = (int)((128.0 - (double)this.imp.getWidth() * d) / 2.0);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (int)((32.0 - (double)this.imp.getHeight() * d) / 2.0)) < 0) {
            n = 0;
        }
        insets = new Insets(insets.top + this.textGap + n, insets.left + n2, insets.bottom + n, insets.right + n2);
        return insets;
    }

    public void drawInfo(Graphics graphics) {
        if (this.textGap != 0) {
            CompositeImage compositeImage;
            Insets insets = super.getInsets();
            if (this.imp.isComposite() && (compositeImage = (CompositeImage)this.imp).getMode() == 1) {
                graphics.setColor(compositeImage.getChannelColor());
            }
            graphics.drawString(this.createSubtitle(), insets.left + 5, insets.top + 10);
        }
    }

    public String createSubtitle() {
        int n;
        Object object;
        String string = "";
        int n2 = this.imp.getStackSize();
        if (n2 > 1) {
            object = this.imp.getStack();
            n = this.imp.getCurrentSlice();
            string = string + n + "/" + n2;
            String string2 = ((ImageStack)object).getShortSliceLabel(n);
            if (string2 != null && string2.length() > 0) {
                if (this.imp.isHyperStack()) {
                    string2 = string2.replace(';', ' ');
                }
                string = string + " (" + string2 + ")";
            }
            if (this instanceof StackWindow && this.running2) {
                return string;
            }
            string = string + "; ";
        } else {
            object = (String)this.imp.getProperty("Label");
            if (object != null) {
                int n3;
                n = ((String)object).indexOf(10);
                if (n > 0) {
                    object = ((String)object).substring(0, n);
                }
                if ((n3 = ((String)object).length()) > 4 && ((String)object).charAt(n3 - 4) == '.' && !Character.isDigit(((String)object).charAt(n3 - 1))) {
                    object = ((String)object).substring(0, n3 - 4);
                }
                if (((String)object).length() > 60) {
                    object = ((String)object).substring(0, 60);
                }
                string = (String)object + "; ";
            }
        }
        int n4 = this.imp.getType();
        Calibration calibration = this.imp.getCalibration();
        string = calibration.scaled() ? string + IJ.d2s((double)this.imp.getWidth() * calibration.pixelWidth, 2) + "x" + IJ.d2s((double)this.imp.getHeight() * calibration.pixelHeight, 2) + " " + calibration.getUnits() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); " : string + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        double d = (double)this.imp.getWidth() * (double)this.imp.getHeight() * (double)this.imp.getStackSize() / 1024.0;
        switch (n4) {
            case 0: 
            case 3: {
                string = string + "8-bit";
                break;
            }
            case 1: {
                string = string + "16-bit";
                d *= 2.0;
                break;
            }
            case 2: {
                string = string + "32-bit";
                d *= 4.0;
                break;
            }
            case 4: {
                string = string + "RGB";
                d *= 4.0;
            }
        }
        if (this.imp.isInvertedLut()) {
            string = string + " (inverting LUT)";
        }
        String string3 = null;
        String string4 = null;
        if (d < 1024.0) {
            string3 = IJ.d2s(d, 0);
            string4 = "K";
        } else if (d < 10000.0) {
            string3 = IJ.d2s(d / 1024.0, 1);
            string4 = "MB";
        } else if (d < 1048576.0) {
            string3 = IJ.d2s(Math.round(d / 1024.0), 0);
            string4 = "MB";
        } else {
            string3 = IJ.d2s(d / 1048576.0, 1);
            string4 = "GB";
        }
        if (string3.endsWith(".0")) {
            string3 = string3.substring(0, string3.length() - 2);
        }
        return string + "; " + string3 + string4;
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawInfo(graphics);
        Rectangle rectangle = this.ic.getBounds();
        int n = 128 - rectangle.width;
        int n2 = 32 - rectangle.height;
        if (n <= 0 && n2 <= 0 && !Prefs.noBorder && !IJ.isLinux()) {
            graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
        }
    }

    public boolean close() {
        boolean bl;
        boolean bl2 = this.running || this.running2;
        this.running2 = false;
        this.running = false;
        boolean bl3 = bl = this.imp.getStackSize() > 1 && this.imp.getStack().isVirtual();
        if (bl2) {
            IJ.wait(500);
        }
        if (this.ij == null || IJ.getApplet() != null || Interpreter.isBatchMode() || IJ.macroRunning() || bl) {
            this.imp.changes = false;
        }
        if (this.imp.changes) {
            FileSaver fileSaver;
            String string = this.imp.getTitle();
            String string2 = string.length() > 22 ? "Save changes to\n\"" + string + "\"?" : "Save changes to \"" + string + "\"?";
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, "ImageJ", string2);
            if (yesNoCancelDialog.cancelPressed()) {
                return false;
            }
            if (yesNoCancelDialog.yesPressed() && !(fileSaver = new FileSaver(this.imp)).save()) {
                return false;
            }
        }
        this.closed = true;
        if (WindowManager.getWindowCount() == 0) {
            xloc = 0;
            yloc = 0;
        }
        WindowManager.removeWindow(this);
        if (this.ij != null && this.ij.quitting()) {
            return true;
        }
        this.dispose();
        if (this.imp != null) {
            this.imp.flush();
        }
        this.imp = null;
        return true;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    public void setImage(ImagePlus imagePlus) {
        ImageCanvas imageCanvas = this.getCanvas();
        if (imageCanvas == null || imagePlus == null) {
            return;
        }
        this.imp = imagePlus;
        this.imp.setWindow(this);
        imageCanvas.updateImage(this.imp);
        imageCanvas.setImageUpdated();
        imageCanvas.repaint();
        this.repaint();
    }

    public void updateImage(ImagePlus imagePlus) {
        if (imagePlus != this.imp) {
            throw new IllegalArgumentException("imp!=this.imp");
        }
        this.imp = imagePlus;
        this.ic.updateImage(imagePlus);
        this.setLocationAndSize(true);
        if (this instanceof StackWindow) {
            StackWindow stackWindow = (StackWindow)this;
            int n = imagePlus.getStackSize();
            int n2 = stackWindow.getNScrollbars();
            if (n == 1 && n2 > 0) {
                stackWindow.removeScrollbars();
            } else if (n > 1 && n2 == 0) {
                stackWindow.addScrollbars(imagePlus);
            }
        }
        this.pack();
        this.repaint();
        this.maxBounds = this.getMaximumBounds();
        this.setMaximizedBounds(this.maxBounds);
        this.setMaxBoundsTime = System.currentTimeMillis();
    }

    public ImageCanvas getCanvas() {
        return this.ic;
    }

    static ImagePlus getClipboard() {
        return ImagePlus.getClipboard();
    }

    public Rectangle getMaximumBounds() {
        int n;
        int n2;
        Rectangle rectangle;
        double d = this.imp.getWidth();
        double d2 = this.imp.getHeight();
        double d3 = d / d2;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.maxWindowBounds = rectangle = graphicsEnvironment.getMaximumWindowBounds();
        if (d3 / ((double)rectangle.width / (double)rectangle.height) > 0.75) {
            rectangle.y += 22;
            rectangle.height -= 22;
        }
        Dimension dimension = this.getExtraSize();
        double d4 = rectangle.width - dimension.width;
        double d5 = rectangle.height - dimension.height;
        double d6 = d4 / d5;
        if (d3 >= d6) {
            double d7 = d4 / d;
            n2 = rectangle.width;
            n = (int)(d2 * d7 + (double)dimension.height);
        } else {
            double d8 = d5 / d2;
            n = rectangle.height;
            n2 = (int)(d * d8 + (double)dimension.width);
        }
        int n3 = (int)(d4 - (double)n2) / 2;
        if (n3 < 0) {
            n3 = 0;
        }
        return new Rectangle(n3, rectangle.y, n2, n);
    }

    Dimension getExtraSize() {
        Insets insets = this.getInsets();
        int n = insets.left + insets.right + 10;
        int n2 = insets.top + insets.bottom + 10;
        if (n2 == 20) {
            n2 = 42;
        }
        int n3 = this.getComponentCount();
        for (int i = 1; i < n3; ++i) {
            Component component = this.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            n2 += dimension.height + 5;
            if (!IJ.debugMode) continue;
            IJ.log(i + "  " + dimension.height + " " + n2);
        }
        return new Dimension(n, n2);
    }

    @Override
    public Component add(Component component) {
        component = super.add(component);
        this.maxBounds = this.getMaximumBounds();
        this.setMaximizedBounds(this.maxBounds);
        this.setMaxBoundsTime = System.currentTimeMillis();
        return component;
    }

    public void maximize() {
        if (this.maxBounds == null) {
            return;
        }
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        double d = (double)n / (double)n2;
        Dimension dimension = this.getExtraSize();
        int n3 = dimension.height;
        double d2 = (double)(this.maxBounds.height - n3) / (double)n2;
        if (IJ.debugMode) {
            IJ.log("maximize: " + d2 + " " + this.ic.getMagnification() + " " + this.maxBounds);
        }
        this.setSize(this.getMaximizedBounds().width, this.getMaximizedBounds().height);
        if (d2 > this.ic.getMagnification() || d < 0.5 || d > 2.0) {
            this.ic.setMagnification2(d2);
            this.ic.setSrcRect(new Rectangle(0, 0, n, n2));
            this.ic.setDrawingSize((int)((double)n * d2), (int)((double)n2 * d2));
            this.validate();
            this.unzoomWhenMinimizing = true;
        } else {
            this.unzoomWhenMinimizing = false;
        }
    }

    public void minimize() {
        if (this.unzoomWhenMinimizing) {
            this.ic.unzoom();
        }
        this.unzoomWhenMinimizing = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!Interpreter.isBatchMode() && this.ij != null && !this.ij.quitting()) {
            WindowManager.setCurrentWindow(this);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        Frame frame;
        ImageJ imageJ;
        boolean bl;
        if (IJ.debugMode) {
            IJ.log("windowActivated: " + this.imp.getTitle());
        }
        boolean bl2 = bl = (imageJ = IJ.getInstance()) != null && imageJ.quitting();
        if (IJ.isMacintosh() && imageJ != null && !bl) {
            IJ.wait(10);
            this.setMenuBar(Menus.getMenuBar());
        }
        this.imp.setActivated();
        if (!(this.closed || bl || Interpreter.isBatchMode())) {
            WindowManager.setCurrentWindow(this);
        }
        if ((frame = Channels.getInstance()) != null && this.imp.isComposite()) {
            ((Channels)frame).update();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.closed) {
            return;
        }
        if (this.ij != null) {
            WindowManager.setCurrentWindow(this);
            IJ.doCommand("Close");
        } else {
            this.dispose();
            WindowManager.removeWindow(this);
        }
    }

    @Override
    public void windowStateChanged(WindowEvent windowEvent) {
        int n = windowEvent.getOldState();
        int n2 = windowEvent.getNewState();
        if ((n & 6) == 0 && (n2 & 6) != 0) {
            this.maximize();
        } else if ((n & 6) != 0 && (n2 & 6) == 0) {
            this.minimize();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        int n2 = this.imp.getWidth();
        int n3 = this.imp.getHeight();
        Rectangle rectangle = this.ic.getSrcRect();
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        if (IJ.spaceBarDown() || rectangle.height == n3) {
            rectangle.x += n * Math.max(n2 / 200, 1);
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.x + rectangle.width > n2) {
                rectangle.x = n2 - rectangle.width;
            }
        } else {
            rectangle.y += n * Math.max(n3 / 200, 1);
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            if (rectangle.y + rectangle.height > n3) {
                rectangle.y = n3 - rectangle.height;
            }
        }
        if (rectangle.x != n4 || rectangle.y != n5) {
            this.ic.repaint();
        }
    }

    public void copy(boolean bl) {
        this.imp.copy(bl);
    }

    public void paste() {
        this.imp.paste();
    }

    public void mouseMoved(int n, int n2) {
        this.imp.mouseMoved(n, n2);
    }

    @Override
    public String toString() {
        return this.imp != null ? this.imp.getTitle() : "";
    }

    public static void centerNextImage() {
        centerOnScreen = true;
    }

    public static void setNextLocation(Point point) {
        nextLocation = point;
    }

    public void setLocationAndSize(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
        this.getCanvas().fitToWindow();
        this.pack();
    }
}

