/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    String[] lines;
    int num_lines;
    int margin_width = 6;
    int margin_height = 6;
    int line_height;
    int line_ascent;
    int[] line_widths;
    int min_width;
    int max_width;

    public MultiLineLabel(String string) {
        this(string, 0);
    }

    public MultiLineLabel(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.num_lines = stringTokenizer.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        for (int i = 0; i < this.num_lines; ++i) {
            this.lines[i] = stringTokenizer.nextToken();
        }
        this.min_width = n;
    }

    protected void measure() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.line_height = fontMetrics.getHeight();
        this.line_ascent = fontMetrics.getAscent();
        this.max_width = 0;
        for (int i = 0; i < this.num_lines; ++i) {
            this.line_widths[i] = fontMetrics.stringWidth(this.lines[i]);
            if (this.line_widths[i] <= this.max_width) continue;
            this.max_width = this.line_widths[i];
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Math.max(this.min_width, this.max_width + 2 * this.margin_width), this.num_lines * this.line_height + 2 * this.margin_height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(Math.max(this.min_width, this.max_width), this.num_lines * this.line_height);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (!IJ.isLinux()) {
            this.setAntialiasedText(graphics);
        }
        int n = this.line_ascent + (dimension.height - this.num_lines * this.line_height) / 2;
        int n2 = 0;
        while (n2 < this.num_lines) {
            int n3 = this.margin_width;
            graphics.drawString(this.lines[n2], n3, n);
            ++n2;
            n += this.line_height;
        }
    }

    void setAntialiasedText(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

