/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.Properties;

public class NewImage {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int RGB = 3;
    public static final int FILL_BLACK = 1;
    public static final int FILL_RAMP = 2;
    public static final int FILL_WHITE = 4;
    public static final int CHECK_AVAILABLE_MEMORY = 8;
    private static final int OLD_FILL_WHITE = 0;
    static final String TYPE = "new.type";
    static final String FILL = "new.fill";
    static final String WIDTH = "new.width";
    static final String HEIGHT = "new.height";
    static final String SLICES = "new.slices";
    private static String name = "Untitled";
    private static int width = Prefs.getInt("new.width", 400);
    private static int height = Prefs.getInt("new.height", 400);
    private static int slices = Prefs.getInt("new.slices", 1);
    private static int type = Prefs.getInt("new.type", 0);
    private static int fillWith = Prefs.getInt("new.fill", 0);
    private static String[] types = new String[]{"8-bit", "16-bit", "32-bit", "RGB"};
    private static String[] fill = new String[]{"White", "Black", "Ramp"};

    public NewImage() {
        this.openImage();
    }

    static boolean createStack(ImagePlus imagePlus, ImageProcessor imageProcessor, int n, int n2, int n3) {
        long l;
        int n4 = NewImage.getFill(n3);
        int n5 = imagePlus.getWidth();
        int n6 = imagePlus.getHeight();
        long l2 = 1L;
        if (n2 == 1) {
            l2 = 2L;
        } else if (n2 == 2 || n2 == 3) {
            l2 = 4L;
        }
        long l3 = (long)n5 * (long)n6 * (long)n * l2;
        boolean bl = l3 / 0x100000L >= 50L;
        String string = l3 / 0x100000L + "MB (" + n5 + "x" + n6 + "x" + n + ")";
        if ((n3 & 8) != 0 && (l = IJ.maxMemory()) > 0L) {
            long l4 = IJ.currentMemory();
            long l5 = l - l4;
            if (l3 > l5) {
                System.gc();
            }
            if (l3 > (l5 = l - (l4 = IJ.currentMemory()))) {
                IJ.error("Insufficient Memory", "There is not enough free memory to allocate a \n" + string + " stack.\n \n" + "Memory available: " + l5 / 0x100000L + "MB\n" + "Memory in use: " + IJ.freeMemory() + "\n \n" + "More information can be found in the \"Memory\"\n" + "sections of the ImageJ installation notes at\n" + "\"" + "http://imagej.nih.gov/ij" + "/docs/install/\".");
                return false;
            }
        }
        ImageStack imageStack = imagePlus.createEmptyStack();
        int n7 = n / 40;
        if (n7 < 1) {
            n7 = 1;
        }
        IJ.showStatus("Allocating " + string + ". Press 'Esc' to abort.");
        IJ.resetEscape();
        try {
            imageStack.addSlice(null, imageProcessor);
            for (int i = 2; i <= n; ++i) {
                if (i % n7 == 0 && bl) {
                    IJ.showProgress(i, n);
                }
                Object[] objectArray = null;
                switch (n2) {
                    case 0: {
                        objectArray = new byte[n5 * n6];
                        break;
                    }
                    case 1: {
                        objectArray = new short[n5 * n6];
                        break;
                    }
                    case 2: {
                        objectArray = new float[n5 * n6];
                        break;
                    }
                    case 3: {
                        objectArray = new int[n5 * n6];
                    }
                }
                if (n4 != 1 || n2 == 3) {
                    System.arraycopy(imageProcessor.getPixels(), 0, objectArray, 0, n5 * n6);
                }
                imageStack.addSlice(null, objectArray);
                if (!IJ.escapePressed()) continue;
                IJ.beep();
                break;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory(imagePlus.getTitle());
            imageStack.trim();
        }
        if (bl) {
            IJ.showProgress(n, n);
        }
        if (imageStack.getSize() > 1) {
            imagePlus.setStack(null, imageStack);
        }
        return true;
    }

    static ImagePlus createImagePlus() {
        return new ImagePlus();
    }

    static int getFill(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            n2 = 4;
        }
        if (n2 == 7 || n2 == 6 || n2 == 3 || n2 == 5) {
            n2 = 1;
        }
        return n2;
    }

    public static ImagePlus createByteImage(String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = NewImage.getFill(n4);
        int n7 = NewImage.getSize(n, n2);
        if (n7 < 0) {
            return null;
        }
        byte[] byArray = new byte[n7];
        switch (n6) {
            case 4: {
                for (int i = 0; i < n * n2; ++i) {
                    byArray[i] = -1;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                int n8;
                byte[] byArray2 = new byte[n];
                for (n8 = 0; n8 < n; ++n8) {
                    byArray2[n8] = (byte)((double)n8 * 256.0 / (double)n);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    n8 = n5 * n;
                    for (int i = 0; i < n; ++i) {
                        byArray[n8++] = byArray2[i];
                    }
                }
                break;
            }
        }
        ByteProcessor byteProcessor = new ByteProcessor(n, n2, byArray, null);
        ImagePlus imagePlus = NewImage.createImagePlus();
        imagePlus.setProcessor(string, byteProcessor);
        if (n3 > 1 && (n5 = (int)(NewImage.createStack(imagePlus, byteProcessor, n3, 0, n4) ? 1 : 0)) == 0) {
            imagePlus = null;
        }
        return imagePlus;
    }

    public static ImagePlus createRGBImage(String string, int n, int n2, int n3, int n4) {
        byte by;
        int n5 = NewImage.getFill(n4);
        int n6 = NewImage.getSize(n, n2);
        if (n6 < 0) {
            return null;
        }
        int[] nArray = new int[n6];
        switch (n5) {
            case 4: {
                int n7;
                for (n7 = 0; n7 < n * n2; ++n7) {
                    nArray[n7] = -1;
                }
                break;
            }
            case 1: {
                int n7;
                for (n7 = 0; n7 < n * n2; ++n7) {
                    nArray[n7] = -16777216;
                }
                break;
            }
            case 2: {
                int n8;
                int n7;
                int[] nArray2 = new int[n];
                for (n8 = 0; n8 < n; ++n8) {
                    byte by2 = by = (byte)((double)n8 * 256.0 / (double)n);
                    n7 = by;
                    nArray2[n8] = 0xFF000000 | n7 << 16 & 0xFF0000 | by2 << 8 & 0xFF00 | by & 0xFF;
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    int n9 = n8 * n;
                    for (int i = 0; i < n; ++i) {
                        nArray[n9++] = nArray2[i];
                    }
                }
                break;
            }
        }
        ColorProcessor colorProcessor = new ColorProcessor(n, n2, nArray);
        ImagePlus imagePlus = NewImage.createImagePlus();
        imagePlus.setProcessor(string, colorProcessor);
        if (n3 > 1 && (by = (byte)(NewImage.createStack(imagePlus, colorProcessor, n3, 3, n4) ? 1 : 0)) == 0) {
            imagePlus = null;
        }
        return imagePlus;
    }

    public static ImagePlus createShortImage(String string, int n, int n2, int n3, int n4) {
        int n5;
        Object object;
        int n6 = NewImage.getFill(n4);
        int n7 = NewImage.getSize(n, n2);
        if (n7 < 0) {
            return null;
        }
        short[] sArray = new short[n7];
        switch (n6) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                int n8;
                object = new short[n];
                for (n8 = 0; n8 < n; ++n8) {
                    object[n8] = (short)((double)n8 * 65536.0 / (double)n + 0.5);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    n8 = n5 * n;
                    for (int i = 0; i < n; ++i) {
                        sArray[n8++] = (short)object[i];
                    }
                }
                break;
            }
        }
        object = new ShortProcessor(n, n2, sArray, null);
        if (n6 == 4) {
            ((ImageProcessor)object).invertLut();
        }
        ImagePlus imagePlus = NewImage.createImagePlus();
        imagePlus.setProcessor(string, (ImageProcessor)object);
        if (n3 > 1 && (n5 = (int)(NewImage.createStack(imagePlus, (ImageProcessor)object, n3, 1, n4) ? 1 : 0)) == 0) {
            imagePlus = null;
        }
        imagePlus.getProcessor().setMinAndMax(0.0, 65535.0);
        return imagePlus;
    }

    public static ImagePlus createUnsignedShortImage(String string, int n, int n2, int n3, int n4) {
        return NewImage.createShortImage(string, n, n2, n3, n4);
    }

    public static ImagePlus createFloatImage(String string, int n, int n2, int n3, int n4) {
        int n5;
        Object object;
        int n6 = NewImage.getFill(n4);
        int n7 = NewImage.getSize(n, n2);
        if (n7 < 0) {
            return null;
        }
        float[] fArray = new float[n7];
        switch (n6) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                int n8;
                object = new float[n];
                for (n8 = 0; n8 < n; ++n8) {
                    object[n8] = (float)((double)n8 * 1.0 / (double)n);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    n8 = n5 * n;
                    for (int i = 0; i < n; ++i) {
                        fArray[n8++] = (float)object[i];
                    }
                }
                break;
            }
        }
        object = new FloatProcessor(n, n2, fArray, null);
        if (n6 == 4) {
            ((ImageProcessor)object).invertLut();
        }
        ImagePlus imagePlus = NewImage.createImagePlus();
        imagePlus.setProcessor(string, (ImageProcessor)object);
        if (n3 > 1 && (n5 = (int)(NewImage.createStack(imagePlus, (ImageProcessor)object, n3, 2, n4) ? 1 : 0)) == 0) {
            imagePlus = null;
        }
        imagePlus.getProcessor().setMinAndMax(0.0, 1.0);
        return imagePlus;
    }

    private static int getSize(int n, int n2) {
        long l = (long)n * (long)n2;
        if (l > Integer.MAX_VALUE) {
            IJ.error("Image is too large. ImageJ does not support\nsingle images larger than 2 gigapixels.");
            return -1;
        }
        return (int)l;
    }

    public static void open(String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = 8;
        if (n4 == 1) {
            n6 = 16;
        } else if (n4 == 2) {
            n6 = 32;
        } else if (n4 == 3) {
            n6 = 24;
        }
        long l = System.currentTimeMillis();
        ImagePlus imagePlus = NewImage.createImage(string, n, n2, n3, n6, n5);
        if (imagePlus != null) {
            WindowManager.checkForDuplicateName = true;
            imagePlus.show();
            IJ.showStatus(IJ.d2s((double)(System.currentTimeMillis() - l) / 1000.0, 2) + " seconds");
        }
    }

    public static ImagePlus createImage(String string, int n, int n2, int n3, int n4, int n5) {
        ImagePlus imagePlus = null;
        switch (n4) {
            case 8: {
                imagePlus = NewImage.createByteImage(string, n, n2, n3, n5);
                break;
            }
            case 16: {
                imagePlus = NewImage.createShortImage(string, n, n2, n3, n5);
                break;
            }
            case 32: {
                imagePlus = NewImage.createFloatImage(string, n, n2, n3, n5);
                break;
            }
            case 24: {
                imagePlus = NewImage.createRGBImage(string, n, n2, n3, n5);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bitDepth: " + n4);
            }
        }
        return imagePlus;
    }

    boolean showDialog() {
        if (type < 0 || type > 3) {
            type = 0;
        }
        if (fillWith < 0 || fillWith > 2) {
            fillWith = 0;
        }
        GenericDialog genericDialog = new GenericDialog("New Image...", IJ.getInstance());
        genericDialog.addStringField("Name:", name, 12);
        genericDialog.addChoice("Type:", types, types[type]);
        genericDialog.addChoice("Fill With:", fill, fill[fillWith]);
        genericDialog.addNumericField("Width:", width, 0, 5, "pixels");
        genericDialog.addNumericField("Height:", height, 0, 5, "pixels");
        genericDialog.addNumericField("Slices:", slices, 0, 5, "");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        name = genericDialog.getNextString();
        String string = genericDialog.getNextChoice();
        type = string.startsWith("8") ? 0 : (string.startsWith("16") ? 1 : (string.endsWith("RGB") || string.endsWith("rgb") ? 3 : 2));
        fillWith = genericDialog.getNextChoiceIndex();
        width = (int)genericDialog.getNextNumber();
        height = (int)genericDialog.getNextNumber();
        slices = (int)genericDialog.getNextNumber();
        if (slices < 1) {
            slices = 1;
        }
        if (width < 1 || height < 1) {
            IJ.error("New Image", "Width and height must be >0");
            return false;
        }
        return true;
    }

    void openImage() {
        if (!this.showDialog()) {
            return;
        }
        try {
            NewImage.open(name, width, height, slices, type, fillWith);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("New Image...");
        }
    }

    public static void savePreferences(Properties properties) {
        properties.put(TYPE, Integer.toString(type));
        properties.put(FILL, Integer.toString(fillWith));
        properties.put(WIDTH, Integer.toString(width));
        properties.put(HEIGHT, Integer.toString(height));
        properties.put(SLICES, Integer.toString(slices));
    }
}

