/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner,
MouseListener,
MouseMotionListener,
KeyListener,
ImageListener,
Runnable {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int LINE = 2;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String MIN = "pp.min";
    private static final String MAX = "pp.max";
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private static final int LIST_VALUES = 4;
    private static final int INTERPOLATE = 8;
    private static final int NO_GRID_LINES = 16;
    private Button list;
    private Button save;
    private Button copy;
    private Button live;
    private Label coordinates;
    private static String defaultDirectory = null;
    private static int options;
    private int defaultDigits = -1;
    private int markSize = 5;
    private static Plot staticPlot;
    private Plot plot;
    private String blankLabel = "                      ";
    private ImagePlus srcImp;
    private Thread bgThread;
    private boolean doUpdate;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    public static boolean listValues;
    public static boolean interpolate;
    public static boolean noGridLines;

    public PlotWindow(String string, String string2, String string3, float[] fArray, float[] fArray2) {
        super(PlotWindow.createImage(string, string2, string3, fArray, fArray2));
        this.plot = staticPlot;
    }

    public PlotWindow(String string, String string2, String string3, double[] dArray, double[] dArray2) {
        this(string, string2, string3, Tools.toFloat(dArray), Tools.toFloat(dArray2));
    }

    PlotWindow(Plot plot) {
        super(plot.getImagePlus());
        this.plot = plot;
        this.draw();
    }

    static ImagePlus createImage(String string, String string2, String string3, float[] fArray, float[] fArray2) {
        staticPlot = new Plot(string, string2, string3, fArray, fArray2);
        return new ImagePlus(string, staticPlot.getBlankProcessor());
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        this.plot.setLimits(d, d2, d3, d4);
    }

    public void addPoints(float[] fArray, float[] fArray2, int n) {
        this.plot.addPoints(fArray, fArray2, n);
    }

    public void addPoints(double[] dArray, double[] dArray2, int n) {
        this.addPoints(Tools.toFloat(dArray), Tools.toFloat(dArray2), n);
    }

    public void addErrorBars(float[] fArray) {
        this.plot.addErrorBars(fArray);
    }

    public void addLabel(double d, double d2, String string) {
        this.plot.addLabel(d, d2, string);
    }

    public void setColor(Color color) {
        this.plot.setColor(color);
    }

    public void setLineWidth(int n) {
        this.plot.setLineWidth(n);
    }

    public void changeFont(Font font) {
        this.plot.changeFont(font);
    }

    public void draw() {
        Panel panel = new Panel();
        int n = IJ.isMacOSX() ? 1 : 5;
        panel.setLayout(new FlowLayout(2, n, 0));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        panel.add(this.list);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        panel.add(this.save);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        panel.add(this.copy);
        this.live = new Button("Live");
        this.live.addActionListener(this);
        panel.add(this.live);
        this.coordinates = new Label("X=12345678, Y=12345678");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        this.coordinates.setBackground(new Color(220, 220, 220));
        panel.add(this.coordinates);
        this.add(panel);
        this.plot.draw();
        this.pack();
        this.coordinates.setText(this.blankLabel);
        ImageProcessor imageProcessor = this.plot.getProcessor();
        if (imageProcessor instanceof ColorProcessor && this.imp.getProcessor() instanceof ByteProcessor) {
            this.imp.setProcessor(null, imageProcessor);
        } else {
            this.imp.updateAndDraw();
        }
        if (listValues) {
            this.showList();
        }
    }

    int getDigits(double d, double d2) {
        if ((double)Math.round(d) == d && (double)Math.round(d2) == d2) {
            return 0;
        }
        double d3 = (d = Math.abs(d)) < (d2 = Math.abs(d2)) && d > 0.0 ? d : d2;
        double d4 = Math.abs(d2 - d);
        if (d4 > 0.0 && d4 < d3) {
            d3 = d4;
        }
        int n = 1;
        if (d3 < 10.0) {
            n = 2;
        }
        if (d3 < 0.01) {
            n = 3;
        }
        if (d3 < 0.001) {
            n = 4;
        }
        if (d3 < 1.0E-4) {
            n = 5;
        }
        return n;
    }

    @Override
    public void mouseMoved(int n, int n2) {
        super.mouseMoved(n, n2);
        if (this.plot != null && this.plot.frame != null && this.coordinates != null) {
            String string = this.plot.getCoordinates(n, n2) + this.blankLabel;
            this.coordinates.setText(string.substring(0, this.blankLabel.length()));
        }
    }

    void showList() {
        String string = this.createHeading();
        String string2 = this.createData();
        TextWindow textWindow = new TextWindow("Plot Values", string, string2, 230, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    private String createHeading() {
        String string = "";
        int n = this.plot.storedData.size() / 2;
        string = saveXValues || n > 1 ? string + (n == 1 ? "X\tY\t" : "X0\tY0\t") : string + (n == 1 ? "Y0\t" : "Y0\t");
        if (this.plot.errorBars != null) {
            string = string + "ERR\t";
        }
        for (int i = 1; i < n; ++i) {
            string = saveXValues || n > 1 ? string + "X" + i + "\tY" + i + "\t" : string + "Y" + i + "\t";
        }
        return string;
    }

    private String createData() {
        int n;
        float[] fArray;
        int n2 = 0;
        for (int i = 0; i < this.plot.storedData.size(); i += 2) {
            fArray = (float[])this.plot.storedData.get(i);
            n = fArray.length;
            n2 = n > n2 ? n : n2;
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>(this.plot.storedData);
        n = 0;
        if (this.plot.errorBars != null) {
            arrayList.add(2, this.plot.errorBars);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            n = this.plot.errorBars != null ? 1 : 0;
            int n4 = 0;
            while (n4 < n3) {
                String string;
                int n5 = 0;
                if (saveXValues || n3 > 2) {
                    fArray = (float[])arrayList.get(n4);
                    n5 = this.getPrecision(fArray);
                    string = i < fArray.length ? IJ.d2s(fArray[i], n5) : "";
                    stringBuffer.append(string);
                    stringBuffer.append("\t");
                }
                fArray = (float[])arrayList.get(++n4);
                int n6 = n5;
                if (n6 == 0) {
                    n6 = this.getPrecision(fArray);
                }
                string = i < fArray.length ? IJ.d2s(fArray[i], n6) : "";
                stringBuffer.append(string);
                stringBuffer.append("\t");
                ++n4;
                if (n == 0) continue;
                fArray = (float[])arrayList.get(n4);
                string = i < fArray.length ? IJ.d2s(fArray[i], n6) : "";
                stringBuffer.append(string);
                stringBuffer.append("\t");
                ++n4;
                n = 0;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    void saveAsText() {
        SaveDialog saveDialog = new SaveDialog("Save as Text", "Values", ".txt");
        String string = saveDialog.getFileName();
        if (string == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2 + string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter(bufferedOutputStream);
        }
        catch (IOException iOException) {
            IJ.error("" + iOException);
            return;
        }
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        printWriter.print(this.createData());
        printWriter.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        int n;
        Clipboard clipboard = null;
        try {
            clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            clipboard = null;
        }
        if (clipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        int n2 = 0;
        if (saveXValues) {
            n2 = this.getPrecision(this.plot.xValues);
        }
        if ((n = n2) == 0) {
            n = this.getPrecision(this.plot.yValues);
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.plot.nPoints * 4);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        for (int i = 0; i < this.plot.nPoints; ++i) {
            if (saveXValues) {
                printWriter.print(IJ.d2s(this.plot.xValues[i], n2) + "\t" + IJ.d2s(this.plot.yValues[i], n) + "\n");
                continue;
            }
            printWriter.print(IJ.d2s(this.plot.yValues[i], n) + "\n");
        }
        String string = charArrayWriter.toString();
        printWriter.close();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
        IJ.showStatus(string.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    int getPrecision(float[] fArray) {
        int n = Analyzer.getPrecision();
        int n2 = Analyzer.getMeasurements();
        boolean bl = (n2 & 0x200000) != 0;
        int n3 = 4;
        if (bl) {
            if (n < n3) {
                n = n3;
            }
            return -n;
        }
        int n4 = n3;
        if (n > n4) {
            n4 = n;
        }
        boolean bl2 = false;
        for (int i = 0; i < fArray.length; ++i) {
            if ((float)((int)fArray[i]) == fArray[i]) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            n4 = 0;
        }
        return n4;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.live) {
            this.toggleLiveProfiling();
        } else if (object == this.list) {
            this.showList();
        } else if (object == this.save) {
            this.saveAsText();
        } else {
            this.copyToClipboard();
        }
    }

    public float[] getXValues() {
        return this.plot.xValues;
    }

    public float[] getYValues() {
        return this.plot.yValues;
    }

    public ResultsTable getResultsTable() {
        int n;
        int n2 = this.plot.storedData.size() / 2;
        int n3 = 0;
        for (int i = 0; i < this.plot.storedData.size(); i += 2) {
            float[] fArray = (float[])this.plot.storedData.get(i);
            n = fArray.length;
            if (fArray.length <= n3) continue;
            n3 = fArray.length;
        }
        ResultsTable resultsTable = new ResultsTable();
        for (int i = 0; i < n3; ++i) {
            resultsTable.incrementCounter();
            for (n = 0; n < n2; ++n) {
                float[] fArray = (float[])this.plot.storedData.get(n * 2);
                float[] fArray2 = (float[])this.plot.storedData.get(n * 2 + 1);
                if (i < fArray.length) {
                    resultsTable.addValue("x" + n, (double)fArray[i]);
                }
                if (i >= fArray2.length) continue;
                resultsTable.addValue("y" + n, (double)fArray2[i]);
            }
        }
        return resultsTable;
    }

    public void drawPlot(Plot plot) {
        this.plot = plot;
        this.imp.setProcessor(null, plot.getProcessor());
    }

    public static void savePreferences(Properties properties) {
        double d = ProfilePlot.getFixedMin();
        double d2 = ProfilePlot.getFixedMax();
        if ((d != 0.0 || d2 != 0.0) && d < d2) {
            properties.put(MIN, Double.toString(d));
            properties.put(MAX, Double.toString(d2));
        }
        if (plotWidth != 450 || plotHeight != 200) {
            properties.put(PLOT_WIDTH, Integer.toString(plotWidth));
            properties.put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int n = 0;
        if (saveXValues) {
            n |= 1;
        }
        if (autoClose && !listValues) {
            n |= 2;
        }
        if (listValues) {
            n |= 4;
        }
        if (!interpolate) {
            n |= 8;
        }
        if (noGridLines) {
            n |= 0x10;
        }
        properties.put(OPTIONS, Integer.toString(n));
    }

    private void toggleLiveProfiling() {
        boolean bl;
        boolean bl2 = bl = this.live.getForeground() == Color.red;
        if (bl) {
            this.removeListeners();
        } else {
            this.enableLiveProfiling();
        }
    }

    private void enableLiveProfiling() {
        if (this.plot != null && this.bgThread == null) {
            int n = this.plot.getSourceImageID();
            this.srcImp = WindowManager.getImage(n);
            if (this.srcImp == null) {
                return;
            }
            this.bgThread = new Thread((Runnable)this, "Live Profiler");
            this.bgThread.setPriority(Math.max(this.bgThread.getPriority() - 3, 1));
            this.bgThread.start();
            this.imageUpdated(this.srcImp);
        }
        this.createListeners();
        if (this.srcImp != null) {
            this.imageUpdated(this.srcImp);
        }
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.doUpdate = true;
        this.notify();
    }

    @Override
    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        this.doUpdate = true;
        this.notify();
    }

    @Override
    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        this.doUpdate = true;
        this.notify();
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        this.doUpdate = true;
        this.notify();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void imageOpened(ImagePlus imagePlus) {
    }

    @Override
    public synchronized void imageUpdated(ImagePlus imagePlus) {
        if (imagePlus == this.srcImp) {
            if (!this.isSelection()) {
                IJ.run(imagePlus, "Restore Selection", "");
            }
            this.doUpdate = true;
            this.notify();
        }
    }

    @Override
    public void imageClosed(ImagePlus imagePlus) {
        if (imagePlus == this.srcImp || imagePlus == this.imp) {
            if (this.bgThread != null) {
                this.bgThread.interrupt();
            }
            this.bgThread = null;
            this.removeListeners();
            this.srcImp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            IJ.wait(50);
            Plot plot = this.getProfilePlot();
            if (this.doUpdate && plot != null) {
                this.plot = plot;
                object = plot.getProcessor();
                if (object != null) {
                    this.imp.setProcessor(null, (ImageProcessor)object);
                }
            }
            object = this;
            synchronized (object) {
                if (this.doUpdate) {
                    this.doUpdate = false;
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        }
    }

    private void createListeners() {
        if (this.srcImp == null) {
            return;
        }
        ImageCanvas imageCanvas = this.srcImp.getCanvas();
        if (imageCanvas == null) {
            return;
        }
        imageCanvas.addMouseListener(this);
        imageCanvas.addMouseMotionListener(this);
        imageCanvas.addKeyListener(this);
        ImagePlus.addImageListener(this);
        Font font = this.live.getFont();
        this.live.setFont(new Font(font.getName(), 1, font.getSize()));
        this.live.setForeground(Color.red);
    }

    private void removeListeners() {
        if (this.srcImp == null) {
            return;
        }
        ImageCanvas imageCanvas = this.srcImp.getCanvas();
        imageCanvas.removeMouseListener(this);
        imageCanvas.removeMouseMotionListener(this);
        imageCanvas.removeKeyListener(this);
        ImagePlus.removeImageListener(this);
        Font font = this.live.getFont();
        this.live.setFont(new Font(font.getName(), 0, font.getSize()));
        this.live.setForeground(Color.black);
    }

    private boolean isSelection() {
        if (this.srcImp == null) {
            return false;
        }
        Roi roi = this.srcImp.getRoi();
        if (roi == null) {
            return false;
        }
        return roi.getType() == 5 || roi.getType() == 0;
    }

    private Plot getProfilePlot() {
        if (this.srcImp == null || !this.isSelection()) {
            return null;
        }
        Roi roi = this.srcImp.getRoi();
        if (roi == null) {
            return null;
        }
        if (!roi.isLine() && roi.getType() != 0) {
            return null;
        }
        boolean bl = Prefs.verticalProfile || IJ.altKeyDown();
        ProfilePlot profilePlot = new ProfilePlot(this.srcImp, bl);
        return profilePlot.getPlot();
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        listValues = (options & 4) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
        interpolate = (options & 8) == 0;
        noGridLines = (options & 0x10) != 0;
    }
}

