/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.Straightener;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Rectangle;

public class ProfilePlot {
    static final int MIN_WIDTH = 350;
    static final double ASPECT_RATIO = 0.5;
    private double min;
    private double max;
    private boolean minAndMaxCalculated;
    private static double fixedMin = Prefs.getDouble("pp.min", 0.0);
    private static double fixedMax = Prefs.getDouble("pp.max", 0.0);
    protected ImagePlus imp;
    protected double[] profile;
    protected double magnification;
    protected double xInc;
    protected String units;
    protected String yLabel;
    protected float[] xValues;

    public ProfilePlot() {
    }

    public ProfilePlot(ImagePlus imagePlus) {
        this(imagePlus, false);
    }

    public ProfilePlot(ImagePlus imagePlus, boolean bl) {
        int n;
        this.imp = imagePlus;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error("Profile Plot", "Selection required.");
            return;
        }
        int n2 = roi.getType();
        if (!roi.isLine() && n2 != 0) {
            IJ.error("Line or rectangular selection required.");
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        this.xInc = calibration.pixelWidth;
        this.units = calibration.getUnits();
        this.yLabel = calibration.getValueUnit();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        this.profile = n2 == 5 ? this.getStraightLineProfile(roi, calibration, imageProcessor) : (n2 == 6 || n2 == 7 ? ((n = Math.round(roi.getStrokeWidth())) == 1 ? this.getIrregularProfile(roi, imageProcessor, calibration) : this.getWideLineProfile(imagePlus, n)) : (bl ? this.getRowAverageProfile(roi.getBounds(), calibration, imageProcessor) : this.getColumnAverageProfile(roi.getBounds(), imageProcessor)));
        imageProcessor.setCalibrationTable(null);
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        this.magnification = imageCanvas != null ? imageCanvas.getMagnification() : 1.0;
    }

    public Dimension getPlotSize() {
        if (this.profile == null) {
            return null;
        }
        int n = (int)((double)this.profile.length * this.magnification);
        int n2 = (int)((double)n * 0.5);
        if (n < 350) {
            n = 350;
            n2 = (int)((double)n * 0.5);
        }
        Dimension dimension = IJ.getScreenSize();
        int n3 = Math.min(dimension.width - 200, 1000);
        if (n > n3) {
            n = n3;
            n2 = (int)((double)n * 0.5);
        }
        return new Dimension(n, n2);
    }

    public void createWindow() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        plot.setSourceImageID(this.imp.getID());
        plot.show();
    }

    Plot getPlot() {
        int n;
        if (this.profile == null) {
            return null;
        }
        Dimension dimension = this.getPlotSize();
        String string = "Distance (" + this.units + ")";
        int n2 = this.profile.length;
        if (this.xValues == null) {
            this.xValues = new float[n2];
            for (int i = 0; i < n2; ++i) {
                this.xValues[i] = (float)((double)i * this.xInc);
            }
        }
        float[] fArray = new float[n2];
        for (n = 0; n < n2; ++n) {
            fArray[n] = (float)this.profile[n];
        }
        n = fixedMin != 0.0 || fixedMax != 0.0 ? 1 : 0;
        Plot plot = new Plot("Plot of " + this.getShortTitle(this.imp), string, this.yLabel, this.xValues, fArray);
        if (n != 0) {
            double[] dArray = Tools.getMinMax(this.xValues);
            plot.setLimits(dArray[0], dArray[1], fixedMin, fixedMax);
        }
        return plot;
    }

    String getShortTitle(ImagePlus imagePlus) {
        String string = imagePlus.getTitle();
        int n = string.lastIndexOf(46);
        if (n > 0 && string.length() - n <= 5) {
            string = string.substring(0, n);
        }
        return string;
    }

    public double[] getProfile() {
        return this.profile;
    }

    public double getMin() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.max;
    }

    public static void setMinAndMax(double d, double d2) {
        fixedMin = d;
        fixedMax = d2;
        IJ.register(ProfilePlot.class);
    }

    public static double getFixedMin() {
        return fixedMin;
    }

    public static double getFixedMax() {
        return fixedMax;
    }

    double[] getStraightLineProfile(Roi roi, Calibration calibration, ImageProcessor imageProcessor) {
        imageProcessor.setInterpolate(PlotWindow.interpolate);
        Line line = (Line)roi;
        double[] dArray = line.getPixels();
        if (dArray == null) {
            return null;
        }
        if (calibration != null && calibration.pixelWidth != calibration.pixelHeight) {
            double d = calibration.pixelWidth * (double)(line.x2 - line.x1);
            double d2 = calibration.pixelHeight * (double)(line.y2 - line.y1);
            double d3 = Math.round(Math.sqrt(d * d + d2 * d2));
            if (dArray.length > 1) {
                this.xInc = d3 / (double)(dArray.length - 1);
            }
        }
        return dArray;
    }

    double[] getRowAverageProfile(Rectangle rectangle, Calibration calibration, ImageProcessor imageProcessor) {
        int n;
        double[] dArray = new double[rectangle.height];
        imageProcessor.setInterpolate(false);
        for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
            double[] dArray2 = imageProcessor.getLine(n, rectangle.y, n, rectangle.y + rectangle.height - 1);
            for (int i = 0; i < rectangle.height; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + dArray2[i];
            }
        }
        n = 0;
        while (n < rectangle.height) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / (double)rectangle.width;
        }
        if (calibration != null) {
            this.xInc = calibration.pixelHeight;
        }
        return dArray;
    }

    double[] getColumnAverageProfile(Rectangle rectangle, ImageProcessor imageProcessor) {
        int n;
        double[] dArray = new double[rectangle.width];
        imageProcessor.setInterpolate(false);
        for (n = rectangle.y; n < rectangle.y + rectangle.height; ++n) {
            double[] dArray2 = imageProcessor.getLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
            for (int i = 0; i < rectangle.width; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + dArray2[i];
            }
        }
        n = 0;
        while (n < rectangle.width) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / (double)rectangle.height;
        }
        return dArray;
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor imageProcessor, Calibration calibration) {
        boolean bl = PlotWindow.interpolate;
        boolean bl2 = calibration != null && calibration.pixelWidth != calibration.pixelHeight;
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] nArray = ((PolygonRoi)roi).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
        Rectangle rectangle = roi.getBounds();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        double d = 0.0;
        double[] dArray = new double[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            int n4 = nArray[i + 1] - nArray[i];
            int n5 = nArray2[i + 1] - nArray2[i];
            double d2 = Math.sqrt(n4 * n4 + n5 * n5);
            d += d2;
            dArray[i] = d2;
            nArray3[i] = n4;
            nArray4[i] = n5;
        }
        double[] dArray2 = new double[(int)d];
        if (bl2) {
            this.xValues = new float[(int)d];
        }
        double d3 = 1.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d8 = dArray[i];
            if (d8 == 0.0) continue;
            double d9 = (double)nArray3[i] / d8;
            double d10 = (double)nArray4[i] / d8;
            double d11 = 1.0 - d3;
            double d12 = (double)(n2 + nArray[i]) + d11 * d9;
            double d13 = (double)(n3 + nArray2[i]) + d11 * d10;
            double d14 = d8 - d11;
            int n6 = (int)d14;
            for (int j = 0; j <= n6; ++j) {
                int n7 = (int)d4 + j;
                if (n7 < dArray2.length) {
                    dArray2[n7] = bl ? imageProcessor.getInterpolatedValue(d12, d13) : (double)imageProcessor.getPixelValue((int)(d12 + 0.5), (int)(d13 + 0.5));
                    if (bl2 && n7 > 0) {
                        double d15 = calibration.pixelWidth * (d12 - d5);
                        double d16 = calibration.pixelHeight * (d13 - d6);
                        this.xValues[n7] = (float)(d7 += Math.sqrt(d15 * d15 + d16 * d16));
                    }
                    d5 = d12;
                    d6 = d13;
                }
                d12 += d9;
                d13 += d10;
            }
            d4 += d8;
            d3 = d14 - (double)n6;
        }
        return dArray2;
    }

    double[] getWideLineProfile(ImagePlus imagePlus, int n) {
        int n2;
        Roi roi = (Roi)imagePlus.getRoi().clone();
        ImageProcessor imageProcessor = new Straightener().straightenLine(imagePlus, n);
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        this.profile = new double[n3];
        imageProcessor.setInterpolate(false);
        for (n2 = 0; n2 < n4; ++n2) {
            double[] dArray = imageProcessor.getLine(0.0, n2, n3 - 1, n2);
            for (int i = 0; i < n3; ++i) {
                int n5 = i;
                this.profile[n5] = this.profile[n5] + dArray[i];
            }
        }
        n2 = 0;
        while (n2 < n3) {
            int n6 = n2++;
            this.profile[n6] = this.profile[n6] / (double)n4;
        }
        imagePlus.setRoi(roi);
        if (roi.getType() == 6 && !((PolygonRoi)roi).isSplineFit()) {
            ((PolygonRoi)roi).fitSpline();
            imagePlus.draw();
        }
        return this.profile;
    }

    void findMinAndMax() {
        if (this.profile == null) {
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i = 0; i < this.profile.length; ++i) {
            double d3 = this.profile[i];
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        this.min = d;
        this.max = d2;
    }
}

