/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.plugin.Colors;
import java.awt.Color;
import java.awt.Font;

public class RoiProperties {
    private Roi roi;
    private String title;
    private boolean showName = true;
    private boolean addToOverlay;
    private boolean overlayOptions;
    private boolean existingOverlay;
    private boolean setPositions;
    private static final String[] justNames = new String[]{"Left", "Center", "Right"};

    public RoiProperties(String string, Roi roi) {
        if (roi == null) {
            throw new IllegalArgumentException("ROI is null");
        }
        this.title = string;
        this.showName = string.startsWith("Prop");
        this.addToOverlay = string.equals("Add to Overlay");
        this.overlayOptions = string.equals("Overlay Options");
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (this.overlayOptions) {
            Overlay overlay = imagePlus != null ? imagePlus.getOverlay() : null;
            boolean bl = this.setPositions = roi.getPosition() != 0;
            if (overlay != null) {
                this.existingOverlay = true;
            }
        }
        this.roi = roi;
    }

    private String decodeColor(Color color, Color color2) {
        String string;
        String string2;
        if (color == null) {
            color = color2;
        }
        if ((string2 = "#" + Integer.toHexString(color.getRGB())).length() == 9 && string2.startsWith("#ff")) {
            string2 = "#" + string2.substring(3);
        }
        if ((string = Colors.hexToColor(string2)) != null) {
            string2 = string;
        }
        return string2;
    }

    public boolean showDialog() {
        Object object;
        Cloneable cloneable;
        boolean bl;
        String string;
        Object object2;
        Object object3;
        double d;
        String string2;
        Color color = null;
        Color color2 = null;
        double d2 = 1.0;
        String string3 = this.roi.getName();
        boolean bl2 = string3 != null && string3.startsWith("range: ");
        String string4 = string2 = bl2 ? "Range:" : "Name:";
        if (bl2) {
            string3 = string3.substring(7);
        }
        if (string3 == null) {
            string3 = "";
        }
        if (!bl2 && this.roi instanceof ImageRoi) {
            return this.showImageDialog(string3);
        }
        if (this.roi.getStrokeColor() != null) {
            color = this.roi.getStrokeColor();
        }
        if (color == null) {
            color = Roi.getColor();
        }
        if (this.roi.getFillColor() != null) {
            color2 = this.roi.getFillColor();
        }
        if ((d = (double)this.roi.getStrokeWidth()) > 1.0) {
            d2 = d;
        }
        boolean bl3 = this.roi instanceof TextRoi;
        boolean bl4 = this.roi.isLine();
        int n = 0;
        if (bl3) {
            object3 = (TextRoi)this.roi;
            object2 = ((TextRoi)object3).getCurrentFont();
            d2 = ((Font)object2).getSize();
            n = ((TextRoi)object3).getJustification();
        }
        Object object4 = object3 = color != null ? "#" + Integer.toHexString(color.getRGB()) : "none";
        if (((String)object3).length() == 9 && ((String)object3).startsWith("#ff")) {
            object3 = "#" + ((String)object3).substring(3);
        }
        if ((object2 = Colors.hexToColor((String)object3)) != null) {
            object3 = object2;
        }
        String string5 = string = color2 != null ? "#" + Integer.toHexString(color2.getRGB()) : "none";
        if (IJ.isMacro()) {
            string = "none";
        }
        int n2 = (double)((int)d2) == d2 ? 0 : 1;
        GenericDialog genericDialog = new GenericDialog(this.title);
        if (this.showName) {
            genericDialog.addStringField(string2, string3, 15);
        }
        genericDialog.addStringField("Stroke color: ", (String)object3);
        if (bl3) {
            genericDialog.addNumericField("Font size:", d2, n2);
            genericDialog.addChoice("Justification:", justNames, justNames[n]);
        } else {
            genericDialog.addNumericField("Width:", d2, n2);
        }
        if (!bl4) {
            genericDialog.addMessage("");
            genericDialog.addStringField("Fill color: ", string);
        }
        if (this.addToOverlay) {
            genericDialog.addCheckbox("New overlay", false);
        }
        if (this.overlayOptions) {
            if (this.existingOverlay) {
                genericDialog.addCheckbox("Apply to current overlay", false);
            }
            genericDialog.addCheckbox("Set stack positions", this.setPositions);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        if (this.showName) {
            string3 = genericDialog.getNextString();
            if (!bl2) {
                this.roi.setName(string3.length() > 0 ? string3 : null);
            }
        }
        object3 = genericDialog.getNextString();
        d2 = genericDialog.getNextNumber();
        if (bl3) {
            n = genericDialog.getNextChoiceIndex();
        }
        if (!bl4) {
            string = genericDialog.getNextString();
        }
        boolean bl5 = false;
        boolean bl6 = bl = this.addToOverlay ? genericDialog.getNextBoolean() : false;
        if (this.overlayOptions) {
            if (this.existingOverlay) {
                bl5 = genericDialog.getNextBoolean();
            }
            this.setPositions = genericDialog.getNextBoolean();
            this.roi.setPosition(this.setPositions ? 1 : 0);
        }
        color = Colors.decode((String)object3, Roi.getColor());
        color2 = Colors.decode(string, null);
        if (bl3) {
            cloneable = (TextRoi)this.roi;
            object = ((TextRoi)cloneable).getCurrentFont();
            if ((int)d2 != ((Font)object).getSize()) {
                object = new Font(((Font)object).getName(), ((Font)object).getStyle(), (int)d2);
                ((TextRoi)cloneable).setCurrentFont((Font)object);
            }
            if (n != ((TextRoi)cloneable).getJustification()) {
                ((TextRoi)cloneable).setJustification(n);
            }
        } else if (d2 != 1.0 || this.roi.getStroke() != null) {
            this.roi.setStrokeWidth((float)d2);
        }
        this.roi.setStrokeColor(color);
        this.roi.setFillColor(color2);
        if (bl) {
            this.roi.setName("new-overlay");
        }
        if (bl5) {
            cloneable = WindowManager.getCurrentImage();
            if (cloneable == null) {
                return true;
            }
            object = ((ImagePlus)cloneable).getOverlay();
            if (object == null) {
                return true;
            }
            Roi[] roiArray = ((Overlay)object).toArray();
            for (int i = 0; i < roiArray.length; ++i) {
                roiArray[i].setStrokeColor(color);
                roiArray[i].setStrokeWidth((float)d2);
                roiArray[i].setFillColor(color2);
            }
            ((ImagePlus)cloneable).draw();
        }
        return true;
    }

    public boolean showImageDialog(String string) {
        boolean bl;
        GenericDialog genericDialog = new GenericDialog(this.title);
        genericDialog.addStringField("Name:", string, 15);
        genericDialog.addNumericField("Opacity (0-100%):", ((ImageRoi)this.roi).getOpacity() * 100.0, 0);
        if (this.addToOverlay) {
            genericDialog.addCheckbox("New Overlay", false);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        string = genericDialog.getNextString();
        this.roi.setName(string.length() > 0 ? string : null);
        double d = genericDialog.getNextNumber() / 100.0;
        ((ImageRoi)this.roi).setOpacity(d);
        boolean bl2 = bl = this.addToOverlay ? genericDialog.getNextBoolean() : false;
        if (bl) {
            this.roi.setName("new-overlay");
        }
        return true;
    }
}

