/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.gui.StackWindow;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;

public class ScrollbarWithLabel
extends Panel
implements Adjustable,
AdjustmentListener {
    Scrollbar bar;
    private Icon icon;
    private StackWindow stackWindow;
    transient AdjustmentListener adjustmentListener;

    public ScrollbarWithLabel() {
    }

    public ScrollbarWithLabel(StackWindow stackWindow, int n, int n2, int n3, int n4, char c) {
        super(new BorderLayout(2, 0));
        this.stackWindow = stackWindow;
        this.bar = new Scrollbar(0, n, n2, n3, n4);
        this.icon = new Icon(c);
        this.add((Component)this.icon, "West");
        this.add((Component)this.bar, "Center");
        this.bar.addAdjustmentListener(this);
        this.addKeyListener(IJ.getInstance());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        int n = this.bar.getPreferredSize().width;
        Dimension dimension2 = this.getMinimumSize();
        if (n < dimension2.width) {
            n = dimension2.width;
        }
        int n2 = this.bar.getPreferredSize().height;
        dimension = new Dimension(n, n2);
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(80, 15);
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        this.bar.addKeyListener(keyListener);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener keyListener) {
        super.removeKeyListener(keyListener);
        this.bar.removeKeyListener(keyListener);
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
    }

    @Override
    public int getBlockIncrement() {
        return this.bar.getBlockIncrement();
    }

    @Override
    public int getMaximum() {
        return this.bar.getMaximum();
    }

    @Override
    public int getMinimum() {
        return this.bar.getMinimum();
    }

    @Override
    public int getOrientation() {
        return this.bar.getOrientation();
    }

    @Override
    public int getUnitIncrement() {
        return this.bar.getUnitIncrement();
    }

    @Override
    public int getValue() {
        return this.bar.getValue();
    }

    @Override
    public int getVisibleAmount() {
        return this.bar.getVisibleAmount();
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    @Override
    public void setBlockIncrement(int n) {
        this.bar.setBlockIncrement(n);
    }

    @Override
    public void setMaximum(int n) {
        this.bar.setMaximum(n);
    }

    @Override
    public void setMinimum(int n) {
        this.bar.setMinimum(n);
    }

    @Override
    public void setUnitIncrement(int n) {
        this.bar.setUnitIncrement(n);
    }

    @Override
    public void setValue(int n) {
        this.bar.setValue(n);
    }

    @Override
    public void setVisibleAmount(int n) {
        this.bar.setVisibleAmount(n);
    }

    @Override
    public void setFocusable(boolean bl) {
        super.setFocusable(bl);
        this.bar.setFocusable(bl);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.bar != null && adjustmentEvent.getSource() == this.bar) {
            AdjustmentEvent adjustmentEvent2 = new AdjustmentEvent(this, adjustmentEvent.getID(), adjustmentEvent.getAdjustmentType(), adjustmentEvent.getValue(), adjustmentEvent.getValueIsAdjusting());
            AdjustmentListener adjustmentListener = this.adjustmentListener;
            if (adjustmentListener != null) {
                adjustmentListener.adjustmentValueChanged(adjustmentEvent2);
            }
        }
    }

    public void updatePlayPauseIcon() {
        this.icon.repaint();
    }

    class Icon
    extends Canvas
    implements MouseListener {
        private static final int WIDTH = 12;
        private static final int HEIGHT = 14;
        private BasicStroke stroke = new BasicStroke(2.0f);
        private char type;
        private Image image;

        public Icon(char c) {
            this.addMouseListener(this);
            this.addKeyListener(IJ.getInstance());
            this.setSize(12, 14);
            this.type = c;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(12, 14);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 12, 14);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.type == 't') {
                this.drawPlayPauseButton(graphics2D);
            } else {
                this.drawLetter(graphics);
            }
        }

        private void drawLetter(Graphics graphics) {
            graphics.setFont(new Font("SansSerif", 0, 14));
            graphics.setColor(Color.black);
            graphics.drawString(String.valueOf(this.type), 2, 12);
        }

        private void drawPlayPauseButton(Graphics2D graphics2D) {
            if (ScrollbarWithLabel.this.stackWindow.getAnimate()) {
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(this.stroke);
                graphics2D.drawLine(3, 3, 3, 11);
                graphics2D.drawLine(8, 3, 8, 11);
            } else {
                graphics2D.setColor(Color.darkGray);
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(3.0f, 2.0f);
                generalPath.lineTo(10.0f, 7.0f);
                generalPath.lineTo(3.0f, 12.0f);
                generalPath.lineTo(3.0f, 2.0f);
                graphics2D.fill(generalPath);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.type != 't') {
                return;
            }
            int n = mouseEvent.getModifiers();
            if ((n & 0xE) != 0) {
                IJ.doCommand("Animation Options...");
            } else {
                IJ.doCommand("Start Animation [\\]");
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }
}

