/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.ScrollbarWithLabel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class StackWindow
extends ImageWindow
implements Runnable,
AdjustmentListener,
ActionListener,
MouseWheelListener {
    protected Scrollbar sliceSelector;
    protected ScrollbarWithLabel cSelector;
    protected ScrollbarWithLabel zSelector;
    protected ScrollbarWithLabel tSelector;
    protected Thread thread;
    protected volatile boolean done;
    protected volatile int slice;
    private ScrollbarWithLabel animationSelector;
    boolean hyperStack;
    int nChannels = 1;
    int nSlices = 1;
    int nFrames = 1;
    int c = 1;
    int z = 1;
    int t = 1;

    public StackWindow(ImagePlus imagePlus) {
        this(imagePlus, null);
    }

    public StackWindow(ImagePlus imagePlus, ImageCanvas imageCanvas) {
        super(imagePlus, imageCanvas);
        this.addScrollbars(imagePlus);
        this.addMouseWheelListener(this);
        if (this.sliceSelector == null && this.getClass().getName().indexOf("Image5D") != -1) {
            this.sliceSelector = new Scrollbar();
        }
        this.pack();
        imageCanvas = imagePlus.getCanvas();
        if (imageCanvas != null) {
            imageCanvas.setMaxBounds();
        }
        this.show();
        int n = imagePlus.getCurrentSlice();
        if (n > 1 && n <= imagePlus.getStackSize()) {
            imagePlus.setSlice(n);
        } else {
            imagePlus.setSlice(1);
        }
        this.thread = new Thread((Runnable)this, "zSelector");
        this.thread.start();
    }

    void addScrollbars(ImagePlus imagePlus) {
        int n;
        int n2;
        ImageStack imageStack = imagePlus.getStack();
        this.nSlices = n2 = imageStack.getSize();
        this.hyperStack = imagePlus.getOpenAsHyperStack();
        imagePlus.setOpenAsHyperStack(false);
        int[] nArray = imagePlus.getDimensions();
        int n3 = 2 + (nArray[2] > 1 ? 1 : 0) + (nArray[3] > 1 ? 1 : 0) + (nArray[4] > 1 ? 1 : 0);
        if (n3 <= 3 && nArray[2] != this.nSlices) {
            this.hyperStack = false;
        }
        if (this.hyperStack) {
            this.nChannels = nArray[2];
            this.nSlices = nArray[3];
            this.nFrames = nArray[4];
        }
        if (this.nSlices == n2) {
            this.hyperStack = false;
        }
        if (this.nChannels * this.nSlices * this.nFrames != n2) {
            this.hyperStack = false;
        }
        if (this.cSelector != null || this.zSelector != null || this.tSelector != null) {
            this.removeScrollbars();
        }
        ImageJ imageJ = IJ.getInstance();
        if (this.nChannels > 1) {
            this.cSelector = new ScrollbarWithLabel(this, 1, 1, 1, this.nChannels + 1, 'c');
            this.add(this.cSelector);
            if (imageJ != null) {
                this.cSelector.addKeyListener(imageJ);
            }
            this.cSelector.addAdjustmentListener(this);
            this.cSelector.setFocusable(false);
            this.cSelector.setUnitIncrement(1);
            this.cSelector.setBlockIncrement(1);
        }
        if (this.nSlices > 1) {
            int n4 = n = this.nChannels > 1 || this.nFrames > 1 ? 122 : 116;
            if (n2 == nArray[2] && imagePlus.isComposite()) {
                n = 99;
            }
            this.zSelector = new ScrollbarWithLabel(this, 1, 1, 1, this.nSlices + 1, (char)n);
            if (n == 116) {
                this.animationSelector = this.zSelector;
            }
            this.add(this.zSelector);
            if (imageJ != null) {
                this.zSelector.addKeyListener(imageJ);
            }
            this.zSelector.addAdjustmentListener(this);
            this.zSelector.setFocusable(false);
            int n5 = this.nSlices / 10;
            if (n5 < 1) {
                n5 = 1;
            }
            this.zSelector.setUnitIncrement(1);
            this.zSelector.setBlockIncrement(n5);
            this.sliceSelector = this.zSelector.bar;
        }
        if (this.nFrames > 1) {
            this.animationSelector = this.tSelector = new ScrollbarWithLabel(this, 1, 1, 1, this.nFrames + 1, 't');
            this.add(this.tSelector);
            if (imageJ != null) {
                this.tSelector.addKeyListener(imageJ);
            }
            this.tSelector.addAdjustmentListener(this);
            this.tSelector.setFocusable(false);
            n = this.nFrames / 10;
            if (n < 1) {
                n = 1;
            }
            this.tSelector.setUnitIncrement(1);
            this.tSelector.setBlockIncrement(n);
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.running2 || this.imp.isHyperStack()) {
            if (adjustmentEvent.getSource() == this.cSelector) {
                this.c = this.cSelector.getValue();
                if (this.c == this.imp.getChannel() && adjustmentEvent.getAdjustmentType() == 5) {
                    return;
                }
            } else if (adjustmentEvent.getSource() == this.zSelector) {
                int n;
                this.z = this.zSelector.getValue();
                int n2 = n = this.hyperStack ? this.imp.getSlice() : this.imp.getCurrentSlice();
                if (this.z == n && adjustmentEvent.getAdjustmentType() == 5) {
                    return;
                }
            } else if (adjustmentEvent.getSource() == this.tSelector) {
                this.t = this.tSelector.getValue();
                if (this.t == this.imp.getFrame() && adjustmentEvent.getAdjustmentType() == 5) {
                    return;
                }
            }
            this.updatePosition();
            this.notify();
        }
    }

    void updatePosition() {
        this.slice = (this.t - 1) * this.nChannels * this.nSlices + (this.z - 1) * this.nChannels + this.c;
        this.imp.updatePosition(this.c, this.z, this.t);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            int n = mouseWheelEvent.getWheelRotation();
            if (this.hyperStack) {
                if (n > 0) {
                    IJ.run(this.imp, "Next Slice [>]", "");
                } else if (n < 0) {
                    IJ.run(this.imp, "Previous Slice [<]", "");
                }
            } else {
                int n2 = this.imp.getCurrentSlice() + n;
                if (n2 < 1) {
                    n2 = 1;
                } else if (n2 > this.imp.getStack().getSize()) {
                    n2 = this.imp.getStack().getSize();
                }
                this.imp.setSlice(n2);
                this.imp.updateStatusbarValue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        if (!super.close()) {
            return false;
        }
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            this.done = true;
            this.notify();
        }
        return true;
    }

    public void showSlice(int n) {
        if (this.imp != null && n >= 1 && n <= this.imp.getStackSize()) {
            this.imp.setSlice(n);
        }
    }

    public void updateSliceSelector() {
        if (this.hyperStack || this.zSelector == null) {
            return;
        }
        int n = this.imp.getStackSize();
        int n2 = this.zSelector.getMaximum();
        if (n2 != n + 1) {
            this.zSelector.setMaximum(n + 1);
        }
        this.zSelector.setValue(this.imp.getCurrentSlice());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            StackWindow stackWindow = this;
            synchronized (stackWindow) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            if (this.slice <= 0) continue;
            int n = this.slice;
            this.slice = 0;
            if (n == this.imp.getCurrentSlice()) continue;
            this.imp.setSlice(n);
        }
    }

    @Override
    public String createSubtitle() {
        String string = super.createSubtitle();
        if (!this.hyperStack) {
            return string;
        }
        String string2 = "";
        int[] nArray = this.imp.getDimensions();
        int n = nArray[2];
        int n2 = nArray[3];
        int n3 = nArray[4];
        if (n > 1) {
            string2 = string2 + "c:" + this.imp.getChannel() + "/" + n;
            if (n2 > 1 || n3 > 1) {
                string2 = string2 + " ";
            }
        }
        if (n2 > 1) {
            string2 = string2 + "z:" + this.imp.getSlice() + "/" + n2;
            if (n3 > 1) {
                string2 = string2 + " ";
            }
        }
        if (n3 > 1) {
            string2 = string2 + "t:" + this.imp.getFrame() + "/" + n3;
        }
        if (this.running2) {
            return string2;
        }
        int n4 = string.indexOf(";");
        if (n4 != -1) {
            int n5 = string.indexOf("(");
            if (n5 >= 0 && n5 < n4 && string.length() > n5 + 4 && !string.substring(n5 + 1, n5 + 4).equals("ch:")) {
                n4 = n5;
                string2 = string2 + " ";
            }
            string = string.substring(n4, string.length());
        } else {
            string = "";
        }
        return string2 + string;
    }

    public boolean isHyperStack() {
        return this.hyperStack;
    }

    public void setPosition(int n, int n2, int n3) {
        if (this.cSelector != null && n != this.c) {
            this.c = n;
            this.cSelector.setValue(n);
        }
        if (this.zSelector != null && n2 != this.z) {
            this.z = n2;
            this.zSelector.setValue(n2);
        }
        if (this.tSelector != null && n3 != this.t) {
            this.t = n3;
            this.tSelector.setValue(n3);
        }
        this.updatePosition();
        if (this.slice > 0) {
            int n4 = this.slice;
            this.slice = 0;
            if (n4 != this.imp.getCurrentSlice()) {
                this.imp.setSlice(n4);
            }
        }
    }

    public boolean validDimensions() {
        int n = this.imp.getNChannels();
        int n2 = this.imp.getNSlices();
        int n3 = this.imp.getNFrames();
        return n == this.nChannels && n2 == this.nSlices && n3 == this.nFrames && n * n2 * n3 == this.imp.getStackSize();
    }

    public void setAnimate(boolean bl) {
        if (this.running2 != bl && this.animationSelector != null) {
            this.animationSelector.updatePlayPauseIcon();
        }
        this.running2 = bl;
    }

    public boolean getAnimate() {
        return this.running2;
    }

    public int getNScrollbars() {
        int n = 0;
        if (this.cSelector != null) {
            ++n;
        }
        if (this.zSelector != null) {
            ++n;
        }
        if (this.tSelector != null) {
            ++n;
        }
        return n;
    }

    void removeScrollbars() {
        if (this.cSelector != null) {
            this.remove(this.cSelector);
            this.cSelector.removeAdjustmentListener(this);
            this.cSelector = null;
        }
        if (this.zSelector != null) {
            this.remove(this.zSelector);
            this.zSelector.removeAdjustmentListener(this);
            this.zSelector = null;
        }
        if (this.tSelector != null) {
            this.remove(this.tSelector);
            this.tSelector.removeAdjustmentListener(this);
            this.tSelector = null;
        }
    }
}

